@extends('layouts.main')
@section('content')

<section class="ui raised segment" style="max-width: 1200px; margin: 20px auto;">
    @include('partial.error')
    <h2 class="ui horizontal divider header" style="color:#dc4900;">
        <i class="calendar alternate icon"></i>
        {{$title}}
    </h2>
    <form class="ui form" action="{{route('admin.school.create.timetable')}}" method="post">
		<input type="hidden" name="_token" value="{{csrf_token()}}">
		<input type="hidden" name="timetable_id" value="{{$timetable->first()->id}}">
        <h2 class="ui dividing header">Create Peroid</h2>
        <div class="six fields">
            <div class="ui field">
	            <label>Time</label>
                <input type="text" placeholder="Time" required name="time">
            </div>
	        <div class="field">
	          <label>Monday</label>
	          <div class="ui fluid search selection dropdown">
	            <input type="hidden" name="monday" value="{{old('monday')}}">
	            <i class="dropdown icon"></i>
	            <div class="default text">Monday</div>
	            <div class="menu">
                    <div class="item" data-value="Long Break">Long Break</div>
                    <div class="item" data-value="Short Break">Short Break</div>
	              @foreach($subjects as $subject)
	               <div class="item" data-value="{{$subject->subject_name}} {{$subject->subject_code}}">{{$subject->subject_name}} ({{$subject->subject_code}})</div>
	              @endforeach
	            </div>
	          </div>
	        </div>


	        <div class="field">
	          <label>Tuesday</label>
	          <div class="ui fluid search selection dropdown">
	            <input type="hidden" name="tuesday" value="{{old('tuesday')}}">
	            <i class="dropdown icon"></i>
	            <div class="default text">Tuesday</div>
	            <div class="menu">
                    <div class="item" data-value="Long Break">Long Break</div>
                    <div class="item" data-value="Short Break">Short Break</div>
	              @foreach($subjects as $subject)
	               <div class="item" data-value="{{$subject->subject_name}} ({{$subject->subject_code}})">{{$subject->subject_name}} ({{$subject->subject_code}})</div>
	              @endforeach
	            </div>
	          </div>
	        </div>
		    

	        <div class="field">
	          <label>Wednesday</label>
	          <div class="ui fluid search selection dropdown">
	            <input type="hidden" name="wednesday" value="{{old('wednesday')}}">
	            <i class="dropdown icon"></i>
	            <div class="default text">Wednesday</div>
	            <div class="menu">
                    <div class="item" data-value="Long Break">Long Break</div>
                    <div class="item" data-value="Short Break">Short Break</div>
	              @foreach($subjects as $subject)
	               <div class="item" data-value="{{$subject->subject_name}} ({{$subject->subject_code}})">{{$subject->subject_name}} ({{$subject->subject_code}})</div>
	              @endforeach
	            </div>
	          </div>
	        </div>


	        <div class="field">
	          <label>Thursday</label>
	          <div class="ui fluid search selection dropdown">
	            <input type="hidden" name="thursday" value="{{old('thursday')}}">
	            <i class="dropdown icon"></i>
	            <div class="default text">Thursday</div>
	            <div class="menu">
                    <div class="item" data-value="Long Break">Long Break</div>
                    <div class="item" data-value="Short Break">Short Break</div>
	              @foreach($subjects as $subject)
	               <div class="item" data-value="{{$subject->subject_name}} ({{$subject->subject_code}})">{{$subject->subject_name}} ({{$subject->subject_code}})</div>
	              @endforeach
	            </div>
	          </div>
	        </div>


	        <div class="field">
	          <label>Friday</label>
	          <div class="ui fluid search selection dropdown">
	            <input type="hidden" name="friday" value="{{old('friday')}}">
	            <i class="dropdown icon"></i>
	            <div class="default text">Friday</div>
	            <div class="menu">
                    <div class="item" data-value="Long Break">Long Break</div>
                    <div class="item" data-value="Short Break">Short Break</div>
	              @foreach($subjects as $subject)
	               <div class="item" data-value="{{$subject->subject_name}} ({{$subject->subject_code}})">{{$subject->subject_name}} ({{$subject->subject_code}})</div>
	              @endforeach
	            </div>
	          </div>
	        </div>

            
            <div class="field">
                <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">Create</button>
            </div>

	    </div>
		  
	</form>
    <table class="ui compact celled definition table">
        <thead class="full-width">
            <tr>
                <th></th>
                <th>Monday</th>
                <th>Tuesday</th>
                <th>Wednesday</th>
                <th>Thursday</th>
                <th>Friday</th>
            </tr>
        </thead>
        <tbody>
        <?php $timetablePeriods = $timetable->first()->period; ?>
        @if($timetablePeriods->count() > 0)
            @foreach($timetablePeriods as $timetablePeriod)
            <tr>
                <td class="collapsing">{{$timetablePeriod->time}}</td>
                <td>{{$timetablePeriod->monday}}</td>
                <td>{{$timetablePeriod->tuesday}}</td>
                <td>{{$timetablePeriod->wednesday}}</td>
                <td>{{$timetablePeriod->thursday}}</td>
                <td>{{$timetablePeriod->friday}}</td>
            </tr>
            @endforeach
        @endif
        </tbody>
        <tfoot class="full-width">
            <tr>
            <th></th>
            <th>Created at: {{$timetable->first()->created_at->diffForHumans()}}</th>
            <th>Updated at: {{$timetable->first()->updated_at->diffForHumans()}}</th>
            <th></th>
            <th>
                <a href="{{route('admin.school.edit.timetable')}}/{{$timetable->first()->id}}" class="ui small fluid primary labeled icon button">
                    <i class="edit icon"></i> Edit Table
                </a>
            </th>
			<form action="{{route('admin.school.delete.timetable')}}" method="POST">
			{{csrf_field()}}
			<input type="hidden" name="timetable_id" value="{{$timetable->first()->id}}">
            <th>
                <button class="ui small fluid red labeled icon button">
                <i class="trash icon"></i> Delete Table
                </butotn>
            </th>
			</form>
            </tr>
        </tfoot>
    </table>
</section>
@endsection