@extends('layouts.main')
@section('content')
    <br>
    <div style="display:flex;" class="survey-form">
        <form method="POST" action="" style="padding: 0px 5px 10px 50px;width: 850px;">
            <input type="hidden" name="_token" value="{{csrf_token()}}">
            <input type="hidden" name="school_id" value="{{$school->id}}">
            <input type="hidden" name="session" value="{{$session}}">
            <div class="ui page-count">
                <a data-page="1" onclick="switchPage(1)" class="ui black circular label">1</a>
                <a data-page="2" onclick="switchPage(2)" class="ui grey circular label">2</a>
                <a data-page="3" onclick="switchPage(3)" class="ui grey circular label">3</a>
                <a data-page="4" onclick="switchPage(4)" class="ui grey circular label">4</a>
            </div>
            <div class="ui raised segment" data-page="1">
                <div style="text-align: center;">
                    <img src="{{url_public($school->logo)}}" style="width: 250px;border-radius: 20px;">
                    <h1 style="text-transform: uppercase;">{{ucwords($school->name)}}'s Session <br> Questionnaire Survey For {{$session}}</h1>
                </div>
                <a class="ui black ribbon label">School Particulars</a>
                <div class="field">
                    <ul class="ui list">
                        <li>
                            Name Of School: 
                            <div class="ui input" style="pointer-events: none;">
                              <input type="text" name="name_of_school" value="{{$school->name}}" >
                            </div>
                        </li>
                        <li>
                            Town:
                            <div class="ui input">
                              <input type="text" @if(isset($survey)) value="{{$survey->town}}" @endif name="town" >
                            </div>
                        </li>
                      <li>Location:
                        <ul>
                            <li>
                              <div class="ui form">
                                  <div class="inline fields">
                                    <div class="field">
                                      <div class="ui radio checkbox">
                                        <input type="radio" @if(isset($survey)) data-selected="{{$survey->location}}" @endif name="location" value="revenue" tabindex="0" class="hidden">
                                        <label>a) Revenue</label>
                                      </div>
                                    </div>
                                    <div class="field">
                                      <div class="ui radio checkbox">
                                        <input type="radio" @if(isset($survey)) data-selected="{{$survey->location}}" @endif name="location" value="rural" tabindex="0" class="hidden">
                                        <label>b) Rural</label>
                                      </div>
                                    </div>
                                    <div class="field">
                                      <div class="ui radio checkbox">
                                        <input type="radio" @if(isset($survey)) data-selected="{{$survey->location}}" @endif name="location" value="urban" tabindex="0" class="hidden">
                                        <label>c) Urban</label>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                            </li>
                        </ul>
                      </li>
                      <li>
                            Local Government Area:
                            <div class="ui input" style="pointer-events: none;">
                              <input type="text" @if(isset($survey)) value="{{$survey->local_government_area}}" @endif name="local_government_area" value="{{$school->ondoLga->name}}" >
                            </div>
                      </li>
                      <li>Type Of Institution:
                        <ul>
                            <li>
                              <div class="ui form">
                                  <div class="inline fields">
                                    <div class="field">
                                      <div class="ui radio checkbox">
                                        <input type="radio" @if(isset($survey)) data-selected="{{$survey->type_of_institution}}" @endif name="type_of_institution" value="boys only" tabindex="0" class="hidden">
                                        <label>a) Boys only</label>
                                      </div>
                                    </div>
                                    <div class="field">
                                      <div class="ui radio checkbox">
                                        <input type="radio" @if(isset($survey)) data-selected="{{$survey->type_of_institution}}" @endif name="type_of_institution" value="girls only" tabindex="0" class="hidden">
                                        <label>b) Girls only</label>
                                      </div>
                                    </div>
                                    <div class="field">
                                      <div class="ui radio checkbox">
                                        <input type="radio" @if(isset($survey)) data-selected="{{$survey->type_of_institution}}" @endif name="type_of_institution" value="mixed" tabindex="0" class="hidden">
                                        <label>c) Mixed</label>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                            </li>
                        </ul>
                        <ul>
                        </ul>
                      </li>
                      <li>
                          Post Office Box / PMB:
                            <div class="ui input">
                              <input type="text" @if(isset($survey)) value="{{$survey->post_office_box}}" @endif name="post_office_box" >
                            </div>
                        </li>
                      <li>
                          Email Address:
                            <div class="ui input">
                              <input type="email" @if(isset($survey)) value="{{$survey->email_address}}" @endif name="email_address" >
                            </div>
                        </li>
                    </ul>
                </div>
                <a class="ui black ribbon label">Principal / Vice Principal(s) Contact</a>
                <div class="field">
                    <ul class="ui list">
                        <li>
                            Name Of Principal: 
                            <div class="ui input">
                              <input type="text" @if(isset($survey)) value="{{$survey->name_of_principal}}" @endif name="name_of_principal" >
                            </div>
                        </li>
                        <li>
                            Phone Number Of Principal:
                            <div class="ui input">
                              <input type="text" @if(isset($survey)) value="{{$survey->phone_of_principal}}" @endif name="phone_of_principal" >
                            </div>
                        </li>
                        <li>
                            Name Of Vice Principal: 
                            <div class="ui input">
                              <input type="text" @if(isset($survey)) value="{{$survey->name_of_vice_principal}}" @endif name="name_of_vice_principal">
                            </div>
                        </li>
                        <li>
                            Phone Number Of Vice Principal:
                            <div class="ui input">
                              <input type="text" @if(isset($survey)) value="{{$survey->phone_of_vice_principal}}" @endif name="phone_of_vice_principal">
                            </div>
                        </li>
                        <li>
                            Name Of Vice Principal: 
                            <div class="ui input">
                              <input type="text" @if(isset($survey)) value="{{$survey->name_of_vice_principal_two}}" @endif name="name_of_vice_principal_two">
                            </div>
                        </li>
                        <li>
                            Phone Number Of Vice Principal:
                            <div class="ui input">
                              <input type="text" @if(isset($survey)) value="{{$survey->phone_of_vice_principal_two}}" @endif name="phone_of_vice_principal_two">
                            </div>
                        </li>
                        <li>
                            Name Of Vice Principal: 
                            <div class="ui input">
                              <input type="text" @if(isset($survey)) value="{{$survey->name_of_vice_principal_three}}" @endif name="name_of_vice_principal_three">
                            </div>
                        </li>
                        <li>
                            Phone Number Of Vice Principal:
                            <div class="ui input">
                              <input type="text" @if(isset($survey)) value="{{$survey->phone_of_vice_principal_three}}" @endif name="phone_of_vice_principal_three">
                            </div>
                        </li>
                        <li>
                            Name Of Vice Principal: 
                            <div class="ui input">
                              <input type="text" @if(isset($survey)) value="{{$survey->name_of_vice_principal_four}}" @endif name="name_of_vice_principal_four">
                            </div>
                        </li>
                        <li>
                            Phone Number Of Vice Principal:
                            <div class="ui input">
                              <input type="text" @if(isset($survey)) value="{{$survey->phone_of_vice_principal_four}}" @endif name="phone_of_vice_principal_four">
                            </div>
                        </li>
                    </ul>
                </div>
                <div class="p-right">
                    <button type="button" class="ui right black labeled icon button" onclick="switchPage(2)">
                      <i class="right arrow icon"></i>
                      Next
                    </button>
                </div>
                <div style="clear: both;"></div>
            </div>
            <div class="ui raised segment hidden" data-page="2">
                <a class="ui black ribbon label">Enrolment</a>
                <div class="field">
                    <ul class="ui list">
                        <li>
                            Number Of Students: 
                            <div class="ui input">
                              <input type="text" @if(isset($survey)) value="{{$survey->number_of_students}}" @endif name="number_of_students" >
                            </div>
                        </li>
                        <li style="display: flex;">
                            <div style="align-self: center;margin-right: 8px;">Total Number Of Students:</div>
                            <div class="ui form">
                              <div class="inline fields">
                                <div class="eight wide field">
                                  <label>Boys: </label>
                                  <input type="text" @if(isset($survey)) value="{{$survey->total_number_of_boys}}" @endif name="total_number_of_boys" >
                                </div>
                                <div class="eight wide field">
                                    <label>Girls: </label>
                                    <input type="text" @if(isset($survey)) value="{{$survey->total_number_of_girls}}" @endif name="total_number_of_girls" >
                                </div>
                              </div>
                            </div>
                        </li>
                        <li>Total Number Of Students In <b>Boarding System</b>:
                            <div class="ui form">
                              <div class="inline fields">
                                <div class="eight wide field">
                                  <label>Boys: </label>
                                  <input type="text" @if(isset($survey)) value="{{$survey->total_number_of_boys_in_boarding}}" @endif name="total_number_of_boys_in_boarding" >
                                </div>
                                <div class="eight wide field">
                                    <label>Girls: </label>
                                    <input type="text" @if(isset($survey)) value="{{$survey->total_number_of_girls_in_boarding}}" @endif name="total_number_of_girls_in_boarding" >
                                </div>
                              </div>
                            </div>
                        </li>
                        <li>
                            <table class="ui celled table num_table">
                              <thead>
                                <tr><th>Classes</th>
                                <th>Stream</th>
                                <th>Average Age</th>
                                <th>MALE</th>
                                <th>FEMALE</th>
                                <th>TOTAL</th>
                              </tr></thead>
                              <tbody>
                                <tr class="last_total">
                                    <td data-label="Classes">
                                        JSS1
                                    </td>
                                    <td data-label="Stream">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss1_stream}}" @endif name="jss1_stream" >
                                        </div>
                                    </td>
                                    <td data-label="Average Age">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss1_average_age}}" @endif name="jss1_average_age" >
                                        </div>
                                    </td>
                                    <td data-label="MALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss1_male}}" @endif name="jss1_male" >
                                        </div>  
                                    </td>
                                    <td data-label="FEMALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss1_female}}" @endif name="jss1_female" >
                                        </div>  
                                    </td>
                                    <td data-label="TOTAL">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss1_total}}" @endif name="jss1_total" >
                                        </div>  
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td data-label="Classes">
                                        JSS2
                                    </td>
                                    <td data-label="Stream">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss2_stream}}" @endif name="jss2_stream" >
                                        </div>
                                    </td>
                                    <td data-label="Average Age">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss2_average_age}}" @endif name="jss2_average_age" >
                                        </div>
                                    </td>
                                    <td data-label="MALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss2_male}}" @endif name="jss2_male" >
                                        </div>  
                                    </td>
                                    <td data-label="FEMALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss2_female}}" @endif name="jss2_female" >
                                        </div>  
                                    </td>
                                    <td data-label="TOTAL">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss2_total}}" @endif name="jss2_total" >
                                        </div>  
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td data-label="Classes">
                                        JSS3
                                    </td>
                                    <td data-label="Stream">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss3_stream}}" @endif name="jss3_stream" >
                                        </div>
                                    </td>
                                    <td data-label="Average Age">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss3_average_age}}" @endif name="jss3_average_age" >
                                        </div>
                                    </td>
                                    <td data-label="MALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss3_male}}" @endif name="jss3_male" >
                                        </div>  
                                    </td>
                                    <td data-label="FEMALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss3_female}}" @endif name="jss3_female" >
                                        </div>  
                                    </td>
                                    <td data-label="TOTAL">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss3_total}}" @endif name="jss3_total" >
                                        </div>  
                                    </td>
                                </tr> 
                                <tr class="last_total">
                                    <td data-label="Classes">
                                        SSS1
                                    </td>
                                    <td data-label="Stream">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->sss1_stream}}" @endif name="sss1_stream" >
                                        </div>
                                    </td>
                                    <td data-label="Average Age">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->sss1_average_age}}" @endif name="sss1_average_age" >
                                        </div>
                                    </td>
                                    <td data-label="MALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->sss1_male}}" @endif name="sss1_male" >
                                        </div>  
                                    </td>
                                    <td data-label="FEMALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->sss1_female}}" @endif name="sss1_female" >
                                        </div>  
                                    </td>
                                    <td data-label="TOTAL">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->sss1_total}}" @endif name="sss1_total" >
                                        </div>  
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td data-label="Classes">
                                        SSS2
                                    </td>
                                    <td data-label="Stream">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->sss2_stream}}" @endif name="sss2_stream" >
                                        </div>
                                    </td>
                                    <td data-label="Average Age">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->sss2_average_age}}" @endif name="sss2_average_age" >
                                        </div>
                                    </td>
                                    <td data-label="MALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->sss2_male}}" @endif name="sss2_male" >
                                        </div>  
                                    </td>
                                    <td data-label="FEMALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->sss2_female}}" @endif name="sss2_female" >
                                        </div>  
                                    </td>
                                    <td data-label="TOTAL">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->sss2_total}}" @endif name="sss2_total" >
                                        </div>  
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td data-label="Classes">
                                        SSS3
                                    </td>
                                    <td data-label="Stream">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->sss3_stream}}" @endif name="sss3_stream" >
                                        </div>
                                    </td>
                                    <td data-label="Average Age">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->sss3_average_age}}" @endif name="sss3_average_age" >
                                        </div>
                                    </td>
                                    <td data-label="MALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->sss3_male}}" @endif name="sss3_male" >
                                        </div>  
                                    </td>
                                    <td data-label="FEMALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->sss3_female}}" @endif name="sss3_female" >
                                        </div>  
                                    </td>
                                    <td data-label="TOTAL">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->sss3_total}}" @endif name="sss3_total" >
                                        </div>  
                                    </td>
                                </tr>
                                <tr class="full_total">
                                    <td data-label="Classes">
                                        TOTAL:
                                    </td>
                                    <td data-label="Stream">
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->total_stream}}" @endif name="total_stream" >
                                        </div>
                                    </td>
                                    <td data-label="Average Age">
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->total_average_age}}" @endif name="total_average_age" >
                                        </div>
                                    </td>
                                    <td data-label="MALE">
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->total_male}}" @endif name="total_male" >
                                        </div>  
                                    </td>
                                    <td data-label="FEMALE">
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->total_female}}" @endif name="total_female" >
                                        </div>  
                                    </td>
                                    <td data-label="TOTAL">
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->main_total}}" @endif name="main_total" >
                                        </div>  
                                    </td>
                                </tr>
                              </tbody>
                            </table>
                        </li>
                    </ul>
                </div>
                <a class="ui black ribbon label">Students Disposition By Subjects Offered In Senior Secondary School</a>
                <div class="field">
                    <ul class="ui list">
                        <li>
                            <table class="ui celled structured table num_table">
                              <thead>
                                <tr>
                                  <th rowspan="2">AREA OF STUDIES</th>
                                  <th colspan="2">SCIENCE SUBJECTS</th>
                                  <th colspan="2">LIBERAL ARTS</th>
                                  <th colspan="2">COMMERCIAL SUBJECT</th>
                                </tr>
                                <tr>
                                  <th>MALE</th>
                                  <th>FEMALE</th>
                                  <th>MALE</th>
                                  <th>FEMALE</th>
                                  <th>MALE</th>
                                  <th>FEMALE</th>
                                </tr>
                              </thead>
                              <tbody>
                                <tr>
                                    <td>Number Of Students</td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->science_male}}" @endif name="science_male" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->science_female}}" @endif name="science_female" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->liberal_male}}" @endif name="liberal_male" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->liberal_female}}" @endif name="liberal_female" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->commericial_male}}" @endif name="commericial_male" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->commericial_female}}" @endif name="commericial_female" >
                                        </div>
                                    </td>
                                </tr>
                              </tbody>
                            </table>
                        </li>
                    </ul>
                </div>
                <a class="ui black ribbon label">Students With Disabilities</a>
                <div class="field">
                    <ul class="ui list">
                        <li>
                            <table class="ui celled table num_table">
                              <thead>
                                <tr><th>Classes</th>
                                <th>JSS1</th>
                                <th>JSS2</th>
                                <th>JSS3</th>
                                <th>SS1</th>
                                <th>SS2</th>
                                <th>SS3</th>
                                <th>TOTAL</th>
                              </tr></thead>
                              <tbody>
                                <tr class="last_total">
                                    <td data-label="Classes">
                                        Male
                                    </td>
                                    <td data-label="JSS1">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss1_male_with_disabilities}}" @endif name="jss1_male_with_disabilities" >
                                        </div>
                                    </td>
                                    <td data-label="JSS2">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss2_male_with_disabilities}}" @endif name="jss2_male_with_disabilities" >
                                        </div>
                                    </td>
                                    <td data-label="JSS3">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss3_male_with_disabilities}}" @endif name="jss3_male_with_disabilities" >
                                        </div>  
                                    </td>
                                    <td data-label="SS1">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss1_male_with_disabilities}}" @endif name="jss1_male_with_disabilities" >
                                        </div>  
                                    </td>
                                    <td data-label="SS2">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss2_male_with_disabilities}}" @endif name="jss2_male_with_disabilities" >
                                        </div>  
                                    </td>
                                    <td data-label="SS3">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss3_male_with_disabilities}}" @endif name="jss3_male_with_disabilities" >
                                        </div>  
                                    </td>
                                    <td data-label="TOTAL">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->total_male_with_disabilities}}" @endif name="total_male_with_disabilities" >
                                        </div>  
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td data-label="Classes">
                                        Female
                                    </td>
                                    <td data-label="JSS1">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss1_female_with_disabilities}}" @endif name="jss1_female_with_disabilities" >
                                        </div>
                                    </td>
                                    <td data-label="JSS2">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss2_female_with_disabilities}}" @endif name="jss2_female_with_disabilities" >
                                        </div>
                                    </td>
                                    <td data-label="JSS3">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss3_female_with_disabilities}}" @endif name="jss3_female_with_disabilities" >
                                        </div>  
                                    </td>
                                    <td data-label="SS1">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss1_female_with_disabilities}}" @endif name="jss1_female_with_disabilities" >
                                        </div>  
                                    </td>
                                    <td data-label="SS2">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss2_female_with_disabilities}}" @endif name="jss2_female_with_disabilities" >
                                        </div>  
                                    </td>
                                    <td data-label="SS3">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->jss3_female_with_disabilities}}" @endif name="jss3_female_with_disabilities" >
                                        </div>  
                                    </td>
                                    <td data-label="TOTAL">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->total_female_with_disabilities}}" @endif name="total_female_with_disabilities" >
                                        </div>  
                                    </td>
                                </tr>
                              </tbody>
                            </table>
                        </li>
                    </ul>
                </div>
                <div class="p-left">
                    <button type="button" class="ui black labeled icon button" onclick="switchPage(1)">
                      <i class="left arrow icon"></i>
                      Previous
                    </button>
                </div>
                <div class="p-right">
                    <button type="button" class="ui right black labeled icon button" onclick="switchPage(3)">
                      <i class="right arrow icon"></i>
                      Next
                    </button>
                </div>
                <div style="clear: both;"></div>
            </div>
            <div class="ui raised segment hidden" data-page="3">
                <a class="ui black ribbon label">Staffing Situation</a>
                <div class="field">
                    <ul class="ui list">
                        <li>
                            Approved Staff Quota: 
                            <div class="ui input">
                              <input type="text" @if(isset($survey)) value="{{$survey->approved_staff_qaota}}" @endif name="approved_staff_qaota" >
                            </div>
                        </li>
                        <li>
                            Total Number Of Teachers In Post: 
                            <div class="ui input">
                              <input type="text" @if(isset($survey)) value="{{$survey->total_number_of_teachers_in_post}}" @endif name="total_number_of_teachers_in_post" >
                            </div>
                        </li>
                        <li>
                            Number Of Teachers On Course:
                            <div class="ui input">
                              <input type="text" @if(isset($survey)) value="{{$survey->number_of_teacher_on_course}}" @endif name="number_of_teacher_on_course" >
                            </div>
                        </li>
                        <li>
                            Number Of Teachers Needed:
                            <div class="ui input">
                              <input type="text" @if(isset($survey)) value="{{$survey->number_of_teacher_needed}}" @endif name="number_of_teacher_needed" >
                            </div>
                        </li>
                    </ul>
                </div>
                <a class="ui black ribbon label">Qualifications</a>
                <div class="field">
                    <ul class="ui list">
                        <li>
                            <table class="ui celled structured table num_table">
                              <thead>
                                <tr>
                                  <th rowspan="2">CATEGORY</th>
                                  <th>MALE</th>
                                  <th>FEMALE</th>
                                  <th>TOTAL</th>
                                </tr>
                              </thead>
                              <tbody>
                                <tr class="last_total">
                                    <td>Master Degrees with TQ</td>
                                    <td data-label="MALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->master_degree_with_tq_male}}" @endif name="master_degree_with_tq_male" >
                                        </div>
                                    </td>
                                    <td data-label="FEMALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->master_degree_with_tq_female}}" @endif name="master_degree_with_tq_female" >
                                        </div>
                                    </td>
                                    <td data-label="TOTAL">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->master_degree_with_tq_total}}" @endif name="master_degree_with_tq_total" >
                                        </div>
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td>Graduate with TQ</td>
                                    <td data-label="MALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->graduate_with_tq_male}}" @endif name="graduate_with_tq_male" >
                                        </div>
                                    </td>
                                    <td data-label="FEMALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->graduate_with_tq_female}}" @endif name="graduate_with_tq_female" >
                                        </div>
                                    </td>
                                    <td data-label="TOTAL">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->graduate_with_tq_total}}" @endif name="graduate_with_tq_total" >
                                        </div>
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td>Graduate without TQ</td>
                                    <td data-label="MALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->graduate_without_tq_male}}" @endif name="graduate_without_tq_male" >
                                        </div>
                                    </td>
                                    <td data-label="FEMALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->graduate_without_tq_female}}" @endif name="graduate_without_tq_female" >
                                        </div>
                                    </td>
                                    <td data-label="TOTAL">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->graduate_without_tq_total}}" @endif name="graduate_without_tq_total" >
                                        </div>
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td>HND with TQ</td>
                                    <td data-label="MALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->hnd_with_tq_male}}" @endif name="hnd_with_tq_male" >
                                        </div>
                                    </td>
                                    <td data-label="FEMALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->hnd_with_tq_female}}" @endif name="hnd_with_tq_female" >
                                        </div>
                                    </td>
                                    <td data-label="TOTAL">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->hnd_with_tq_total}}" @endif name="hnd_with_tq_total" >
                                        </div>
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td>HND without TQ</td>
                                    <td data-label="MALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->hnd_without_tq_male}}" @endif name="hnd_without_tq_male" >
                                        </div>
                                    </td>
                                    <td data-label="FEMALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->hnd_without_tq_female}}" @endif name="hnd_without_tq_female" >
                                        </div>
                                    </td>
                                    <td data-label="TOTAL">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->hnd_without_tq_total}}" @endif name="hnd_without_tq_total" >
                                        </div>
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td>NCE</td>
                                    <td data-label="MALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->nce_male}}" @endif name="nce_male" >
                                        </div>
                                    </td>
                                    <td data-label="FEMALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->nce_female}}" @endif name="nce_female" >
                                        </div>
                                    </td>
                                    <td data-label="TOTAL">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->nce_total}}" @endif name="nce_total" >
                                        </div>
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td>OND & Equivalent</td>
                                    <td data-label="MALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->ond_and_equivalent_male}}" @endif name="ond_and_equivalent_male" >
                                        </div>
                                    </td>
                                    <td data-label="FEMALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->ond_and_equivalent_female}}" @endif name="ond_and_equivalent_female" >
                                        </div>
                                    </td>
                                    <td data-label="TOTAL">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->ond_and_equivalent_total}}" @endif name="ond_and_equivalent_total" >
                                        </div>
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td>Others (Specified)</td>
                                    <td data-label="MALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->others_male}}" @endif name="others_male" >
                                        </div>
                                    </td>
                                    <td data-label="FEMALE">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->others_female}}" @endif name="others_female" >
                                        </div>
                                    </td>
                                    <td data-label="TOTAL">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->others_total}}" @endif name="others_total" >
                                        </div>
                                    </td>
                                </tr>
                                <tr class="full_total">
                                    <td>Total:</td>
                                    <td data-label="MALE">
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->qualification_male}}" @endif name="qualification_male" >
                                        </div>
                                    </td>
                                    <td data-label="FEMALE">
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->qualification_female}}" @endif name="qualification_female" >
                                        </div>
                                    </td>
                                    <td data-label="TOTAL">
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->qualification_total}}" @endif name="qualification_total" >
                                        </div>
                                    </td>
                                </tr>
                              </tbody>
                            </table>
                        </li>
                    </ul>
                </div>
                <a class="ui black ribbon label">Non-Teaching Staffs</a>
                <div class="field">
                    <span>Total number of non-teaching staffs in post</span>
                    <ul class="ui list">
                        <li>
                            <table class="ui celled table num_table">
                              <thead>
                                <tr><th>S/N</th>
                                <th>Category</th>
                                <th>Male</th>
                                <th>Female</th>
                                <th>Total</th>
                              </tr></thead>
                              <tbody>
                                <tr class="last_total">
                                    <td data-label="S/N">
                                        i)
                                    </td>
                                    <td data-label="Category">
                                        Accounts Staff
                                    </td>
                                    <td data-label="Male">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->account_staff_male}}" @endif name="account_staff_male" >
                                        </div>
                                    </td>
                                    <td data-label="Female">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->account_staff_female}}" @endif name="account_staff_female" >
                                        </div>  
                                    </td>
                                    <td data-label="Total">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->account_staff_total}}" @endif name="account_staff_total" >
                                        </div>  
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td data-label="S/N">
                                        ii)
                                    </td>
                                    <td data-label="Category">
                                        Clerical Staff
                                    </td>
                                    <td data-label="Male">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->clerical_staff_male}}" @endif name="clerical_staff_male" >
                                        </div>
                                    </td>
                                    <td data-label="Female">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->clerical_staff_female}}" @endif name="clerical_staff_female" >
                                        </div>  
                                    </td>
                                    <td data-label="Total">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->clerical_staff_total}}" @endif name="clerical_staff_total" >
                                        </div>  
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td data-label="S/N">
                                        iii)
                                    </td>
                                    <td data-label="Category">
                                        Laboratory Assistant
                                    </td>
                                    <td data-label="Male">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->laboratory_assistant_male}}" @endif name="laboratory_assistant_male" >
                                        </div>
                                    </td>
                                    <td data-label="Female">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->laboratory_assistant_female}}" @endif name="laboratory_assistant_female" >
                                        </div>  
                                    </td>
                                    <td data-label="Total">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->laboratory_assistant_total}}" @endif name="laboratory_assistant_total" >
                                        </div>  
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td data-label="S/N">
                                        iv)
                                    </td>
                                    <td data-label="Category">
                                        Library Assistant
                                    </td>
                                    <td data-label="Male">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->library_assistant_male}}" @endif name="library_assistant_male" >
                                        </div>
                                    </td>
                                    <td data-label="Female">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->library_assistant_female}}" @endif name="library_assistant_female" >
                                        </div>  
                                    </td>
                                    <td data-label="Total">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->library_assistant_total}}" @endif name="library_assistant_total" >
                                        </div>  
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td data-label="S/N">
                                        v)
                                    </td>
                                    <td data-label="Category">
                                        Data Clerk (Computer)
                                    </td>
                                    <td data-label="Male">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->data_clerk_male}}" @endif name="data_clerk_male" >
                                        </div>
                                    </td>
                                    <td data-label="Female">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->data_clerk_female}}" @endif name="data_clerk_female" >
                                        </div>  
                                    </td>
                                    <td data-label="Total">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->data_clerk_total}}" @endif name="data_clerk_total" >
                                        </div>  
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td data-label="S/N">
                                        vi)
                                    </td>
                                    <td data-label="Category">
                                        Typist
                                    </td>
                                    <td data-label="Male">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->typist_male}}" @endif name="typist_male" >
                                        </div>
                                    </td>
                                    <td data-label="Female">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->typist_female}}" @endif name="typist_female" >
                                        </div>  
                                    </td>
                                    <td data-label="Total">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->typist_total}}" @endif name="typist_total" >
                                        </div>  
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td data-label="S/N">
                                        vii)
                                    </td>
                                    <td data-label="Category">
                                        Messangers
                                    </td>
                                    <td data-label="Male">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->messangers_male}}" @endif name="messangers_male" >
                                        </div>
                                    </td>
                                    <td data-label="Female">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->messangers_female}}" @endif name="messangers_female" >
                                        </div>  
                                    </td>
                                    <td data-label="Total">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->messangers_total}}" @endif name="messangers_total" >
                                        </div>  
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td data-label="S/N">
                                        viii)
                                    </td>
                                    <td data-label="Category">
                                        Gardeners
                                    </td>
                                    <td data-label="Male">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->gardeners_male}}" @endif name="gardeners_male" >
                                        </div>
                                    </td>
                                    <td data-label="Female">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->gardeners_female}}" @endif name="gardeners_female" >
                                        </div>  
                                    </td>
                                    <td data-label="Total">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->gardeners_total}}" @endif name="gardeners_total" >
                                        </div>  
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td data-label="S/N">
                                        ix)
                                    </td>
                                    <td data-label="Category">
                                        Day/Night Guard
                                    </td>
                                    <td data-label="Male">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->guard_male}}" @endif name="guard_male" >
                                        </div>
                                    </td>
                                    <td data-label="Female">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->guard_female}}" @endif name="guard_female" >
                                        </div>  
                                    </td>
                                    <td data-label="Total">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->guard_total}}" @endif name="guard_total" >
                                        </div>  
                                    </td>
                                </tr>
                                <tr class="last_total">
                                    <td data-label="S/N">
                                        x)
                                    </td>
                                    <td data-label="Category">
                                        Others (Specified)
                                    </td>
                                    <td data-label="Male">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->category_other_male}}" @endif name="category_other_male" >
                                        </div>
                                    </td>
                                    <td data-label="Female">
                                        <div class="ui input add">
                                          <input type="text" @if(isset($survey)) value="{{$survey->category_other_female}}" @endif name="category_other_female" >
                                        </div>  
                                    </td>
                                    <td data-label="Total">
                                        <div class="ui input total">
                                          <input type="text" @if(isset($survey)) value="{{$survey->category_other_total}}" @endif name="category_other_total" >
                                        </div>  
                                    </td>
                                </tr>
                                <tr class="full_total">
                                    <td data-label="S/N">
                                        
                                    </td>
                                    <td data-label="Category">
                                        Total:
                                    </td>
                                    <td data-label="Male">
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->category_total_male}}" @endif name="category_total_male" >
                                        </div>
                                    </td>
                                    <td data-label="Female">
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->category_total_female}}" @endif name="category_total_female" >
                                        </div>  
                                    </td>
                                    <td data-label="Total">
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->category_total_total}}" @endif name="category_total_total" >
                                        </div>  
                                    </td>
                                </tr>
                              </tbody>
                            </table>
                        </li>
                    </ul>
                </div>
                <div class="p-left">
                    <button type="button" class="ui black labeled icon button" onclick="switchPage(2)">
                      <i class="left arrow icon"></i>
                      Previous
                    </button>
                </div>
                <div class="p-right">
                    <button type="button" class="ui right black labeled icon button" onclick="switchPage(4)">
                      <i class="right arrow icon"></i>
                      Next
                    </button>
                </div>
                <div style="clear: both;"></div>
            </div>
            <div class="ui raised segment hidden" data-page="4">
                <a class="ui black ribbon label">School Structures / Facilities</a>
                <div class="field">
                    <ul class="ui list">
                        <li>
                            <table class="ui celled structured table num_table">
                              <thead>
                                <tr>
                                  <th rowspan="2">Items</th>
                                  <th >Number Available</th>
                                  <th >Number In Good Condition</th>
                                  <th >Number Of Needed</th>
                                </tr>
                              </thead>
                              <tbody>
                                <tr>
                                    <td>Classrooms</td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->classrooms_available}}" @endif name="classrooms_available" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->classrooms_in_good_condition}}" @endif name="classrooms_in_good_condition" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->classrooms_needed}}" @endif name="classrooms_needed" >
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Laboratories</td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->laboratories_available}}" @endif name="laboratories_available" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->laboratories_in_good_condition}}" @endif name="laboratories_in_good_condition" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->laboratories_needed}}" @endif name="laboratories_needed" >
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Computer Room</td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->computerroom_available}}" @endif name="computerroom_available" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->computerroom_in_good_condition}}" @endif name="computerroom_in_good_condition" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->computerroom_needed}}" @endif name="computerroom_needed" >
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Technical Workshop</td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->technical_workshop_available}}" @endif name="technical_workshop_available" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->technical_workshop_in_good_condition}}" @endif name="technical_workshop_in_good_condition" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->technical_workshop_needed}}" @endif name="technical_workshop_needed" >
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Library</td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->library_available}}" @endif name="library_available" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->library_in_good_condition}}" @endif name="library_in_good_condition" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->library_workshop}}" @endif name="library_workshop" >
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Sources Of Power</td>
                                    <td>
                                        <div class="ui radio checkbox">
                                            <input type="radio" @if(isset($survey)) data-selected="{{$survey->sources_of_power}}" @endif name="sources_of_power" value="national grid" tabindex="0" class="hidden">
                                            <label>National Grid</label>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui radio checkbox">
                                            <input type="radio" @if(isset($survey)) data-selected="{{$survey->sources_of_power}}" @endif name="sources_of_power" value="generator" tabindex="0" class="hidden">
                                            <label>Generator</label>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui radio checkbox">
                                            <input type="radio" @if(isset($survey)) data-selected="{{$survey->sources_of_power}}" @endif name="sources_of_power" value="solar" tabindex="0" class="hidden">
                                            <label>Solar</label>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Health Facility</td>
                                    <td>
                                        <div class="ui radio checkbox">
                                            <input type="radio" @if(isset($survey)) data-selected="{{$survey->health_facility}}" @endif name="health_facility" value="health clinic" tabindex="0" class="hidden">
                                            <label>Health Clinic</label>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui radio checkbox">
                                            <input type="radio" @if(isset($survey)) data-selected="{{$survey->health_facility}}" @endif name="health_facility" value="first aid kit" tabindex="0" class="hidden">
                                            <label>First Aid Kit</label>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui radio checkbox">
                                            <input type="radio" @if(isset($survey)) data-selected="{{$survey->health_facility}}" @endif name="health_facility" value="none" tabindex="0" class="hidden">
                                            <label>None</label>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Toilet</td>
                                    <td>
                                        <div class="ui radio checkbox">
                                            <input type="radio" @if(isset($survey)) data-selected="{{$survey->toilet}}" @endif name="toilet" value="water flush" tabindex="0" class="hidden">
                                            <label>Water Flush</label>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui radio checkbox">
                                            <input type="radio" @if(isset($survey)) data-selected="{{$survey->toilet}}" @endif name="toilet" value="vip" tabindex="0" class="hidden">
                                            <label>VIP</label>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui radio checkbox">
                                            <input type="radio" @if(isset($survey)) data-selected="{{$survey->toilet}}" @endif name="toilet" value="pit" tabindex="0" class="hidden">
                                            <label>Pit</label>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Sources Of Water</td>
                                    <td>
                                        <div class="ui radio checkbox">
                                            <input type="radio" @if(isset($survey)) data-selected="{{$survey->source_of_water}}" @endif name="source_of_water" value="borehole" tabindex="0" class="hidden">
                                            <label>Borehole</label>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui radio checkbox">
                                            <input type="radio" @if(isset($survey)) data-selected="{{$survey->source_of_water}}" @endif name="source_of_water" value="pipe borne" tabindex="0" class="hidden">
                                            <label>Pipe Borne</label>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui radio checkbox">
                                            <input type="radio" @if(isset($survey)) data-selected="{{$survey->source_of_water}}" @endif name="source_of_water" value="well" tabindex="0" class="hidden">
                                            <label>Well</label>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>School Fence (Please tick)</td>
                                    <td>
                                        <div class="ui radio checkbox">
                                            <input type="radio" @if(isset($survey)) data-selected="{{$survey->school_fence}}" @endif name="school_fence" value="total fence" tabindex="0" class="hidden">
                                            <label>Total Fence</label>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui radio checkbox">
                                            <input type="radio" @if(isset($survey)) data-selected="{{$survey->school_fence}}" @endif name="school_fence" value="partial fence" tabindex="0" class="hidden">
                                            <label>Partial Fence</label>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui radio checkbox">
                                            <input type="radio" @if(isset($survey)) data-selected="{{$survey->school_fence}}" @endif name="school_fence" value="not available" tabindex="0" class="hidden">
                                            <label>Not Available</label>
                                        </div>
                                    </td>
                                </tr>
                              </tbody>
                            </table>
                        </li>
                    </ul>
                </div>
                <a class="ui black ribbon label">Furniture Items</a>
                <div class="field">
                    <span>Total number of non-teaching staffs in post</span>
                    <ul class="ui list">
                        <li>
                            <table class="ui celled table num_table">
                              <thead>
                                <tr><th>Items</th>
                                <th>Number Available</th>
                                <th>Number In Good Condition</th>
                                <th>Number Needed</th>
                                <th>Remark</th>
                              </tr></thead>
                              <tbody>
                                <tr>
                                    <td>Student Chair</td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->student_seat_available}}" @endif name="student_seat_available" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->student_seat_in_good_condition}}" @endif name="student_seat_in_good_condition" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->student_seat_needed}}" @endif name="student_seat_needed" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->student_seat_remarks}}" @endif name="student_seat_remarks" >
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Student Locker</td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->student_desk_available}}" @endif name="student_desk_available" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->student_desk_in_good_condition}}" @endif name="student_desk_in_good_condition" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->student_desk_needed}}" @endif name="student_desk_needed" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->student_desk_remarks}}" @endif name="student_desk_remarks" >
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Staff Chairs</td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->staff_chairs_available}}" @endif name="staff_chairs_available" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->staff_chairs_in_good_condition}}" @endif name="staff_chairs_in_good_condition" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->staff_chairs_desk_needed}}" @endif name="staff_chairs_desk_needed" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->staff_chairs_desk_remarks}}" @endif name="staff_chairs_desk_remarks" >
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Staff Table</td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->staff_table_available}}" @endif name="staff_table_available" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->staff_table_in_good_condition}}" @endif name="staff_table_in_good_condition" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->staff_table_desk_needed}}" @endif name="staff_table_desk_needed" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->staff_table_desk_remarks}}" @endif name="staff_table_desk_remarks" >
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Laboratory Tables & Stools</td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->lab_table_and_chairs_available}}" @endif name="lab_table_and_chairs_available" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->lab_table_and_chairs_in_good_condition}}" @endif name="lab_table_and_chairs_in_good_condition" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->lab_table_and_chairs_needed}}" @endif name="lab_table_and_chairs_needed" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->lab_table_and_chairs_remarks}}" @endif name="lab_table_and_chairs_remarks" >
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Library Tables & Chairs</td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->library_table_and_chairs_available}}" @endif name="library_table_and_chairs_available" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->library_table_and_chairs_in_good_condition}}" @endif name="library_table_and_chairs_in_good_condition" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->library_table_and_chairs_needed}}" @endif name="library_table_and_chairs_needed" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->library_table_and_chairs_remarks}}" @endif name="library_table_and_chairs_remarks" >
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Others (Specify)</td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->other_furniture_available}}" @endif name="other_furniture_available" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->other_furniture_in_good_condition}}" @endif name="other_furniture_in_good_condition" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->other_furniture_needed}}" @endif name="other_furniture_needed" >
                                        </div>
                                    </td>
                                    <td>
                                        <div class="ui input">
                                          <input type="text" @if(isset($survey)) value="{{$survey->other_furniture_remarks}}" @endif name="other_furniture_remarks" >
                                        </div>
                                    </td>
                                </tr>
                              </tbody>
                            </table>
                        </li>
                    </ul>
                </div>
                <div class="p-left">
                    <button type="button" class="ui black labeled icon button" onclick="switchPage(3)">
                      <i class="left arrow icon"></i>
                      Previous
                    </button>
                </div>
                <div class="p-right">
                    <button type="submit" class="ui right black button">
                      Submit
                    </button>
                </div>
                <div style="clear: both;"></div>
            </div>
        </form>
        <div style="padding: 35px 50px 10px 50px;position: sticky !important;top: 10px !important;">
            <span>
                Status: 
                @if(isset($survey))
                <b style="color: green;">Updated</b>
                @else
                <b style="color: red;">Not Updated</b>
                @endif
            </span>
            <br>
            <div class="field" style="padding: 0px !important;">
          <label>Select Session To View</label>
          <div class="ui fluid search selection dropdown">
            <input type="hidden" name="session" onchange="window.location = $(this).attr('data-url')+'/'+$(this).val()" data-url="{{url('admin/school-survey')}}">
            <i class="dropdown icon"></i>
            <div class="default text">Session</div>
            <div class="menu">
              @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
               <div class="item  @if($session == $i) selected @endif" data-value="{{$i}}">{{$i}}/{{$i+1}}</div>
              @endfor
            </div>
          </div>
          <br>
          <a href="{{route('admin.school-survey-view', ['session' => $session])}}" class="ui button fluid orange large">Preview Survey</a>
        </div>
         <br>
          <div style="width:250px;height:auto;">
              @include('layouts.ads.side-ad')
          </div>
      </div>
    </div>
    <style>
        .survey-form{
            width: fit-content;
            margin: 20px auto;
            padding: 20px;
        }
        .survey-form .field{
            padding: 15px 15px;
        }
        .survey-form .p-right{
            float: right;
        }
        .survey-form .p-left{
            float: left;
        }
        .survey-form .hidden{
            display: none;
        }
        .num_table input{
            width: 70px;
        }
    </style>
    <script>
        $(function(){
            $('.ui.radio.checkbox').checkbox();
            $('input[type=radio]').each(function(){
                var value = $(this).attr('value');
                var dataSelected = $(this).attr('data-selected');
                if(value == dataSelected){
                    $(this).attr('checked', 'checked');
                }
            });
            
            $('.last_total .add input').each(function(){
                $(this).attr('type', 'number');
                $(this).attr('min', '0');
                if($(this).val() == ''){
                    $(this).val(0);
                }
                $(this).on('input', function(e){
                    e.preventDefault();
                    var input = $(this);
                    var value = input.val();
                    var lastTotal = input.parents('.last_total').first();
                    var tbody = lastTotal.parent();
                    var totalInput = lastTotal.find('.input.total input');
                    var fullTotal = tbody.find('.full_total');
                    var label = input.parents('td').first().attr('data-label');
                    var amount = 0;
                    var fullAmount = 0;
                    
                    // for last total
                    lastTotal.find('td').each(function(){
                        var addInput = $(this).find('.input.add input');
                        if(addInput.length){
                            amount = parseInt(amount) + parseInt(addInput.val());
                        }
                    });
                    
                    totalInput.val(amount);
                    
                    // for full total
                    tbody.find('.last_total').each(function(){
                        var addInput = $(this).find(`td[data-label='${label}'] .input.add input`)
                        if(addInput.length){
                            fullAmount = parseInt(fullAmount) + parseInt(addInput.val());
                        }
                    });
                    
                    tbody.find(`.full_total td[data-label='${label}'] .input input`).val(fullAmount);
                });
            });
        });
        function switchPage(number){
            $('.survey-form .segment').each(function(){
                $(this).slideUp('fast');
            });
            $(`.survey-form .segment[data-page=${number}]`).slideDown('fast');
            
            $('.page-count a.black').addClass('grey');
            $('.page-count a.black').removeClass('black');
            
            $(`.page-count a[data-page=${number}]`).addClass('black');
            $(`.page-count a[data-page=${number}]`).removeClass('grey');
        }
    </script>
@endsection