@extends('layouts.main')
@section('content')
    <br>
    <div class="survey-form" data-title="{{ucwords($school->name)}}'s Survey">
        <div class="ui main-loader">
          <div class="ui active dimmer">
            <div class="ui loader"></div>
          </div>
        </div>
        <form method="POST" action="" class="main--survey" style="padding: 0px 5px 10px 50px;width: 850px;">
            <input type="hidden" name="_token" value="{{csrf_token()}}">
            <input type="hidden" name="school_id" value="{{$school->id}}">
            <div class="ui page-count no-print export-hide">
                <a data-page="1" onclick="switchPage(1)" class="ui black circular label">1</a>
                <a data-page="2" onclick="switchPage(2)" class="ui grey circular label">2</a>
                <a data-page="3" onclick="switchPage(3)" class="ui grey circular label">3</a>
                <a data-page="4" onclick="switchPage(4)" class="ui grey circular label">4</a>
            </div>
            <div class="ui raised segment" data-page="1">
                <div class="watermark"></div>
                <div style="text-align: center;">
                    <img src="{{url_public($school->logo)}}" style="width: 250px;border-radius: 20px;">
                    <h1 style="text-transform: uppercase;">{{ucwords($school->name)}}'s Session <br> Questionnaire Survey For {{$session}}</h1>
                </div>
                <a class="ui black ribbon label">School Particulars</a>
                <div class="field">
                    <ul class="ui list">
                        <li>
                            Name Of School: <span class="answer">{{$school->name}}</span>
                        </li>
                        <li>
                            Town: <span class="answer">{{$survey->town}}</span>
                        </li>
                      <li>
                          Location: <span class="answer">{{$survey->location}}</span>
                      </li>
                      <li>
                          Local Government Area: <span class="answer">{{$survey->local_government_area}}</span>
                      </li>
                      <li>
                          Type Of Institution: <span class="answer">{{$survey->type_of_institution}}</span>
                      </li>
                      <li>
                          Post Office Box / PMB: <span class="answer">{{$survey->post_office_box}}</span>
                        </li>
                      <li>
                          Email Address: <span class="answer">{{$survey->email_address}}</span>
                        </li>
                    </ul>
                </div>
                <a class="ui black ribbon label">Principal / Vice Principal(s) Contact</a>
                <div class="field">
                    <ul class="ui list">
                        <li>
                            Name Of Principal:  <span class="answer">{{$survey->name_of_principal}}</span>
                        </li>
                        <li>
                            Phone Number Of Principal: <span class="answer">{{$survey->phone_of_principal}}</span>
                        </li>
                        <li>
                            Name Of Vice Principal:  <span class="answer">{{$survey->name_of_vice_principal}}</span>
                        </li>
                        <li>
                            Phone Number Of Vice Principal: <span class="answer">{{$survey->phone_of_vice_principal}}</span>
                        </li>
                        <li>
                            Name Of Vice Principal:  <span class="answer">{{$survey->name_of_vice_principal_two}}</span>
                        </li>
                        <li>
                            Phone Number Of Vice Principal: <span class="answer">{{$survey->phone_of_vice_principal_two}}</span>
                        </li>
                        <li>
                            Name Of Vice Principal:  <span class="answer">{{$survey->name_of_vice_principal_three}}</span>
                        </li>
                        <li>
                            Phone Number Of Vice Principal: <span class="answer">{{$survey->phone_of_vice_principal_three}}</span>
                        </li>
                        <li>
                            Name Of Vice Principal:  <span class="answer">{{$survey->name_of_vice_principal_four}}</span>
                        </li>
                        <li>
                            Phone Number Of Vice Principal: <span class="answer">{{$survey->phone_of_vice_principal_four}}</span>
                        </li>
                    </ul>
                </div>
                <div class="p-right">
                    <button type="button" class="no-print export-hide ui right black labeled icon button" onclick="switchPage(2)">
                      <i class="right arrow icon"></i>
                      Next
                    </button>
                </div>
                <div style="clear: both;"></div>
            </div>
            <div class="ui raised segment hidden" data-page="2">
                <div class="watermark"></div>
                <a class="ui black ribbon label">Enrolment</a>
                <div class="field">
                    <ul class="ui list">
                        <li>
                            Number Of Students:  <span class="answer">{{$survey->number_of_students}}</span>
                        </li>
                        <li>
                            Total Number Of Students[
                            <label>Boys: <span class="answer">{{$survey->total_number_of_boys}}</span></label>
                            <label>Girls: <span class="answer">{{$survey->total_number_of_girls}}</span></label>
                            ]
                        </li>
                        <li>
                            Total Number Of Students In <b>Boarding System</b>[
                            <label>Boys: <span class="answer">{{$survey->total_number_of_boys_in_boarding}}</span></label>
                            <label>Girls: <span class="answer">{{$survey->total_number_of_girls_in_boarding}}</span></label>
                            ]
                        </li>
                        <li>
                            <table class="ui celled table num_table">
                              <thead>
                                <tr><th>Classes</th>
                                <th>Stream</th>
                                <th>Average Age</th>
                                <th>MALE</th>
                                <th>FEMALE</th>
                                <th>TOTAL</th>
                              </tr></thead>
                              <tbody>
                                <tr>
                                    <td data-label="Classes">
                                        JSS1
                                    </td>
                                    <td data-label="Stream">
                                        <span class="answer">{{$survey->jss1_stream}}</span>
                                    </td>
                                    <td data-label="Average Age">
                                        <span class="answer">{{$survey->jss1_average_age}}</span>
                                    </td>
                                    <td data-label="MALE">
                                        <span class="answer">{{$survey->jss1_male}}</span>
                                    </td>
                                    <td data-label="FEMALE">
                                        <span class="answer">{{$survey->jss1_female}}</span>
                                    </td>
                                    <td data-label="TOTAL">
                                        <span class="answer">{{$survey->jss1_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td data-label="Classes">
                                        JSS2
                                    </td>
                                    <td data-label="Stream">
                                        <span class="answer">{{$survey->jss2_stream}}</span>
                                    </td>
                                    <td data-label="Average Age">
                                        <span class="answer">{{$survey->jss2_average_age}}</span>
                                    </td>
                                    <td data-label="MALE">
                                        <span class="answer">{{$survey->jss2_male}}</span>
                                    </td>
                                    <td data-label="FEMALE">
                                        <span class="answer">{{$survey->jss2_female}}</span>
                                    </td>
                                    <td data-label="TOTAL">
                                        <span class="answer">{{$survey->jss2_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td data-label="Classes">
                                        JSS3
                                    </td>
                                    <td data-label="Stream">
                                        <span class="answer">{{$survey->jss3_stream}}</span>
                                    </td>
                                    <td data-label="Average Age">
                                        <span class="answer">{{$survey->jss3_average_age}}</span>
                                    </td>
                                    <td data-label="MALE">
                                        <span class="answer">{{$survey->jss3_male}}</span>
                                    </td>
                                    <td data-label="FEMALE">
                                        <span class="answer">{{$survey->jss3_female}}</span>
                                    </td>
                                    <td data-label="TOTAL">
                                        <span class="answer">{{$survey->jss3_total}}</span>
                                    </td>
                                </tr> 
                                <tr>
                                    <td data-label="Classes">
                                        SSS1
                                    </td>
                                    <td data-label="Stream">
                                        <span class="answer">{{$survey->sss1_stream}}</span>
                                    </td>
                                    <td data-label="Average Age">
                                        <span class="answer">{{$survey->sss1_average_age}}</span>
                                    </td>
                                    <td data-label="MALE">
                                        <span class="answer">{{$survey->sss1_male}}</span>
                                    </td>
                                    <td data-label="FEMALE">
                                        <span class="answer">{{$survey->sss1_female}}</span>
                                    </td>
                                    <td data-label="TOTAL">
                                        <span class="answer">{{$survey->sss1_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td data-label="Classes">
                                        SSS2
                                    </td>
                                    <td data-label="Stream">
                                        <span class="answer">{{$survey->sss2_stream}}</span>
                                    </td>
                                    <td data-label="Average Age">
                                        <span class="answer">{{$survey->sss2_average_age}}</span>
                                    </td>
                                    <td data-label="MALE">
                                        <span class="answer">{{$survey->sss2_male}}</span>
                                    </td>
                                    <td data-label="FEMALE">
                                        <span class="answer">{{$survey->sss2_female}}</span>
                                    </td>
                                    <td data-label="TOTAL">
                                        <span class="answer">{{$survey->sss2_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td data-label="Classes">
                                        SSS3
                                    </td>
                                    <td data-label="Stream">
                                        <span class="answer">{{$survey->sss3_stream}}</span>
                                    </td>
                                    <td data-label="Average Age">
                                        <span class="answer">{{$survey->sss3_average_age}}</span>
                                    </td>
                                    <td data-label="MALE">
                                        <span class="answer">{{$survey->sss3_male}}</span>
                                    </td>
                                    <td data-label="FEMALE">
                                        <span class="answer">{{$survey->sss3_female}}</span>
                                    </td>
                                    <td data-label="TOTAL">
                                        <span class="answer">{{$survey->sss3_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td data-label="Classes">
                                        TOTAL:
                                    </td>
                                    <td data-label="Stream">
                                        <span class="answer">{{$survey->total_stream}}</span>
                                    </td>
                                    <td data-label="Average Age">
                                        <span class="answer">{{$survey->total_average_age}}</span>
                                    </td>
                                    <td data-label="MALE">
                                        <span class="answer">{{$survey->total_male}}</span>
                                    </td>
                                    <td data-label="FEMALE">
                                        <span class="answer">{{$survey->total_female}}</span>
                                    </td>
                                    <td data-label="TOTAL">
                                        <span class="answer">{{$survey->main_total}}</span>
                                    </td>
                                </tr>
                              </tbody>
                            </table>
                        </li>
                    </ul>
                </div>
                <a class="ui black ribbon label">Students Disposition By Subjects Offered In Senior Secondary School</a>
                <div class="field">
                    <ul class="ui list">
                        <li>
                            <table class="ui celled structured table num_table">
                              <thead>
                                <tr>
                                  <th rowspan="2">AREA OF STUDIES</th>
                                  <th colspan="2">SCIENCE SUBJECTS</th>
                                  <th colspan="2">LIBERAL ARTS</th>
                                  <th colspan="2">COMMERCIAL SUBJECT</th>
                                </tr>
                                <tr>
                                  <th>MALE</th>
                                  <th>FEMALE</th>
                                  <th>MALE</th>
                                  <th>FEMALE</th>
                                  <th>MALE</th>
                                  <th>FEMALE</th>
                                </tr>
                              </thead>
                              <tbody>
                                <tr>
                                    <td>Number Of Students</td>
                                    <td>
                                        <span class="answer">{{$survey->science_male}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->science_female}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->liberal_male}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->liberal_female}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->commericial_male}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->commericial_female}}</span>
                                    </td>
                                </tr>
                              </tbody>
                            </table>
                        </li>
                    </ul>
                </div>
                <a class="ui black ribbon label">Students With Disabilities</a>
                <div class="field">
                    <ul class="ui list">
                        <li>
                            <table class="ui celled table num_table">
                              <thead>
                                <tr><th>Classes</th>
                                <th>JSS1</th>
                                <th>JSS2</th>
                                <th>JSS3</th>
                                <th>SS1</th>
                                <th>SS2</th>
                                <th>SS3</th>
                                <th>TOTAL</th>
                              </tr></thead>
                              <tbody>
                                <tr>
                                    <td data-label="Classes">
                                        Male
                                    </td>
                                    <td data-label="JSS1">
                                        <span class="answer">{{$survey->jss1_male_with_disabilities}}</span>
                                    </td>
                                    <td data-label="JSS2">
                                        <span class="answer">{{$survey->jss2_male_with_disabilities}}</span>
                                    </td>
                                    <td data-label="JSS3">
                                        <span class="answer">{{$survey->jss3_male_with_disabilities}}</span>
                                    </td>
                                    <td data-label="SS1">
                                        <span class="answer">{{$survey->jss1_male_with_disabilities}}</span>
                                    </td>
                                    <td data-label="SS2">
                                        <span class="answer">{{$survey->jss2_male_with_disabilities}}</span>
                                    </td>
                                    <td data-label="SS3">
                                        <span class="answer">{{$survey->jss3_male_with_disabilities}}</span>
                                    </td>
                                    <td data-label="TOTAL">
                                        <span class="answer">{{$survey->total_male_with_disabilities}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td data-label="Classes">
                                        Female
                                    </td>
                                    <td data-label="JSS1">
                                        <span class="answer">{{$survey->jss1_female_with_disabilities}}</span>
                                    </td>
                                    <td data-label="JSS2">
                                        <span class="answer">{{$survey->jss2_female_with_disabilities}}</span>
                                    </td>
                                    <td data-label="JSS3">
                                        <span class="answer">{{$survey->jss3_female_with_disabilities}}</span>
                                    </td>
                                    <td data-label="SS1">
                                        <span class="answer">{{$survey->jss1_female_with_disabilities}}</span>
                                    </td>
                                    <td data-label="SS2">
                                        <span class="answer">{{$survey->jss2_female_with_disabilities}}</span>
                                    </td>
                                    <td data-label="SS3">
                                        <span class="answer">{{$survey->jss3_female_with_disabilities}}</span>
                                    </td>
                                    <td data-label="TOTAL">
                                        <span class="answer">{{$survey->total_female_with_disabilities}}</span>
                                    </td>
                                </tr>
                              </tbody>
                            </table>
                        </li>
                    </ul>
                </div>
                <div class="p-left">
                    <button type="button" class="no-print export-hide ui black labeled icon button" onclick="switchPage(1)">
                      <i class="left arrow icon"></i>
                      Previous
                    </button>
                </div>
                <div class="p-right">
                    <button type="button" class="no-print export-hide ui right black labeled icon button" onclick="switchPage(3)">
                      <i class="right arrow icon"></i>
                      Next
                    </button>
                </div>
                <div style="clear: both;"></div>
            </div>
            <div class="ui raised segment hidden" data-page="3">
                <div class="watermark"></div>
                <a class="ui black ribbon label">Staffing Situation</a>
                <div class="field">
                    <ul class="ui list">
                        <li>
                            Approved Staff Qaota:  <span class="answer">{{$survey->approved_staff_qaota}}</span>
                        </li>
                        <li>
                            Total Number Of Teachers In Post:  <span class="answer">{{$survey->total_number_of_teachers_in_post}}</span>
                        </li>
                        <li>
                            Number Of Teachers On Course: <span class="answer">{{$survey->number_of_teacher_on_course}}</span>
                        </li>
                        <li>
                            Number Of Teachers Needed: <span class="answer">{{$survey->number_of_teacher_needed}}</span>
                        </li>
                    </ul>
                </div>
                <a class="ui black ribbon label">Qualifications</a>
                <div class="field">
                    <ul class="ui list">
                        <li>
                            <table class="ui celled structured table num_table">
                              <thead>
                                <tr>
                                  <th rowspan="2">CATEGORY</th>
                                  <th >MALE</th>
                                  <th >FEMALE</th>
                                  <th >TOTAL</th>
                                </tr>
                              </thead>
                              <tbody>
                                <tr>
                                    <td>Master Degrees with TQ</td>
                                    <td>
                                        <span class="answer">{{$survey->master_degree_with_tq_male}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->master_degree_with_tq_female}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->master_degree_with_tq_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Graduate with TQ</td>
                                    <td>
                                        <span class="answer">{{$survey->graduate_with_tq_male}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->graduate_with_tq_female}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->graduate_with_tq_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Graduate without TQ</td>
                                    <td>
                                        <span class="answer">{{$survey->graduate_without_tq_male}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->graduate_without_tq_female}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->graduate_without_tq_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>HND with TQ</td>
                                    <td>
                                        <span class="answer">{{$survey->hnd_with_tq_male}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->hnd_with_tq_female}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->hnd_with_tq_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>HND without TQ</td>
                                    <td>
                                        <span class="answer">{{$survey->hnd_without_tq_male}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->hnd_without_tq_female}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->hnd_without_tq_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>NCE</td>
                                    <td>
                                        <span class="answer">{{$survey->nce_male}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->nce_female}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->nce_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>OND & Equivalent</td>
                                    <td>
                                        <span class="answer">{{$survey->ond_and_equivalent_male}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->ond_and_equivalent_female}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->ond_and_equivalent_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Others (Specified)</td>
                                    <td>
                                        <span class="answer">{{$survey->others_male}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->others_female}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->others_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Total:</td>
                                    <td>
                                        <span class="answer">{{$survey->qualification_male}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->qualification_female}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->qualification_total}}</span>
                                    </td>
                                </tr>
                              </tbody>
                            </table>
                        </li>
                    </ul>
                </div>
                <a class="ui black ribbon label">Non-Teaching Staffs</a>
                <div class="field">
                    <span>Total number of non-teaching staffs in post</span>
                    <ul class="ui list">
                        <li>
                            <table class="ui celled table num_table">
                              <thead>
                                <tr><th>S/N</th>
                                <th>Category</th>
                                <th>Male</th>
                                <th>Female</th>
                                <th>Total</th>
                              </tr></thead>
                              <tbody>
                                <tr>
                                    <td data-label="S/N">
                                        i)
                                    </td>
                                    <td data-label="Category">
                                        Accounts Staff
                                    </td>
                                    <td data-label="Male">
                                        <span class="answer">{{$survey->account_staff_male}}</span>
                                    </td>
                                    <td data-label="Female">
                                        <span class="answer">{{$survey->account_staff_female}}</span>
                                    </td>
                                    <td data-label="Total">
                                        <span class="answer">{{$survey->account_staff_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td data-label="S/N">
                                        ii)
                                    </td>
                                    <td data-label="Category">
                                        Clerical Staff
                                    </td>
                                    <td data-label="Male">
                                        <span class="answer">{{$survey->clerical_staff_male}}</span>
                                    </td>
                                    <td data-label="Female">
                                        <span class="answer">{{$survey->clerical_staff_female}}</span>
                                    </td>
                                    <td data-label="Total">
                                        <span class="answer">{{$survey->clerical_staff_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td data-label="S/N">
                                        iii)
                                    </td>
                                    <td data-label="Category">
                                        Laboratory Assistant
                                    </td>
                                    <td data-label="Male">
                                        <span class="answer">{{$survey->laboratory_assistant_male}}</span>
                                    </td>
                                    <td data-label="Female">
                                        <span class="answer">{{$survey->laboratory_assistant_female}}</span>
                                    </td>
                                    <td data-label="Total">
                                        <span class="answer">{{$survey->laboratory_assistant_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td data-label="S/N">
                                        iv)
                                    </td>
                                    <td data-label="Category">
                                        Library Assistant
                                    </td>
                                    <td data-label="Male">
                                        <span class="answer">{{$survey->library_assistant_male}}</span>
                                    </td>
                                    <td data-label="Female">
                                        <span class="answer">{{$survey->library_assistant_female}}</span>
                                    </td>
                                    <td data-label="Total">
                                        <span class="answer">{{$survey->library_assistant_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td data-label="S/N">
                                        v)
                                    </td>
                                    <td data-label="Category">
                                        Data Clerk (Computer)
                                    </td>
                                    <td data-label="Male">
                                        <span class="answer">{{$survey->data_clerk_male}}</span>
                                    </td>
                                    <td data-label="Female">
                                        <span class="answer">{{$survey->data_clerk_female}}</span>
                                    </td>
                                    <td data-label="Total">
                                        <span class="answer">{{$survey->data_clerk_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td data-label="S/N">
                                        vi)
                                    </td>
                                    <td data-label="Category">
                                        Typist
                                    </td>
                                    <td data-label="Male">
                                        <span class="answer">{{$survey->typist_male}}</span>
                                    </td>
                                    <td data-label="Female">
                                        <span class="answer">{{$survey->typist_female}}</span>
                                    </td>
                                    <td data-label="Total">
                                        <span class="answer">{{$survey->typist_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td data-label="S/N">
                                        vii)
                                    </td>
                                    <td data-label="Category">
                                        Messangers
                                    </td>
                                    <td data-label="Male">
                                        <span class="answer">{{$survey->messangers_male}}</span>
                                    </td>
                                    <td data-label="Female">
                                        <span class="answer">{{$survey->messangers_female}}</span>
                                    </td>
                                    <td data-label="Total">
                                        <span class="answer">{{$survey->messangers_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td data-label="S/N">
                                        viii)
                                    </td>
                                    <td data-label="Category">
                                        Gardeners
                                    </td>
                                    <td data-label="Male">
                                        <span class="answer">{{$survey->gardeners_male}}</span>
                                    </td>
                                    <td data-label="Female">
                                        <span class="answer">{{$survey->gardeners_female}}</span>
                                    </td>
                                    <td data-label="Total">
                                        <span class="answer">{{$survey->gardeners_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td data-label="S/N">
                                        ix)
                                    </td>
                                    <td data-label="Category">
                                        Day/Night Guard
                                    </td>
                                    <td data-label="Male">
                                        <span class="answer">{{$survey->guard_male}}</span>
                                    </td>
                                    <td data-label="Female">
                                        <span class="answer">{{$survey->guard_female}}</span>
                                    </td>
                                    <td data-label="Total">
                                        <span class="answer">{{$survey->guard_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td data-label="S/N">
                                        x)
                                    </td>
                                    <td data-label="Category">
                                        Others (Specified)
                                    </td>
                                    <td data-label="Male">
                                        <span class="answer">{{$survey->category_other_male}}</span>
                                    </td>
                                    <td data-label="Female">
                                        <span class="answer">{{$survey->category_other_female}}</span>
                                    </td>
                                    <td data-label="Total">
                                        <span class="answer">{{$survey->category_other_total}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td data-label="S/N">
                                        
                                    </td>
                                    <td data-label="Category">
                                        Total:
                                    </td>
                                    <td data-label="Male">
                                        <span class="answer">{{$survey->category_total_male}}</span>
                                    </td>
                                    <td data-label="Female">
                                        <span class="answer">{{$survey->category_total_female}}</span>
                                    </td>
                                    <td data-label="Total">
                                        <span class="answer">{{$survey->category_total_total}}</span>
                                    </td>
                                </tr>
                              </tbody>
                            </table>
                        </li>
                    </ul>
                </div>
                <div class="p-left">
                    <button type="button" class="no-print export-hide ui black labeled icon button" onclick="switchPage(2)">
                      <i class="left arrow icon"></i>
                      Previous
                    </button>
                </div>
                <div class="p-right">
                    <button type="button" class="no-print export-hide ui right black labeled icon button" onclick="switchPage(4)">
                      <i class="right arrow icon"></i>
                      Next
                    </button>
                </div>
                <div style="clear: both;"></div>
            </div>
            <div class="ui raised segment hidden" data-page="4">
                <div class="watermark"></div>
                <a class="ui black ribbon label">School Structures / Facilities</a>
                <div class="field">
                    <ul class="ui list">
                        <li>
                            <table class="ui celled structured table num_table">
                              <thead>
                                <tr>
                                  <th rowspan="2">Items</th>
                                  <th >Number Available</th>
                                  <th >Number In Good Condition</th>
                                  <th >Number Of Needed</th>
                                </tr>
                              </thead>
                              <tbody>
                                <tr>
                                    <td>Classrooms</td>
                                    <td>
                                        <span class="answer">{{$survey->classrooms_available}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->classrooms_in_good_condition}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->classrooms_needed}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Laboratories</td>
                                    <td>
                                        <span class="answer">{{$survey->laboratories_available}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->laboratories_in_good_condition}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->laboratories_needed}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Computer Room</td>
                                    <td>
                                        <span class="answer">{{$survey->computerroom_available}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->computerroom_in_good_condition}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->computerroom_needed}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Technical Workshop</td>
                                    <td>
                                        <span class="answer">{{$survey->technical_workshop_available}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->technical_workshop_in_good_condition}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->technical_workshop_needed}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Library</td>
                                    <td>
                                        <span class="answer">{{$survey->library_available}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->library_in_good_condition}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->library_workshop}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Sources Of Power</td>
                                    <td colspan="3">
                                        <span class="answer">{{$survey->sources_of_power}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Health Facility</td>
                                    <td colspan="3">
                                        <span class="answer">{{$survey->health_facility}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Toilet</td>
                                    <td colspan="3">
                                        <span class="answer">{{$survey->toilet}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Sources Of Water</td>
                                    <td colspan="3">
                                        <span class="answer">{{$survey->source_of_water}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>School Fence (Please tick)</td>
                                    <td colspan="3">
                                        <span class="answer">{{$survey->school_fence}}</span>
                                    </td>
                                </tr>
                              </tbody>
                            </table>
                        </li>
                    </ul>
                </div>
                <a class="ui black ribbon label">Furniture Items</a>
                <div class="field">
                    <span>Total number of non-teaching staffs in post</span>
                    <ul class="ui list">
                        <li>
                            <table class="ui celled table num_table">
                              <thead>
                                <tr><th>Items</th>
                                <th>Number Available</th>
                                <th>Number In Good Condition</th>
                                <th>Number Needed</th>
                                <th>Remark</th>
                              </tr></thead>
                              <tbody>
                                <tr>
                                    <td>Student's Seat</td>
                                    <td>
                                        <span class="answer">{{$survey->student_seat_available}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->student_seat_in_good_condition}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->student_seat_needed}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->student_seat_remarks}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Student's Desk</td>
                                    <td>
                                        <span class="answer">{{$survey->student_desk_available}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->student_desk_in_good_condition}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->student_desk_needed}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->student_desk_remarks}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Staff Chairs</td>
                                    <td>
                                        <span class="answer">{{$survey->staff_chairs_available}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->staff_chairs_in_good_condition}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->staff_chairs_desk_needed}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->staff_chairs_desk_remarks}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Staff Table</td>
                                    <td>
                                        <span class="answer">{{$survey->staff_table_available}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->staff_table_in_good_condition}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->staff_table_desk_needed}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->staff_table_desk_remarks}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Laboratory Tables & Chairs</td>
                                    <td>
                                        <span class="answer">{{$survey->lab_table_and_chairs_available}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->lab_table_and_chairs_in_good_condition}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->lab_table_and_chairs_needed}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->lab_table_and_chairs_remarks}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Library Tables & Chairs</td>
                                    <td>
                                        <span class="answer">{{$survey->library_table_and_chairs_available}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->library_table_and_chairs_in_good_condition}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->library_table_and_chairs_needed}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->library_table_and_chairs_remarks}}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>Others (Specify)</td>
                                    <td>
                                        <span class="answer">{{$survey->other_furniture_available}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->other_furniture_in_good_condition}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->other_furniture_needed}}</span>
                                    </td>
                                    <td>
                                        <span class="answer">{{$survey->other_furniture_remarks}}</span>
                                    </td>
                                </tr>
                              </tbody>
                            </table>
                        </li>
                    </ul>
                </div>
                <div class="p-left">
                    <button type="button" class="no-print export-hide ui black labeled icon button" onclick="switchPage(3)">
                      <i class="left arrow icon"></i>
                      Previous
                    </button>
                </div>
                <div style="clear: both;"></div>
            </div>
        </form>
        <div class="no-print" style="padding: 35px 50px 10px 50px;">
            <div style="position: sticky !important;top: 10px !important;">
                <span>
                    Status: 
                    @if(isset($survey))
                    <b style="color: green;">Updated</b>
                    @else
                    <b style="color: red;">Not Updated</b>
                    @endif
                </span>
                <br>
                <div class="field" style="padding: 0px !important;">
    	        <label>Select Session To View</label>
    	        <div class="ui fluid search selection dropdown">
    	          <input type="hidden" name="session" onchange="window.location = $(this).attr('data-url')+'/'+$(this).attr('data-id')+'/'+$(this).val()" data-url="{{url('ministry/school-survey-view')}}" data-id="{{$school->id}}">
    	          <i class="dropdown icon"></i>
    	          <div class="default text">Session</div>
    	          <div class="menu">
    	            @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
    	             <div class="item" @if($session == $i) selected @endif data-value="{{$i}}">{{$i}}/{{$i+1}}</div>
    	            @endfor
    	          </div>
    	        </div>
    	      </div>
    	       <br>
    	       <div class="ui styled accordion" style="width: 250px;">
                  <div class="title" onclick="$('.survey-form').toggleClass('all-page'); $('.export-hide').each(function(){ $(this).toggleClass('hidden') });">
                    <i class="dropdown icon"></i>
                    Export pages?
                  </div>
                  <div class="content">
                    <p>
                        Click the <i class="print blue icon"></i> icon to <b>Print</b> pages, click the <i class="file pdf orange icon"></i> icon to download pages as <b>PDF</b>.
                    </p>
                    
                    <div class="export">
                        <button class="ui circular blue icon button export-btn"  data-content="Print Pages" onclick="printPage();">
                          <i class="print icon"></i>
                        </button>
                        <button id="printPDF" class="ui circular orange icon button export-btn" data-content="Save Pages As PDF" onclick="$(this).addClass('loading'); $(this).css('pointer-events', 'none'); genPDF(this);">
                          <i class="file pdf icon"></i>
                        </button>
                    </div>
                  </div>
                </div>
              <br>
              <a href="{{route('admin.school-survey', ['session' => $session])}}" class="ui button fluid blue large">Edit Survey</a>
                <br>
              <div style="width:250px;height:auto;">
                  @include('layouts.ads.side-ad')
              </div>
            </div>
      </div>
    </div>
    <div id="editor"></div>
    <style>
        .survey-form{
            width: fit-content;
            margin: 20px auto;
            padding: 20px;
            display: flex;
            position: relative;
        }
        .main-loader{
            position: absolute;
            top: 0px;
            left: 0px;
            bottom: 0px;
            right: 0px;
            z-index: 5;
        }
        .survey-form.all-page .segment{
            display: block !important;
        }
        .survey-form li{
          margin: 15px 0px;
          color: #000;
          font-weight: bold;
          font-size: 15px;
        }
        .survey-form .segment .watermark{
          background: url('https://odsgmoe.com/eportal/public/images/header-logo.png');
          background-position: center;
          opacity: 0.1;
          position: absolute;
          top: 50%;
          left: 50%;
          transform: translate(-50%, -50%);
          width: 100%;
          height: 100%;
        }
        .survey-form .segment table{
          background: transparent;
        }
        .survey-form li .answer{
          margin-left: 10px;
          color: #777;
          font-weight: bold;
          font-size: 16px;
          text-transform: capitalize;
        }
        .survey-form td .answer{
          margin-left: 10px;
          color: #777;
          font-weight: bold;
          font-size: 16px;
          text-transform: capitalize;
        }
        .survey-form .field{
            padding: 15px 15px;
        }
        .survey-form .p-right{
            float: right;
        }
        .survey-form .p-left{
            float: left;
        }
        .survey-form .hidden{
            display: none;
        }
        .num_table input{
            width: 70px;
        }
        .export{
          margin-bottom: 20px;
        }
    </style>
@endsection
@section('scripts')
    <script src="https://odsgmoe.com/eportal/public/js/jspdf.js"></script>
    <script>
        window.onload = function(){
            $('.main-loader').remove();
        };
        
        $(function(){
            $('.ui.radio.checkbox').checkbox();
            $('.ui.accordion').accordion();
            $('.export-btn').popup();

        });
        
        function getIMages(){
            return new Promise(resolve => {
                var counter = 1;
                var doc = new jsPDF();
                var width = doc.internal.pageSize.width;
                var height = doc.internal.pageSize.height;
                doc.setFontSize(12);
                doc.text(35, 25, $('.survey-form').attr('data-title'));
                
                $('.survey-form .segment').each(function(){
                    html2canvas($(this).get(0)).then(function (canvas) {
                		var canvasWidth = canvas.width;
                		var canvasHeight = canvas.height;
                        var img = canvas.toDataURL('image/jpeg');
                        
                        // Before adding new content
                        y = 500 // Height position of new content
                        if (y >= height && counter != 1)
                        {
                          doc.addPage();
                          y = 0 // Restart height position
                        }

                        doc.addImage(img, 'JPEG', 0, 0, width, height);
                        if(counter == 4){
                            resolve(doc);
                        }
                        counter++;
                    })
                });
            });
        }
        
        function preparePage(){
            return new Promise(resolve => {
                $('.export-btn').popup('hide all');
                resolve();
            });
        }
        
        async function genPDF(obj){
            var btn = $(obj);
            var doc = await getIMages();

            doc.save(`${$('.survey-form').attr('data-title')}.pdf`);
            btn.removeClass('loading');
            btn.css('pointer-events', 'all');
        }

        async function printPage(){
            var page = await preparePage();
            window.print();
           
        }

        function switchPage(number){
            $('.survey-form .segment').each(function(){
                $(this).slideUp('fast');
            });
            $(`.survey-form .segment[data-page=${number}]`).slideDown('fast');
            
            $('.page-count a.black').addClass('grey');
            $('.page-count a.black').removeClass('black');
            
            $(`.page-count a[data-page=${number}]`).addClass('black');
            $(`.page-count a[data-page=${number}]`).removeClass('grey');
        }
    </script>
@endsection