@extends('layouts.main')
@section('content')   

<style>
.twelve {
  margin: 0 auto;
}
.form-group {
    margin-bottom: 20px;
}
.header {
  text-align: center;
}

.form-group label {
    font-weight: bold;
}

.ui.form input[type="text"], .ui.form select {
    border: 1px solid #696969;
}
</style> 

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')

  <h2 class="ui dividing header">Remove Subjects from Teacher</h2>

<div class="ui stackable equal height stackable grid">

    <div class="twelve wide column">

                        <form method="post" action="" class="ui form">
                                {{csrf_field()}}

                                <div class="form-group">
                                    <label class="col-md-3 control-label">Teachers</label>
                                    <div class="col-md-5">
                                        <div class="field">
                                            <select id="teacher_id" name="teacher_id" required class="ui fluid search dropdown">
                                                <option value="">Choose</option>
                                                @if(count($teachers) > 0)
                                                  @foreach($teachers as $teacher)
                                                      <option value="{{$teacher->id}}">{{$teacher->surname}} {{$teacher->firstname}} {{$teacher->middlename}}</option>
                                                  @endforeach
                                                @endif
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div id="data_box"></div>

                                <div class="form-group text-center m-t-30">
                                    <div class="col-md-4 col-xs-offset-4" id="submit_btn_box">
                                        <input type="submit" class="ui small blue button" id="form_submit" name="form_submit" value="Save" />
                                        <input type="hidden" name="school_id" value="{{$school_id}}">
                                    </div>
                                </div>
                            </form>

    </div>

</div>
  
</section>

<div class="jtr"></div>

<script type="text/javascript">

$(document).ready(function(){
    $("#submit_btn_box").hide();
});

var site_url = "{{url('/admin')}}";
var token = "{{csrf_token()}}";
var ajax_loader = "{{url_public('/images/ajax-loader.gif')}}";

$("#teacher_id").on('change', function(){
    var teacher_id = $("#teacher_id").val();
    
    if(teacher_id){

        var form_data = {
            teacher_id : teacher_id,
            _token : token
        }

        $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
        $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
        $("#pagewrap_ajax_box").show('slow');          
        $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
        window.oncontextmenu = function(){return false;}    // Disable right click  
        $("select").prop('disabled', true);                    // Disable form input

        $.ajax({
            url :   site_url+"/classarm/unassign-get-teacher-subjects",
            type :  "POST",
            data :  form_data,
            dataType: "html",
            cache :     false
        })
        .done(function(resp){   
            window.oncontextmenu = function(){return true;}     // Enable right click
            $("#pagewrap_ajax_box").html('');                  
            $("#pagewrap_ajax_box").hide();                    
            $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});  
            $("select").prop('disabled', false);                   // Enable form input       

            if(resp == 1){
                $("#data_box").html('No Subjects were found');
            }
            else{
                $("#submit_btn_box").show();
                $("#data_box").html(resp);
            }
            
            })
        .fail(function(){
            window.oncontextmenu = function(){return true;}     // Enable right click
            $("#pagewrap_ajax_box").html('');                  
            $("#pagewrap_ajax_box").hide();                    
            $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
            $("select").prop('disabled', false);                   // Enable form input 

            alert('Error encountered while processing request. Pls try again shortly');  
        }); 

    }//end if
});
</script>

@endsection 