@extends('layouts.main')
@section('content')

<section class="ui raised segment" style="max-width: 1024px; margin: 20px auto;">
		@include('partial.error')
		<form class="ui form" action="{{route('super.admin.view.school.subjects.post')}}" method="post" enctype="multipart/form-data">
			<input type="hidden" name="_token" value="{{csrf_token()}}">
		  <h2 class="ui dividing header">Search Available Subjects</h2>
		  <div class="two fields">

	      <div class="field">
	        <label>Subjects</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="id" value="{{old('id')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Subjects</div>
	          <div class="menu">
	          @foreach($all_subjects as $subject)
				<div class="item" data-value="{{$subject->id}}">{{$subject->subject_name}}</div>
	          @endforeach
	          </div>
	        </div>
	      </div>
		    
	      <div class="field">
	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View Subjects</button>
	      </div>

	    </div>
		  
		</form>
		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  <i class="student icon"></i>
		  View Subjects Information
		</h2>
		<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">Subjects</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Subject Area Teachers</div>
		    </th>
		    @if(auth('super_admin')->check())
		    <th colspan="2">
		    	<div class="ui ribbon label">Actions on Teachers</div>
		    </th>
		    @endif
		  </tr></thead>
		  <tbody>
		  @if(count($subjects) > 0)
		  	@foreach($subjects as $subject)
		    <tr>
		      <td>{{$subject->subject_name.' ('.$subject->class_category.')'}}</td>
		      <td>
		      	<div class="ui middle aligned divided list">
		      	@if(count(getAssocTeacher($subject->id)) > 0)
		      	@foreach(getAssocTeacher($subject->id) as $s_t)
		      	<div class="item">
				    <div class="content">
				      <p class="header">{{$s_t->surname.' '.$s_t->firstname.' '.$s_t->middlename}}</p>
				    </div>
				</div>
		      	@endforeach
		      	@else
		      	<div class="ui icon negative message">
					<div class="item">
					    <div class="content">
					      <p class="header">No teacher for this subject</p>
					    </div>
					</div>
				</div>
		      	@endif
		      	</div>
		      </td>
		       @if(auth('super_admin')->check())
		      @if(auth('super_admin')->user()->can('edit-subject'))
		      <td class="std-view">
			      <button class="ui labeled blue icon button" data-std-id="{{$subject->id}}" data-href="{{route('super.admin.edit.school.subjects', ['id' => $subject->id])}}">
				  <i class="edit icon"></i>
				  Edit
				</button>
			  </td>
			  @endif
			  @if(auth('super_admin')->user()->can('delete-subject'))
		      <td class="std-view">
				<button class="ui labeled negative icon button" data-std-id="{{$subject->id}}" data-href="{{route('super.admin.delete.school.subjects', ['id' => $subject->id])}}">
				  <i class="trash icon"></i>
				  Delete
				</button>
		      </td>
		      @endif
		      @endif
		    </tr>
		   @endforeach
		    @else
			<tr>
				<th colspan="{{auth('super_admin')->check() ? '4' : '2'}}">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		  <tfoot>
		    <tr><th colspan="{{auth('super_admin')->check() ? '4' : '2'}}">
		      @include('pagination.post-default', ['paginator' => $subjects])
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="{{csrf_token()}}">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
@endsection