@extends('layouts.main')
@section('content')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')
<form class="ui form" action="" method="post">
  <h2 class="ui dividing header">Subject Registration</h2>
  <div class="field">
    <input type="hidden" value="{{csrf_token()}}" name="_token" value="{{old('_token')}}">
    <input type="hidden" value="put" name="_method">
    
    <div class="four fields">
      <div class="field">
      <label>Subject Name</label>
        <input type="text" name="subject_name" @if(!empty(old('subject_name')))
          value="{{old('subject_name')}}"
        @else
          value="{{$subject->subject_name}}"
        @endif placeholder="Subject Name">
      </div>
      <div class="field">
      <label>Subject Code</label>
        <input type="text" name="subject_code" @if(!empty(old('subject_code')))
          value="{{old('subject_code')}}"
        @else
          value="{{$subject->subject_code}}"
        @endif placeholder="Subject Code">
      </div>
      <div class="field">
        <label>Class Category</label>
        <div class="ui fluid search selection dropdown">
          <input type="hidden" name="class_category" @if(!empty(old('subject_code')))
          value="{{old('class_category')}}"
        @else
          value="{{$subject->class_category}}"
        @endif>
          <i class="dropdown icon"></i>
          <div class="default text">Class Category</div>
          <div class="menu">
             <div class="item" data-value="JSS">JSS</div>
             <div class="item" data-value="SSS">SSS</div>
          </div>
        </div>
      </div>
      <div class="field">
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white; margin-top:22.5px;">Update Teachers</button>
      </div>
    </div>
  </div>
</form>
<h2 class="ui dividing header">Available Subjects</h2>
@if(count($subjects) > 0)
  <div class="ui tag labels">
  @foreach($subjects as $key => $subject)
  <a class="ui {{getDynamicColorByKey($key)}} label">
    {{$subject->subject_code.' => '.$subject->subject_name.' ('.$subject->class_category.')'}}
  </a>

  @endforeach
</div>
@else
@endif
</section>
<div class="jtr"></div>
@endsection