@extends('layouts.main')
@section('content')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')
<form class="ui form" action="{{route('super.admin.register.school.subjects')}}" method="post">
  <h2 class="ui dividing header">Subject Registration</h2>
  <div class="field">
    <input type="hidden" value="{{csrf_token()}}" name="_token" value="{{old('_token')}}">
    
    <div class="four fields">
      <div class="field">
      <label>Subject Name</label>
        <input type="text" name="subject_name" value="{{old('subject_name')}}" placeholder="Subject Name">
      </div>
      <div class="field">
      <label>Subject Code</label>
        <input type="text" name="subject_code" value="{{old('subject_code')}}" placeholder="Subject Code">
      </div>
      <div class="field">
        <label>Class Category</label>
        <div class="ui fluid search selection dropdown">
          <input type="hidden" name="class_category" value="{{old('class_category')}}">
          <i class="dropdown icon"></i>
          <div class="default text">Class Category</div>
          <div class="menu">
             <div class="item" data-value="JSS">JSS</div>
             <div class="item" data-value="SSS">SSS</div>
          </div>
        </div>
      </div>
      <div class="field">
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white; margin-top:22.5px;">Register Subject</button>
      </div>
    </div>
  </div>
</form>
<h2 class="ui dividing header">Available Subjects</h2>
@if(count($all_subjects) > 0)
  <div class="ui tag labels">
  @foreach($all_subjects as $key => $subject)
  <a class="ui {{getDynamicColorByKey($key)}} label">
    {{$subject->subject_code.' => '.$subject->subject_name.' ('.$subject->class_category.')'}}
  </a>

  @endforeach
</div>
@else
@endif
</section>
<div class="jtr"></div>
@endsection