@extends('layouts.main')
@section('content')
	<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
		@include('partial.error')
		<form class="ui form" action="{{route('super.admin.batch.register.school.subjects')}}" method="post" enctype="multipart/form-data">
		<input type="hidden" name="_token" value="{{csrf_token()}}">
		  <h2 class="ui dividing header">Batch Subject Registration</h2>
		  <div class="two fields">
	      <div class="field">
		      	<label>File Upload</label>
		      	<div class="ui right action input">
				  <input type="text" class="pseudo-batch-file-name" name="pseudo_batch_file_name" >
				  <button type="button" class="ui orange labeled icon button pseudo-batch-file">
				    <i class="file excel outline icon"></i>
				    Upload Excel File
				  </button>
				</div>
        		<input type="file" name="batch_file" id="batch_file" class="batch-file" style="display: none">
		   </div>

			<div class="field">
		      <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:22.5px;">Batch Register Subject</button>
		  </div>
	    </div>
		</form>
		<h2 class="ui dividing header">Available Subjects</h2>
		@if(count($all_subjects) > 0)
		  <div class="ui tag labels">
		  @foreach($all_subjects as $key => $subject)
		  <a class="ui {{getDynamicColorByKey($key)}} label">
		    {{$subject->subject_code.' => '.$subject->subject_name.' ('.$subject->class_category.')'}}
		  </a>
		  @endforeach
		</div>
		@else
		@endif
	</section>
@endsection