@extends('layouts.main')
@section('content')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')
<form class="ui form" action="" method="post">
  <h2 class="ui dividing header">Assign Subject To Class</h2>
  <div class="field">
    <input type="hidden" value="{{csrf_token()}}" name="_token" value="{{old('_token')}}">
    
    <div class="four fields">
      <div class="field">
        <label>Class</label>
        <div class="ui fluid search selection dropdown" id="classes-dropdown">
          <input type="hidden" name="class_id" value="{{old('class_id')}}" data-href="{{url('/do-ajax/class')}}" >
          <i class="dropdown icon"></i>
          <div class="default text">Class</div>
          <div class="menu">
            @foreach($classes as $class)
             <div class="item" data-value="{{$class->id}}">{{$class->class_name}}</div>
            @endforeach
          </div>
        </div>
      </div>

      <div class="field" id="field-arms">
        <label>Class Arm</label>
        <div class="ui fluid search selection dropdown">
          <input type="hidden" name="class_arm_id" value="{{old('class_arm_id')}}">
          <i class="dropdown icon"></i>
          <div class="default text">Class Arm</div>
          <div class="menu" id="class-arms">
            @if(!empty(old('class_id')))
                @foreach(getClassArms(old('class_id')) as $class_arm)
                 <div class="item" data-value="{{$class_arm->id}}">{{$class_arm->class_arm}}</div>
                @endforeach
              @else
                 <div class="item" data-value="">Select Class Arm</div>
              @endif
            
          </div>
        </div>
      </div>
      <div class="field">
        <label>Assign Subjects</label>
         <select multiple="" class="ui dropdown" name="subjects[]" >
             @foreach($subjects as $subject)
              <option  value="{{$subject->id}}" 
              @if(!empty(old('subjects')) && in_array($subject->id, old('subjects')))
                  selected="selected"
              @endif
              >{{$subject->subject_name.' ('.$subject->class_category.')'}}</option>
             @endforeach
         </select>
      </div>

      <div class="field">
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white; margin-top:22.5px;">Assign Subject to Class</button>
      </div>
    </div>
  </div>
</form>
<h2 class="ui horizontal divider header" style="color:#dc4900;">
      <i class="student icon"></i>
      View Subjects Assigns To Class
    </h2>
    <table class="ui celled table">
      <thead>
        <tr>
        <th>
          <div class="ui ribbon label">Classes and Class Arms</div>
        </th>
        <th>
          <div class="ui ribbon label">Subjects</div>
        </th>
        <th colspan="2">
          <div class="ui ribbon label">Actions on Subjects Assign</div>
        </th>
      </tr></thead>
      <tbody>
      @if(count($classarms) > 0)
        @foreach($classarms as $classarm)
        <tr>
          <td>{{getClassNameByClassID($classarm->class_id) .' '.$classarm->class_arm }}</td>
          <td>
            <div class="ui middle aligned divided list">
            @if(count(getAssocSubjectByClassArmID($classarm->id)) > 0)
            @foreach(getAssocSubjectByClassArmID($classarm->id) as $subject)
            <div class="item">
            <div class="content">
              <p class="header">{{$subject->subject_name.' ('.$subject->class_category.')'}}</p>
            </div>
        </div>
            @endforeach
            @else
            <div class="ui icon negative message">
          <div class="item">
              <div class="content">
                <p class="header">No Subject assign to this class arm</p>
              </div>
          </div>
        </div>
            @endif
            </div>
          </td>
          <td class="std-view">
            <button class="ui labeled blue icon button" data-std-id="{{$classarm->id}}" data-href="{{route('admin.edit.assign.subject.to.class', ['id' => $classarm->id])}}" data-message="Are you sure want to edit the subjects assigned to">
          <i class="edit icon"></i>
          Edit
        </button>
        </td>
          <td class="std-view">
        <button class="ui labeled negative icon button" data-std-id="{{$classarm->id}}" data-href="{{route('admin.edit.assign.subject.to.class', ['id' => $classarm->id])}}" data-message="Are you sure want to delete the subjects assigned to">
          <i class="trash icon"></i>
          Delete
        </button>
          </td>
        </tr>
       @endforeach
        @else
      <tr>
        <th colspan="4">
          <div class="ui icon negative message">
            <i class="info circle icon"></i>
            <div class="content">
              <div class="header">
              Sorry, No Record can be found.
              </div>
            </div>
           </div>
        </th>
      </tr>
      @endif
      </tbody>
      <tfoot>
        <tr><th colspan="4">
          @include('pagination.default', ['paginator' => $classarms])
        </th>
      </tr></tfoot>
    </table>
</section>
<div class="ui modal" id="edit">
    <div class="header">Header</div>
    <div class="image content">
      <div class="description">

      </div>
    </div>
    <div class="actions">
      <div class="ui cancel button">Cancel</div>
      <a href="" class="ui approve blue button">Edit</a>
    </div>
  </div>

  <div class="ui modal" id="delete">
    <div class="header">Header</div>
    <div class="image content">
      <div class="description">

      </div>
    </div>
    <div class="actions">
      <div class="ui cancel button">Cancel</div>
      <form action="" method="post" style="display:inline-block;">
        <input type="hidden" name="_token" value="{{csrf_token()}}">
        <input type="hidden" name="_method" value="delete">
        <button type="submit" class="ui approve negative button">Delete</button>
      </form>
    </div>
  </div>
<div class="jtr"></div>
@endsection