@extends('layouts.main')
@section('content')   

<style>
.twelve {
  margin: 0 auto;
}
.form-group {
    margin-bottom: 20px;
}
.header {
  text-align: center;
}

.form-group label {
    font-weight: bold;
}

.ui.form input[type="text"], .ui.form select {
    border: 1px solid #696969;
}
</style> 

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')

  <h2 class="ui dividing header">Assign Subjects to Teacher</h2>

<div class="ui stackable equal height stackable grid">

    <div class="twelve wide column">

                        <form method="post" action="" class="ui form">
                                {{csrf_field()}}

                                <div class="form-group">
                                    <label class="col-md-3 control-label">Teachers</label>
                                    <div class="col-md-5">
                                        <div class="field">
                                            <select id="teacher_id" name="teacher_id" required class="ui fluid search dropdown">
                                                <option value="">Choose</option>
                                                @if(count($teachers) > 0)
                                                  @foreach($teachers as $teacher)
                                                      <option value="{{$teacher->id}}">{{$teacher->surname}} {{$teacher->firstname}} {{$teacher->middlename}}</option>
                                                  @endforeach
                                                @endif
                                            </select>
                                        </div>
                                    </div>
                                </div>


                                <div class="form-group">
                                    <label class="col-md-3 control-label">Subject</label>
                                    <div class="col-md-5">
                                        <div class="field">
                                            <select id="subject_id" name="subject_id[]" multiple="multiple" required class="ui fluid search dropdown">
                                                <option value="">Choose</option>
                                                @if(count($subjects) > 0)
                                                  @foreach($subjects as $subject)
                                                      <option value="{{$subject->id}}">{{$subject->subject_name.'( '. $subject->class_category.' )'}}</option>
                                                  @endforeach
                                                @endif
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group text-center m-t-30">
                                    <div class="col-md-4 col-xs-offset-4" id="submit_btn_box">
                                        <input type="submit" class="ui small blue button" id="form_submit" name="form_submit" value="Save" />
                                        <input type="hidden" name="school_id" value="{{$school_id}}">
                                    </div>
                                </div>
                            </form>

    </div>

</div>
  
</section>

<div class="jtr"></div>

@endsection 