@extends('layouts.main-datatable')
@section('content')

<style type="text/css">
.ui.labeled.icon.button {
    position: relative;
    padding-left: 2.5em !important;
    padding-right: 1em !important;
}
</style>

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
		@include('partial.error')
		  <h2 class="ui dividing header">View FLoating Students Without Class Arm</h2>

		  <div id="student_holder"></div>

<script type="text/javascript">

var site_url = "{{url('/admin/student')}}";
var token = "{{csrf_token()}}";
var ajax_loader = "{{url_public('/images/ajax-loader.gif')}}";

	
$(document).ready(function(){

    var form_data = {
        _token : token
    }

    $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
    $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
    $("#pagewrap_ajax_box").show('slow');          
    $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
    window.oncontextmenu = function(){return false;}    // Disable right click  

    $.ajax({
        url :   site_url+"/fetch-school-floating-student",
        type :  "POST",
        data :  form_data,
        dataType: "html",
        cache :     false
    })
    .done(function(resp){   
        window.oncontextmenu = function(){return true;}     // Enable right click
        $("#pagewrap_ajax_box").html('');                  
        $("#pagewrap_ajax_box").hide();                    
        $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});       

        $("#student_holder").html(resp);
        $('#global_datatable').dataTable();
        })
    .fail(function(){
        window.oncontextmenu = function(){return true;}     // Enable right click
        $("#pagewrap_ajax_box").html('');                  
        $("#pagewrap_ajax_box").hide();                    
        $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   

        alert('Error encountered while processing request. Pls try again shortly');  
    }); 

});	

</script>

	</section>
	
@endsection