@extends('layouts.main')
@section('content')

<section class="ui raised" style="max-width: 1150px; margin: 20px auto;">
		@include('partial.error')
		<div class="print-none">
            <form class="ui form" action="{{route('admin.student.verification')}}" method="post" enctype="multipart/form-data">
                <input type="hidden" name="_token" value="{{csrf_token()}}">
            <h2 class="ui dividing header">Get Registered Students</h2>
            <div class="five fields">
            <div class="field">
                <label>Session</label>
                <div class="ui fluid search selection dropdown">
                <input type="hidden" name="session" value="{{old('session')}}">
                <i class="dropdown icon"></i>
                <div class="default text">Session</div>
                <div class="menu">
                    @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
                    <div class="item" data-value="{{$i}}">{{$i}}/{{$i+1}}</div>
                    @endfor
                </div>
                </div>
            </div>
            <div class="field">
                <label>Term</label>
                <div class="ui fluid search selection dropdown">
                <input type="hidden" name="term" value="{{old('term')}}">
                <i class="dropdown icon"></i>
                <div class="default text">Term</div>
                <div class="menu">
                    <div class="item" data-value="First"> First Term </div>
                    <div class="item" data-value="Second"> Second Term </div>
                    <div class="item" data-value="Third"> Third Term </div>
                </div>
                </div>
            </div>
            
            <div class="field">
                <label>Class</label>
                <div class="ui fluid search selection dropdown" id="classes-dropdown">
                <input type="hidden" name="class_id" value="{{old('class_id')}}" data-href="{{url('/do-ajax/class')}}">
                <i class="dropdown icon"></i>
                <div class="default text">Class</div>
                <div class="menu">
                    @foreach($classes as $class)
                    <div class="item" data-value="{{$class->id}}">{{$class->class_name}}</div>
                    @endforeach
                </div>
                </div>
            </div>
            <div class="field" id="field-arms">
                <label>Class Arm</label>
                <div class="ui fluid search selection dropdown">
                <input type="hidden" name="class_arm_id" value="{{old('class_arm_id')}}">
                <i class="dropdown icon"></i>
                <div class="default text">Class Arm</div>
                <div class="menu" id="class-arms">
                    @if(!empty(old('class_id')))
                        @foreach(getClassArms(old('class_id')) as $class_arm)
                        <div class="item" data-value="{{$class_arm->id}}">{{$class_arm->class_arm}}</div>
                        @endforeach
                    @else
                        <div class="item" data-value="">Select Class Arm</div>
                    @endif
                    
                </div>
                </div>
            </div>

            <div class="field">
                <label>Viw Type</label>
                <div class="ui fluid search selection dropdown">
                <input type="hidden" name="view_type">
                <i class="dropdown icon"></i>
                <div class="default text">Select Type</div>
                <div class="menu">
                    <div class="item" data-value="view all">View All</div>
                    <div class="item" data-value="view paginated">View Paginated</div>
                </div>
                </div>
            </div>

            <div class="field">
                <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View Students</button>
            </div>

            </div>
            
            </form>
            <h2 class="ui horizontal divider header" style="color:#dc4900;">
            <i class="student icon"></i>
                Students Information  <div class="ui button blue printBtn">PRINT PAGE <i class="print icon"></i></div>
            </h2>
        </div>
        <div class="ui print-area stackable equal height stackable grid">
            <div class="two column row printGrid">
            @if(count($students) > 0)
                @php $page = (isset($_GET['page'])) ? ((int)$_GET['page'] - 1) : 0; $counter = $page * $students->perPage() @endphp
                @foreach($students as $student)
                <div class="column container">
                    <div class="student-card">
                        <div class="ui grid">
                            <div class="row">
                                <div class="four wide column">
                                    <img class="ui fuild image" src="{{url_public($student->passport)}}" height="100" width="100">
                                </div>
                                <div class="twelve wide column field-line">
                                    <div class="line">
                                        <div class="title">STUDENT OSSI NUMBER:</div>
                                        <div class="underline" style="width: 53%;">{{$student->regnum}}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br>
                        <br>
                        <br>
                        <div class="ui stackable equal height  grid field-line">
                            <div class="line">
                                <div class="title">NAME:</div>
                                <div class="underline" style="width: 90%;">{{$student->surname.' '.$student->firstname.' '.$student->middlename}}</div>
                            </div>
                        </div>
                        <br>
                        <br>
                        <br>
                        <div class="ui stackable equal height stackable grid">
                            <div class="row">
                                <div class="eight wide column field-line">
                                    <div class="line">
                                        <div class="title">GENDER:</div>
                                        <div class="underline" style="width: 60%;">{{$student->gender}}</div>
                                    </div>
                                </div>
                                <div class="eight wide column field-line">
                                    <div class="line">
                                        <div class="title">BLOOD GROUP:</div>
                                        <div class="underline" style="width: 50%;">{{$student->blood_group}}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br>
                        <br>
                        <br>
                        <div class="ui stackable equal height  grid field-line">
                            <div class="line">
                                <div class="title">PARENT/GUARDIAN NAME:</div>
                                <div class="underline" style="width: 65%;">{{$student->parent_fullname}}</div>
                            </div>
                        </div>
                        <br>
                        <br>
                        <br>
                        <div class="ui stackable equal height  grid field-line">
                            <div class="line">
                                <div class="title">PARENT/GUARDIAN PHONE:</div>
                                <div class="underline" style="width: 64%;">{{$student->parent_phone}}</div>
                            </div>
                        </div>
                        <br>
                        <br>
                        <br>
                        <div class="ui stackable equal height  grid field-line">
                            <div class="line">
                                <div class="title">PARENT/GUARDIAN ADDRESS:</div>
                                <div class="underline" style="width: 61%;">{{$student->parent_address}}</div>
                            </div>
                        </div>
                        <br>
                        <br>
                        <br>
                        <div class="ui stackable equal height stackable grid">
                            <div class="row">
                                <div class="eight wide column field-line">
                                    <div class="line">
                                        <div class="title">CLASS:</div>
                                        <div class="underline" style="width: 70%;">{{App\Classes::find($_POST['class_id'])->class_name}}</div>
                                    </div>
                                </div>
                                <div class="eight wide column field-line">
                                    <div class="line">
                                        <div class="title">CLASS ARM:</div>
                                        <div class="underline" style="width: 58%;">{{App\ClassArms::find($_POST['class_arm_id'])->class_arm}}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            @else
                <div class="ui icon negative message">
                    <i class="info circle icon"></i>
                    <div class="content">
                        <div class="header">
                            Sorry, No Record can be found.
                        </div>
                    </div>
                </div>
            @endif
            </div>
        </div>
	</section>
<style>
.field-line {
    position: relative;
}
.field-line .line{
    width: 100%;
    position: absolute;
    bottom: 20px;
    display: inline-flex;
}
.field-line .line h5{
    margin-top: 30px !important;
    background: red;
}

.field-line .underline{
    border-style: none;
    border-bottom: 1px solid #888 !important;
    margin-left: 5px;
    /* background: #456; */
    color: grey;
    font-size: 14px;
    text-align: center;
    text-transform: uppercase;
    word-spacing: 3px;
}
@media print {
    .print-none{
        display: none !important;
    }
    .print-area{
        margin-top: 2em;
        /* display: none !important; */
        zoom: 60% !important;
    }
    .student-card{
        zoom: 75%;
    }
}
.student-card{
    clear: both;
    box-shadow: 1px 3px 14px #999;
    border-radius: 3px;
    /* margin: 6px; */
    margin: 2em 0.5em;
    zoom: 85%;
    /* border: 1px solid #333; */
    padding: 5px;
}
/* oludipo.gbolahan@etranzact.com */
/* devops@etranzact.com */
/* technicalsupport@etranzact.com */
</style>
<script>
$(document).ready(function(){
    var printBtn = $('.printBtn');
    printBtn.click(function(){
        setTimeout(() => {
            window.print();
        }, 1000);
    });
});
</script>
@endsection