@extends('layouts.main')
@section('content')

<style type="text/css">
.ui.labeled.icon.button {
    position: relative;
    padding-left: 2.5em !important;
    padding-right: 1em !important;
}
</style>

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
		@include('partial.error')
		<form class="ui form" action="{{route('admin.students.list.subjects')}}" method="post" enctype="multipart/form-data">
			<input type="hidden" name="_token" value="{{csrf_token()}}">
		  <h2 class="ui dividing header">Search Students to Deregister Subjects</h2>
		  <div class="five fields">
	      <div class="field">
	        <label>Session</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="session" value="{{old('session')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Session</div>
	          <div class="menu">
	            @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
	             <div class="item" data-value="{{$i}}">{{$i}}/{{$i+1}}</div>
	            @endfor
	          </div>
	        </div>
	      </div>
	      <div class="field">
	        <label>Term</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="term" value="{{old('term')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Term</div>
	          <div class="menu">
	             <div class="item" data-value="First"> First Term </div>
	             <div class="item" data-value="Second"> Second Term </div>
	             <div class="item" data-value="Third"> Third Term </div>
	          </div>
	        </div>
	      </div>
	      
	      <div class="field">
	        <label>Class</label>
	        <div class="ui fluid search selection dropdown" id="classes-dropdown">
	          <input type="hidden" name="class_id" value="{{old('class_id')}}" data-href="{{url('/do-ajax/class')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Class</div>
	          <div class="menu">
	            @foreach($classes as $class)
	             <div class="item" data-value="{{$class->id}}">{{$class->class_name}}</div>
	            @endforeach
	          </div>
	        </div>
	      </div>
	      <div class="field" id="field-arms">
	        <label>Class Arm</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="class_arm_id" value="{{old('class_arm_id')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Class Arm</div>
	          <div class="menu" id="class-arms">
	            @if(!empty(old('class_id')))
	                @foreach(getClassArms(old('class_id')) as $class_arm)
	                 <div class="item" data-value="{{$class_arm->id}}">{{$class_arm->class_arm}}</div>
	                @endforeach
	              @else
	                 <div class="item" data-value="">Select Class Arm</div>
	              @endif
	            
	          </div>
	        </div>
	      </div>
	      <div class="field">
	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View Students</button>
	      </div>

	    </div>
		  
		</form>

	</section>
	
@endsection