@extends('layouts.main')
@section('content')

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')
    <form class="ui form" action="" method="post">
      <h2 class="ui dividing header">Quick Edit Student</h2>
      <div class="field">
        <input type="hidden" name="_method" value="put">
        <input type="hidden" value="{{csrf_token()}}" name="_token">
        <label>Name</label>
        <div class="three fields">
          <div class="field">
            <input type="text" name="surname" @if(!empty(old('surname')))
              value="{{old('surname')}}"
            @else
              value="{{$student->surname}}"
            @endif placeholder="Surname">
          </div>
          <div class="field">
            <input type="text" name="firstname" @if(!empty(old('firstname')))
              value="{{old('firstname')}}"
            @else
              value="{{$student->firstname}}"
            @endif placeholder="First Name">
          </div>
          <div class="field">
            <input type="text" name="middlename" @if(!empty(old('middlename')))
              value="{{old('middlename')}}"
            @else
              value="{{$student->middlename}}"
            @endif placeholder="Other Name">
          </div>
        </div>
      </div>

       <div class="field">
        <div class="four fields">
          <div class="ui calendar field" id="example2">
            <label>Date of Birth</label>
            <div class="ui input left icon">
              <i class="calendar icon"></i>
              <input type="text" placeholder="Date of Birth" name="dob"   @if(!empty(old('dob')))
                value="{{old('dob')}}"
              @else
                value="{{$student->dob}}"
              @endif>
            </div>
          </div>
          <div class="field">
            <label>Gender</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="gender"    @if(!empty(old('gender')))
                  value="{{old('gender')}}"
                @else
                  value="{{$student->gender}}"
                @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Gender</div>
              <div class="menu">
                 <div class="item" data-value="Male"><i class="male icon"></i>Male</div>
                 <div class="item" data-value="Female"><i class="female icon"></i>Female</div>
              </div>
            </div>
          </div>
          
          <div class="field">
            <label>Blood Group</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="blood_group" @if(!empty(old('blood_group'))) 
            value="{{old('blood_group')}}"
            @else
            value="{{$student->blood_group}}"
            @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Blood Group</div>
              <div class="menu">
                 <div class="item" data-value="O+">O+</div>
                 <div class="item" data-value="O-">O-</div>
                 <div class="item" data-value="A+">A+</div>
                 <div class="item" data-value="A-">A-</div>
                 <div class="item" data-value="B+">B+</div>
                 <div class="item" data-value="B-">B-</div>
                 <div class="item" data-value="AB+">AB+</div>
                 <div class="item" data-value="AB-">AB-</div>
                 <div class="item" data-value="Unavailable">Unavailable</div>
              </div>
            </div>
          </div>
          
          <div class="field">
            <label>Student House</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="house_id"  @if(!empty(old('house_id')))
                  value="{{old('house_id')}}"
                @else
                  value="{{$student->house_id}}"
                @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Student House</div>
              <div class="menu">
                @forelse($school_houses as $school_house)
                 <div class="item" data-value="{{$school_house->id}}">{{$school_house->name}}</div>
                @empty
                  <div class="item">School house has not been created</div>
                @endforelse
              </div>
            </div>
          </div>
      </div>

      

      <div class="field">
        <div class="four fields">

          <div class="four wide field">
            <label>Student's Password</label>
            <input type="password" name="password" placeholder="Student's Password">
          </div>

          <div class="four wide field">
            <label>Student's Confirm Password</label>
            <input type="password" name="password_confirmation" placeholder="Student's Confirm Password">
          </div>

        </div>
      </div>      

<input type="submit" class="ui small blue button" id="form_submit" name="form_submit" value="Save Update" />
      
      
  </form>
</section>
<div class="jtr"></div>
@endsection