@extends('layouts.main')
@section('content')
<section class="ui stackable grid raised segment" style="margin: 20px auto; max-width: 1024px">
<div class="sixteen wide column">
@include('partial.error')

          <h2 class="ui dividing header">Move {{$student->surname.' '.$student->firstname}} to New Class Arm</h2>
</div>


    <div class="five wide column">
        <div><img src="{{url_public($student->passport)}}" class="ui small image"></div>
        <div class="ui divided list cart-summary">


          <div class="item">  
            <div class="content">
              <strong class="">Name: </strong> 
              <span class="mini meta"> {{$student->surname.' '.$student->firstname.' '.$student->middlename}}</span> 
            </div> 
          </div> 

          <div class="item">  
            <div class="content">
              <strong class="">OSSI: </strong> 
              <span class="mini meta"> {{$student->regnum}}</span> 
            </div> 
          </div> 

        </div>
    </div>


    <div class="eleven wide column">

        <form class="ui form" action="{{route($route)}}" method="post">

        <input type="hidden" value="{{csrf_token()}}" name="_token" value="{{old('_token')}}">
      <input type="hidden" name="student_id" value="{{$student->id}}">
        <div class="two fields">
          <div class="field">
            <label>Session</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="next_session" value="{{old('session')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Session</div>
              <div class="menu">
                @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
                 <div class="item" data-value="{{$i}}">{{$i}}/{{$i+1}}</div>
                @endfor
              </div>
            </div>
          </div>
        @if(!isset($subject_teacher))
          <div class="field">
            <label>Term</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="next_term" value="{{old('term')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Term</div>
              <div class="menu">
                 <div class="item" data-value="First"> First Term </div>
                 <div class="item" data-value="Second"> Second Term </div>
                 <div class="item" data-value="Third"> Third Term </div>
              </div>
            </div>
          </div>
        @endif
        </div>

        <div class="two fields">
          <div class="field">
            <label>Class</label>
            <div class="ui fluid search selection dropdown" id="classes-dropdown">
              <input type="hidden" name="next_class_id" value="{{old('class_id')}}" data-href="{{url('/do-ajax/class')}}" >
              <i class="dropdown icon"></i>
              <div class="default text">Class</div>
              <div class="menu">
                @foreach($classes as $class)
                 <div class="item" data-value="{{$class->id}}">{{$class->class_name}}</div>
                @endforeach
              </div>
            </div>
          </div>

          <div class="field" id="field-arms">
            <label>Class Arm</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="next_classarm_id" value="{{old('class_arm_id')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Class Arm</div>
              <div class="menu" id="class-arms">
                @if(!empty(old('class_id')))
                    @foreach(getClassArms(old('class_id')) as $class_arm)
                     <div class="item" data-value="{{$class_arm->id}}">{{$class_arm->class_arm}}</div>
                    @endforeach
                  @else
                     <div class="item" data-value="">Select Class Arm</div>
                  @endif
                
              </div>
            </div>
          </div>
        </div>
      <div class="field">
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Move to Class Arm</button>
          </div>
        </form>

    </div>

</section>
<div class="jtr"></div>
@endsection