@extends('layouts.main')
@section('content')

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')
    <form class="ui form" action="{{route('admin.register.school.students')}}" method="post">
      <h2 class="ui dividing header">Student Registration</h2>
      <div class="field">
        <input type="hidden" value="{{csrf_token()}}" name="_token" value="{{old('_token')}}">
        <label>Name</label>
        <div class="three fields">
          <div class="field">
            <input type="text" name="surname" value="{{old('surname')}}" placeholder="Surname">
          </div>
          <div class="field">
            <input type="text" name="firstname" value="{{old('firstname')}}" placeholder="First Name">
          </div>
          <div class="field">
            <input type="text" name="middlename" value="{{old('middlename')}}" placeholder="Other Name">
          </div>
        </div>
      </div>

       <div class="field">
        <div class="four fields">
          <div class="ui calendar field" id="example2">
            <label>Date of Birth</label>
            <div class="ui input left icon">
              <i class="calendar icon"></i>
              <input type="text" placeholder="Date of Birth" name="dob" value="{{old('dob')}}">
            </div>
          </div>
          <div class="field">
            <label>Gender</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="gender" value="{{old('gender')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Gender</div>
              <div class="menu">
                 <div class="item" data-value="Male"><i class="male icon"></i>Male</div>
                 <div class="item" data-value="Female"><i class="female icon"></i>Female</div>
              </div>
            </div>
          </div>
          <div class="field">
            <label>Country</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="country" value="{{old('country')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Country</div>
              <div class="menu">
                 <div class="item" data-value="Nigeria"><i class="flag ng"></i>Nigeria</div>
                 <div class="item" data-value="Other">Others</div>
              </div>
            </div>
          </div>
          <div class="field">
            <label>Student House</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="house_id" value="{{old('house_id')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Student House</div>
              <div class="menu">
                @forelse($school_houses as $school_house)
                 <div class="item" data-value="{{$school_house->id}}">{{$school_house->name}}</div>
                @empty
                  <div class="item">School house has not been created</div>
                @endforelse
              </div>
            </div>
          </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="seven wide field">
          <label>Contact Address</label>
            <input type="text" name="address" value="{{old('address')}}" placeholder="Contact Address">
          </div>
          <div class="three wide field">
            <label>State of Origin</label>
            <div class="ui fluid search selection dropdown" id="states-dropdown">
              <input type="hidden" name="state_id" value="{{old('state_id')}}" data-href="{{url('/do-ajax/state')}}">
              <i class="dropdown icon"></i>
              <div class="default text">States</div>
              <div class="menu">
                @foreach($ngstates as $ngstate)
                 <div class="item" data-value="{{$ngstate->id}}">{{$ngstate->name}}</div>
                @endforeach
              </div>
            </div>
          </div>
          <div class="three wide field" id="field-lga">
            <label>State Local Govt Area.</label>
            <div class="ui fluid search selection dropdown" id="wrap-slgas">
              <input type="hidden" name="lga_id" value="{{old('lga_id')}}">
              <i class="dropdown icon"></i>
              <div class="default text">State LGA</div>
              <div class="menu" id="state-lga">
                  @if(!empty(old('state_id')))
                    @foreach(getStateLGAs(old('state_id')) as $ngstateLGA)
                     <div class="item" data-value="{{$ngstateLGA->id}}">{{$ngstateLGA->name}}</div>
                    @endforeach
                  @else
                     <div class="item" data-value="">Select State LGA</div>
                  @endif
              </div>
            </div>
          </div>
          <div class="three wide field">
            <label>Blood Group</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="blood_group" value="{{old('blood_group')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Blood Group</div>
              <div class="menu">
                 <div class="item" data-value="O+">O+</div>
                 <div class="item" data-value="O-">O-</div>
                 <div class="item" data-value="A+">A+</div>
                 <div class="item" data-value="A-">A-</div>
                 <div class="item" data-value="B+">B+</div>
                 <div class="item" data-value="B-">B-</div>
                 <div class="item" data-value="AB+">AB+</div>
                 <div class="item" data-value="AB-">AB-</div>
                 <div class="item" data-value="Unavailable">Unavailable</div>
              </div>
            </div>
          </div>

        </div>
      </div>

      <div class="field">
        <div class="fields">
          <div class="four wide field">
           <label>Religion</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="religion" value="{{old('religion')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Religion</div>
              <div class="menu">
                 <div class="item" data-value="Christian">Christian</div>
                 <div class="item" data-value="Muslim">Muslim</div>
                 <div class="item" data-value="Traditional">Traditional</div>
              </div>
            </div>
          </div>

          <div class="four wide field">
            <label>Student's Phone Number</label>
              <input type="text" name="phone" value="{{old('phone')}}" placeholder="Student's Phone Number">
          </div>

          <div class="four wide field">
          <label>Student's Password</label>
            <input type="password" name="password" placeholder="Student's Password">
          </div>
          <div class="four wide field">
            <label>Student's Confirm Password</label>
            <input type="password" name="password_confirmation" placeholder="Student's Confirm Password">
          </div>
        </div>
      </div>
      <h4 class="ui dividing header">Parent or Guardian Information</h4>
      <div class="field">
        <div class="fields">
          <div class="six wide field">
          <label>Parent or Guardian Fullname</label>
            <input type="text" name="parent_fullname" value="{{old('parent_fullname')}}" placeholder="Parent or Guardian Fullname">
          </div>
          <div class="ten wide field">
            <label>Parent or Guardian Contact Address</label>
            <input type="text" name="parent_address" value="{{old('parent_address')}}" placeholder="Parent or Guardian Contact Address">
          </div>
        </div>
      </div>
      <div class="field">
        <div class="fields">
          <div class="four wide field">
          <label>Parent or Guardian Email</label>
            <input type="email" name="parent_email" value="{{old('parent_email')}}" placeholder="Parent or Guardian Email">
          </div>
          <div class="four wide field">
            <label>Parent or Guardian Phone Number</label>
            <input type="text" name="parent_phone" value="{{old('parent_phone')}}" placeholder="Parent or Guardian Phone Number">
          </div>
        </div>
      </div>

      <div class="field">
        <h4 class="ui dividing header">Student Academic Information</h4>
        <div class="four fields">
          <div class="field">
            <label>Session</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="session" value="{{old('session')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Session</div>
              <div class="menu">
                @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
                 <div class="item" data-value="{{$i}}">{{$i}}/{{$i+1}}</div>
                @endfor
              </div>
            </div>
          </div>
          

          <div class="field">
            <label>Term</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="term" value="{{old('term')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Term</div>
              <div class="menu">
                 <div class="item" data-value="First"> First Term </div>
                 <div class="item" data-value="Second"> Second Term </div>
                 <div class="item" data-value="Third"> Third Term </div>
              </div>
            </div>
          </div>
          
          <div class="field">
            <label>Class</label>
            <div class="ui fluid search selection dropdown" id="classes-dropdown">
              <input type="hidden" name="class_id" value="{{old('class_id')}}" data-href="{{url('/do-ajax/class')}}" >
              <i class="dropdown icon"></i>
              <div class="default text">Class</div>
              <div class="menu">
                @foreach($classes as $class)
                 <div class="item" data-value="{{$class->id}}">{{$class->class_name}}</div>
                @endforeach
              </div>
            </div>
          </div>

          <div class="field" id="field-arms">
            <label>Class Arm</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="class_arm_id" value="{{old('class_arm_id')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Class Arm</div>
              <div class="menu" id="class-arms">
                @if(!empty(old('class_id')))
                    @foreach(getClassArms(old('class_id')) as $class_arm)
                     <div class="item" data-value="{{$class_arm->id}}">{{$class_arm->class_arm}}</div>
                    @endforeach
                  @else
                     <div class="item" data-value="">Select Class Arm</div>
                  @endif
                
              </div>
            </div>
          </div>


        </div>
      </div>
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Register Student</button>
      
  </form>
</section>
<div class="jtr"></div>
@endsection