@extends('layouts.main')
@section('content')
	<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
		@include('partial.error')
		<form class="ui form" action="" method="post" enctype="multipart/form-data">
			<input type="hidden" name="_token" value="{{csrf_token()}}">
		  <h2 class="ui dividing header">Batch Student Registration</h2>
		  <div class="four fields">
	      <div class="field">
	        <label>Session</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="session" value="{{old('session')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Session</div>
	          <div class="menu">
	            @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
	             <div class="item" data-value="{{$i}}">{{$i}}/{{$i+1}}</div>
	            @endfor
	          </div>
	        </div>
	      </div>

	      <div class="field">
	        <label>Term</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="term" value="{{old('term')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Term</div>
	          <div class="menu">
	             <div class="item" data-value="First"> First Term </div>
	             <div class="item" data-value="Second"> Second Term </div>
	             <div class="item" data-value="Third"> Third Term </div>
	          </div>
	        </div>
	      </div>
	      
	      <div class="field">
	        <label>Class</label>
	        <div class="ui fluid search selection dropdown" id="classes-dropdown">
	          <input type="hidden" name="class_id" value="{{old('class_id')}}" data-href="{{url('/do-ajax/class')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Class</div>
	          <div class="menu">
	            @foreach($classes as $class)
	             <div class="item" data-value="{{$class->id}}">{{$class->class_name}}</div>
	            @endforeach
	          </div>
	        </div>
	      </div>

	      <div class="field" id="field-arms">
	        <label>Class Arm</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="class_arm_id" value="{{old('class_arm_id')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Class Arm</div>
	          <div class="menu" id="class-arms">
	            @if(!empty(old('class_id')))
	                @foreach(getClassArms(old('class_id')) as $class_arm)
	                 <div class="item" data-value="{{$class_arm->id}}">{{$class_arm->class_arm}}</div>
	                @endforeach
	              @else
	                 <div class="item" data-value="">Select Class Arm</div>
	              @endif
	            
	          </div>
	        </div>
	      </div>

	       <!-- <div class="field">
            <label>Student House</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="house_id" value="{{old('house_id')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Student House</div>
              <div class="menu">
                @forelse($school_houses as $school_house)
                 <div class="item" data-value="{{$school_house->id}}">{{$school_house->name}}</div>
                @empty
                  <div class="item">School house has not been created</div>
                @endforelse
              </div>
            </div>
          </div> -->


	    </div>
		  <div class="fields">
		      <div class="six wide field">
		      	<label>File Upload</label>
		      	<div class="ui right action input">
				  <input type="text" class="pseudo-batch-file-name" name="pseudo_batch_file_name" >
				  <button type="button" class="ui orange labeled icon button pseudo-batch-file">
				    <i class="file excel outline icon"></i>
				    Upload Excel File
				  </button>
				</div>
        		<input type="file" name="batch_file" id="batch_file" class="batch-file" style="display: none">
		      </div>
		  </div>
		  <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;-">Batch Register Students</button>
		</form>
	</section>
@endsection