@extends('layouts.main')
@section('content')
<br>
<section class="ui raised segment" style="max-width: 1024px; margin: 20px auto;">
	<h2 class="ui horizontal divider cap header" style="color:#dc4900;">
	  School Statistics <i class="icon dashboard"></i>
	</h2>
	<div class="ui stackable equal height stackable grid">
	    <div class="four wide column">
	  		<div class="ui special cards">
			  <div class="card">
			    <div class="image" style="padding: 5px;">
			      <img src="{{url_public('/images/students-icon.png')}}">
			    </div>
			    <div class="content">
			      <a class="header">Students</a>
			      <div class="meta">
			        <span class="date">Students</span>
			      </div>
			    </div>
			    <div class="extra content">
			      <a>
			        <i class="users icon"></i>
			        {{App\Student::where('school_id', $school->id)->get()->count()}} Students
			      </a>
			    </div>
			  </div>
		    </div>
		</div>


	    <div class="four wide column">
	  		<div class="ui special cards">
			  <div class="card">
			    <div class="image" style="padding: 5px;">
			      <img src="{{url_public('/images/teachers-icon.png')}}">
			    </div>
			    <div class="content">
			      <a class="header">Teachers</a>
			      <div class="meta">
			        <span class="date">teachers</span>
			      </div>
			    </div>
			    <div class="extra content">
			      <a>
			        <i class="users icon"></i>
			        {{App\Teacher::where('school_id', $school->id)->get()->count()}} Teachers
			      </a>
			    </div>
			  </div>
		    </div>
		</div>



	    <div class="eight wide column">
	  		<div class="ui special cards ext">
			  <div class="card">
			  	<h4 style="margin: 8px;">Estimations</h4>
			    <div class="content">
			    	<div class="ui middle aligned divided list">
                        <div class="item">
                            Students in LGA ({{App\OndoLGA::find($school->lga_id)->name}})
                            <span class="content">
                            {{App\Student::where('school_id', $school->id)->where('lga_id', $school->lga_id)->get()->count()}} Students
                            </span>
                        </div>
                        <div class="item">
                            Male students
                            <span class="content">
                            {{App\Student::where('school_id', $school->id)->where('gender', 'Male')->get()->count()}} Students
                            </span>
                        </div>
                        <div class="item">
                            Female students
                            <span class="content">
                            {{App\Student::where('school_id', $school->id)->where('gender', 'Female')->get()->count()}} Students
                            </span>
                        </div>
					</div>
			    </div>
			  </div>
		    </div>
		</div>
	</div>
</section>
<style>
.ext{
    width: 100% !important;
}
.ext .card{
    width: 100% !important;
}
.ext .card .item{
    text-align: left;
    padding: 13px;
}
.ext .card .content{
    text-align: right;
    float: right;
}
</style>
@endsection