@extends('layouts.main')
@section('content')

<section class="ui raised segment" style="max-width: 1024px; margin: 20px auto;">
		@include('partial.error')
		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  <i class="student icon"></i>
		  Edit School Infomation
		</h2>

		<form class="ui form" action="{{route('admin.edit.school.info')}}" method="post">
		{{csrf_field()}}
		<div>
			<label>School Name</label>
			<p>{{$school->name}}</p>
		</div>
		<div class="field">
              <label>School Logo</label>
              <div class="image-handler" style="max-width:280px;">
                <img src="{{url_public($school->logo)}}" class="ui fluid image">
              </div>
              <br>
              <div class="ui right action input">
              <input type="text" class="pseudo-batch-file-name" name="pseudo_batch_file_name" >
                <button type="button" class="ui orange labeled icon button pseudo-batch-file">
                  Choose Picture
                </button>
              </div>
              <input type="file" name="logo" id="batch_file" class="batch-file fileUpload" style="display: none">
          </div>

          <div class="field">
              <label>School Address</label>
              <textarea name="address" rows="3">{!! !empty(old('address')) ? old('address') : $school->address !!}</textarea>
          </div>
		</form>
</section>

@endsection