@extends('layouts.main')
@section('content')

<section class="ui raised segment" style="max-width: 1024px; margin: 20px auto;">
		@include('partial.error')
		<form class="ui form" action="{{route('admin.view.search.school.houses')}}" method="post" enctype="multipart/form-data">
			<input type="hidden" name="_token" value="{{csrf_token()}}">
		  <h2 class="ui dividing header">Search Class</h2>
		  <div class="two fields">
	      
	      <div class="field">
	          <label>School Houses</label>
	          <div class="ui fluid search selection dropdown">
	            <input type="hidden" name="house_id" value="{{old('house_id')}}">
	            <i class="dropdown icon"></i>
	            <div class="default text">Class</div>
	            <div class="menu">
	              @foreach($all_school_houses as $school_house)
	               <div class="item" data-value="{{$school_house->id}}">{{$school_house->name}}</div>
	              @endforeach
	            </div>
	          </div>
	        </div>
		    
	      <div class="field">
	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View School House</button>
	      </div>

	    </div>
		  
		</form>
		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  View School House Information
		</h2>
		<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">S/N</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">School House</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">House Master</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Students Assign to House</div>
		    </th>
		    <th colspan="2">
		    	<div class="ui ribbon label">Actions on school House</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  @if($school_houses->count() > 0)
			@php $page = (isset($_GET['page'])) ? ((int)$_GET['page'] - 1) : 0; $counter = $page * $school_houses->perPage() @endphp
		  	@foreach($school_houses as $school_house)
		    <tr>
		      <td>{{++$counter}}</td>
		      <td>{{$school_house->name}}</td>
		      <td>
		      	<div class="ui middle aligned divided list">
		      	
	            @if(count(getStudentHouseMasterBySchoolID($school_house->id)) > 0)
	            @foreach(getStudentHouseMasterBySchoolID($school_house->id) as $teacher)
	            <div class="item">
	              <div class="content">
	                <p class="header">{{$teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename}}</p>
	              </div>
	            </div>
	            @endforeach
	            @else
	            <div class="ui icon negative message">
	              <div class="item">
	                  <div class="content">
	                    <p class="header">No house master has been assigned to this house</p>
	                  </div>
	              </div>
	            </div>
	            @endif

		      	</div>
		      </td>
		      <td>
		      	<div class="ui middle aligned divided list">
		      	@forelse($school_house->teachers as $teacher)
		      	<div class="item">
				    <div class="content">
				      <p class="header">{{$teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename}}</p>
				    </div>
				</div>
				@empty
				<div class="ui icon negative message">
				  <div class="content">
				    <div class="header">
				    Sorry, No Record can be found.
				  	</div>
				  </div>
				 </div>
		      	@endforelse
		      	</div>
		      </td>
		      <td class="std-view">
		      @if(auth('admin')->user()->can('edit-school-house'))
			      <button class="ui labeled blue icon button" data-std-id="{{$school_house->id}}" data-href="{{route('admin.edit.school.house', ['id' => $school_house->id])}}">
				  <i class="edit icon"></i>
				  Edit
				</button>
				@endif
			  </td>
		      <td class="std-view">
		      @if(auth('admin')->user()->can('delete-school-house'))
				<button class="ui labeled negative icon button" data-std-id="{{$school_house->id}}" data-href="{{route('admin.delete.school.house', ['id' => $school_house->id])}}">
				  <i class="trash icon"></i>
				  Delete
				</button>
				@endif
		      </td>
		    </tr>
		   @endforeach
		    @else
			<tr>
				<th colspan="5">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		  <tfoot>
		    <tr><th colspan="4">
		      @include('pagination.default', ['paginator' => $school_houses])
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="{{csrf_token()}}">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
@endsection