@extends('layouts.main')
@section('content')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')
<form class="ui form" action="" method="post">
  <h2 class="ui dividing header">Edit  School House</h2>
  <div class="field">
    <input type="hidden" value="{{csrf_token()}}" name="_token" value="{{old('_token')}}">
    <input type="hidden" value="put"  name="_method" >
    
    <div class="three fields">
      <div class="field">
      <label>School House</label>
        <input type="text" name="school_house" @if(!empty(old('school_house'))) value="{{old('school_house')}}" @else value="{{$school_house->name}}" @endif placeholder="School House color">
      </div>

      <div class="field">
        <label>Assign Teachers</label>
         <select class="ui dropdown" name="teacher" >
            <option>Select teacher</option>
             @foreach($all_teachers as $teacher)
              <option  value="{{$teacher->id}}" 
              @if(!empty($house_master) && $teacher->id == $house_master->id)
                  selected="selected"
              @endif
              >{{$teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename}}</option>
             @endforeach
         </select>
      </div>

      <div class="field">
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white; margin-top:22.5px;">Update School House</button>
      </div>
    </div>
    
  </div>
</form>
<h2 class="ui dividing header">Available School House</h2>
@if($all_school_houses->count() > 0)
  <div class="ui tag labels">
  @foreach($all_school_houses as $school_house)
  <a class="ui {{strtolower($school_house->name)}} label">
    {{$school_house->name}}
  </a>

  @endforeach
</div>
@else
<div class="ui icon negative message">
  <i class="info circle icon"></i>
  <div class="content">
    <div class="header">
    Sorry, No Record can be found.
    </div>
  </div>
  </div>
@endif
</section>
<div class="jtr"></div>
@endsection