@extends('layouts.main')
@section('content')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')
<form class="ui form" action="{{route('admin.store.school.houses')}}" method="post">
  <h2 class="ui dividing header">School House Registration</h2>
  <div class="field">
    <input type="hidden" value="{{csrf_token()}}" name="_token" value="{{old('_token')}}">
    
    <div class="two fields">
      <div class="field">
      <label>School House</label>
        <input type="text" name="school_house" value="{{old('school_house')}}" placeholder="School House color">
      </div>
      <div class="field">
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white; margin-top:22.5px;">Register School House</button>
      </div>
    </div>
  </div>
</form>
<h2 class="ui dividing header">Available School House</h2>
@if($all_school_houses->count() > 0)
  <div class="ui tag labels">
  @foreach($all_school_houses as $school_house)
  <a class="ui {{strtolower($school_house->name)}} label">
    {{$school_house->name}}
  </a>

  @endforeach
</div>
@else
<div class="ui icon negative message">
  <i class="info circle icon"></i>
  <div class="content">
    <div class="header">
    Sorry, No Record can be found.
    </div>
  </div>
  </div>
@endif
</section>
<div class="jtr"></div>
@endsection