@extends('layouts.main')

@section('content')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">

		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  <i class="student icon"></i>
			Process Promotion Stamp On Result
		</h2>
		@include('partial.error')
	  <form action="{{route($route)}}" method="post" class="ui form">
	  	<input type="hidden" name="_token" value="{{csrf_token()}}">
	  	<input type="hidden" name="session" value="{{!empty(old('session')) ? old('session') : $session}}">
	  	<input type="hidden" name="class_id" value="{{!empty(old('class_id')) ? old('class_id') : $class_id}}">
	  	<input type="hidden" name="classarm_id" value="{{!empty(old('classarm_id')) ? old('classarm_id') : $classarm_id}}">
	  	<input type="hidden" name="term" value="{{!empty(old('term')) ? old('term') : $term}}">



        <div class="form-group">
            <label class="col-md-3 control-label">Choose Stamp Type</label>
            <div class="col-md-5">
                <div class="field">
                <select name="stamp_type" required class="ui fluid search dropdown">
                    <option value="">Select Session</option>
                    <option value="Promoted">Promoted</option>
                    <option value="Repeated">Repeated</option>
                    <option value="Withdraw">Withdraw</option>
                </select>
                </div>
            </div>
        </div>

		<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">Student's Fullname</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Registration Number</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Promotion Status</div>
		    </th>
		    <th >
		    	<div class="ui ribbon label">Select Students</div>
		    	<div class="ui toggle checkbox check-all">
					<input type="checkbox" class="">
					<label>Select All</label>
				</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  @if(count($classarm_students) > 0)
		  	@foreach($classarm_students as $student)
		  	@php
		  		$promotion = getStudentResultPromotion($student->id, $classarm_id, $class_id, $term, $session);
		  	@endphp
		    <tr>
		      <td>{{$student->surname.' '.$student->firstname.' '.$student->middlename}}</td>
		      <td>{{$student->regnum}}</td>
		      <td>		      
		  		@if($promotion == 2)
		  		Promoted
				@elseif($promotion == 3)
				Repeat
				@elseif($promotion == 4)
				Withdraw
				@endif		  	
		      </td>
		      <td class="std-view">
			     <div class="ui toggle checkbox studentID">
					<input type="checkbox" name="student_id[]" value="{{$student->id}}"><label></label>
				</div>
			  </td>
		    </tr>
		   @endforeach
		    @else
			<tr>
				<th colspan="4">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		</table>
        
			<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Submit</button>
	</form>
	</section>
	
@endsection