@extends('layouts.main')
@section('content')

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')
    <form class="ui form" action="" method="POST">
    	{{csrf_field()}}
      <h2 class="ui dividing header">Quick Student Edit</h2>
      <div class="field">
        <input type="hidden" name="id" value="{{$student->id}}">
        <input type="hidden" value="{{csrf_token()}}" name="_token">
        <label>Name</label>
        <div class="three fields">
          <div class="field">
            <input type="text" name="surname" @if(!empty(old('surname')))
              value="{{old('surname')}}"
            @else
              value="{{$student->surname}}"
            @endif placeholder="Surname">
          </div>
          <div class="field">
            <input type="text" name="firstname" @if(!empty(old('firstname')))
              value="{{old('firstname')}}"
            @else
              value="{{$student->firstname}}"
            @endif placeholder="First Name">
          </div>
          <div class="field">
            <input type="text" name="middlename" @if(!empty(old('middlename')))
              value="{{old('middlename')}}"
            @else
              value="{{$student->middlename}}"
            @endif placeholder="Other Name">
          </div>
        </div>
      </div>

       <div class="field">
        <div class="four fields">
          <div class="ui calendar field" id="example2">
            <label>Date of Birth</label>
            <div class="ui input left icon">
              <i class="calendar icon"></i>
              <input type="text" placeholder="Date of Birth" name="dob"   @if(!empty(old('dob')))
                value="{{old('dob')}}"
              @else
                value="{{$student->dob}}"
              @endif>
            </div>
          </div>
          <div class="field">
            <label>Gender</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="gender"    @if(!empty(old('gender')))
                  value="{{old('gender')}}"
                @else
                  value="{{$student->gender}}"
                @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Gender</div>
              <div class="menu">
                 <div class="item" data-value="Male"><i class="male icon"></i>Male</div>
                 <div class="item" data-value="Female"><i class="female icon"></i>Female</div>
              </div>
            </div>
          </div>
          <div class="field">
            <label>Country</label>
            <div class="ui fluid search selection dropdown">
              <input type="hidden" name="country"     @if(!empty(old('country')))
                  value="{{old('country')}}"
                @else
                  value="{{$student->country}}"
                @endif>
              <i class="dropdown icon"></i>
              <div class="default text">Country</div>
              <div class="menu">
                 <div class="item" data-value="Nigeria"><i class="flag ng"></i>Nigeria</div>
                 <div class="item" data-value="Other">Others</div>
              </div>
            </div>
          </div>

          <div class="field">
            <label>Student's Phone Number</label>
              <input type="text" name="phone"   @if(!empty(old('phone')))
                value="{{old('phone')}}"
              @else
                value="{{$student->phone}}"
              @endif placeholder="Student's Phone Number">
          </div>
      </div>
        <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Update Student</button>
  </form>
</section>
<div class="jtr"></div>
@endsection