@extends('layouts.main')
@section('content')
	<section class="ui stackable grid raised segment" style="margin: 20px auto; max-width: 800px" id="result-view">

  @include('partial.error')
<div class="sixteen wide column">
	<form action="{{route('admin.update.student.practical.attitude')}}" method="post" class="ui form">
  <h2 class="ui dividing header">Edit Student Character Development and Practical Development</h2>
	<input type="hidden" name="_token" value="{{csrf_token()}}">
	<input type="hidden" name="_method" value="put">
	<input type="hidden" name="session" value="{{$session}}">
	<input type="hidden" name="class_id" value="{{$class_id}}">
	<input type="hidden" name="classarm_id" value="{{$classarm_id}}">
	<input type="hidden" name="term" value="{{$term}}">
	<input type="hidden" name="student_id" value="{{$id}}">
    <table class="ui unstackable celled table">
      <thead>
      	<tr>
      		<th colspan="2">{{getStudentFullnameByStudentID($id).'\'s Character Development'}}</th>
      	</tr>
      </thead>
      <tbody>
        <tr>
          <td>Attentive in Class</td>
          <td>
            @if(!empty(old('attentive_class')))
              {!!characterPracticalSkill('attentive_class', old('attentive_class'))!!}
            @else
              {!!characterPracticalSkill('attentive_class',$student_character_attitude[0]->attentive_class)!!}
            @endif
          </td>
        </tr>
        <tr>
          <td>Neatness</td>
          <td>
            @if(!empty(old('neatness')))
              {!!characterPracticalSkill('neatness', old('neatness'))!!}
            @else
              {!!characterPracticalSkill('neatness',$student_character_attitude[0]->neatness)!!}
            @endif
          </td>
        </tr>
        <tr>
          <td>Self Control</td>
          <td>
            @if(!empty(old('self_control')))
              {!!characterPracticalSkill('self_control', old('self_control'))!!}
            @else
              {!!characterPracticalSkill('self_control',$student_character_attitude[0]->self_control)!!}
            @endif
          </td>
        </tr>
        <tr>
          <td>Punctuality</td>
          <td>
            @if(!empty(old('punctuality')))
              {!!characterPracticalSkill('punctuality', old('punctuality'))!!}
            @else
              {!!characterPracticalSkill('punctuality',$student_character_attitude[0]->punctuality)!!}
            @endif
          </td>
        </tr>
        <tr>
          <td>Politeness</td>
          <td>
            @if(!empty(old('politeness')))
              {!!characterPracticalSkill('politeness', old('politeness'))!!}
            @else
              {!!characterPracticalSkill('politeness',$student_character_attitude[0]->politeness)!!}
            @endif
          </td>
        </tr>
        <tr>
          <td>Relationship with Others</td>
          <td>
            @if(!empty(old('relationship_others')))
              {!!characterPracticalSkill('relationship_others', old('relationship_others'))!!}
            @else
              {!!characterPracticalSkill('relationship_others',$student_character_attitude[0]->relationship_others)!!}
            @endif
          </td>
        </tr>
      </tbody>
      <thead>
        <tr>
          <th colspan="2">{{getStudentFullnameByStudentID($id).'\'s Practical Skill'}}</th>
        </tr>
      </thead>
      <tbody>
      <tr>
          <td>Hand Writing</td>
          <td>
            @if(!empty(old('hand_writing')))
              {!!characterPracticalSkill('hand_writing', old('hand_writing'))!!}
            @else
              {!!characterPracticalSkill('hand_writing',$student_practical_skills[0]->hand_writing)!!}
            @endif
          </td>
        </tr>
        <tr>
          <td>Music</td>
          <td>
            @if(!empty(old('music')))
              {!!characterPracticalSkill('music', old('music'))!!}
            @else
              {!!characterPracticalSkill('music',$student_practical_skills[0]->music)!!}
            @endif
        </tr>
        <tr>
          <td>Drama</td>
          <td>
            @if(!empty(old('drama')))
              {!!characterPracticalSkill('drama', old('drama'))!!}
            @else
              {!!characterPracticalSkill('drama',$student_practical_skills[0]->drama)!!}
            @endif
          </td>
        </tr>
        <tr>
          <td>Craft</td>
          <td>
            @if(!empty(old('craft')))
              {!!characterPracticalSkill('craft', old('craft'))!!}
            @else
              {!!characterPracticalSkill('craft',$student_practical_skills[0]->craft)!!}
            @endif
          </td>
        </tr>
        <tr>
          <td>Club Societies</td>
          <td>
            @if(!empty(old('club_societies')))
              {!!characterPracticalSkill('club_societies', old('club_societies'))!!}
            @else
              {!!characterPracticalSkill('club_societies',$student_practical_skills[0]->club_societies)!!}
            @endif
          </td>
        </tr>
        <tr>
          <td>Hobbies</td>
          <td>
            @if(!empty(old('hobbies')))
              {!!characterPracticalSkill('hobbies', old('hobbies'))!!}
            @else
              {!!characterPracticalSkill('hobbies',$student_practical_skills[0]->hobbies)!!}
            @endif
          </td>
        </tr>
        <tr>
          <td>Sports</td>
          <td>
            @if(!empty(old('sports')))
              {!!characterPracticalSkill('sports', old('sports'))!!}
            @else
              {!!characterPracticalSkill('sports',$student_practical_skills[0]->sports)!!}
            @endif
          </td>
        </tr>
      	<tr>
      		<td colspan="2"><button type="submit" class="ui button fluid" style="background-color: #f75a0c; color:white;">Update Student Character Development and Practical Development</button></td>
      	</tr>
      </tbody>
    </table>
    </form>
</div>
</section>
<div class="jtr"></div>
@endsection