@extends('layouts.main')
@section('content')
<section class="ui stackable grid raised segment" style="margin: 20px auto; max-width: 1024px" id="result-view">
<div class="sixteen wide column">
    <table class="ui unstackable celled table">
      <thead>
        <tr>
          <th>Students' Name and Results</th>
        </tr>
      </thead>
      <tbody>

       @foreach($students_practical_character_info as $key => $student_results)
        <tr>
          <td>
            <table class="ui celled table" >
              <thead>
                <tr>
                    <th colspan="4">{{getStudentFullnameByStudentID($key)}}</th>
                    <th colspan="3">{{getRegNumByStudentID($key)}}</th>
                </tr>
                <tr>
                    <th colspan="7">Practical Skills</th>
                </tr>
              </thead>
              <tbody> 
                <tr>
              @if((count($student_results['practical_skill']['data']) > 0) && (count($student_results['characters']['data']) > 0))
                  @foreach($student_results['practical_skill']['data'] as  $practical_skill)
                    <td>
                       <table class="inner-table">
                         <tr><td>Hand Writing</td></tr>
                         <tr><td>{{$practical_skill->hand_writing}}</td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Music</td></tr>
                         <tr><td>{{$practical_skill->music}}</td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Drama</td></tr>
                         <tr><td>{{$practical_skill->drama}}</td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Craft</td></tr>
                         <tr><td>{{$practical_skill->craft}}</td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Club Societies</td></tr>
                         <tr><td>{{$practical_skill->club_societies}}</td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Hobbies</td></tr>
                         <tr><td>{{$practical_skill->hobbies}}</td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Sports</td></tr>
                         <tr><td>{{$practical_skill->sports}}</td></tr>
                       </table>
                    </td>
                  @endforeach
                </tr>
              </tbody>
              <thead>
                <tr>
                    <th colspan="5">Character Development</th>
                    <th colspan="2">ACTIONS</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  @foreach($student_results['characters']['data'] as  $characters)
                    <td>
                       <table class="inner-table">
                         <tr><td>Attentive Class</td></tr>
                         <tr><td>{{$characters->attentive_class}}</td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Neatness</td></tr>
                         <tr><td>{{$characters->neatness}}</td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Self Control</td></tr>
                         <tr><td>{{$characters->self_control}}</td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Punctuality</td></tr>
                         <tr><td>{{$characters->punctuality}}</td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Politeness</td></tr>
                         <tr><td>{{$characters->politeness}}</td></tr>
                       </table>
                    </td>
                    <td>
                       <table class="inner-table">
                         <tr><td>Realationship with Others</td></tr>
                         <tr><td>{{$characters->relationship_others}}</td></tr>
                       </table>
                    </td>
                  @endforeach
                    <td class="std-view"> 
                    @if(auth('admin')->user()->can('edit-student-remarks'))
                      <button class="ui labeled blue icon button" data-std-id="{{$key}}" data-href="{{route('admin.edit.student.practical.attitude', ['id' => $key, 'session' => $session, 'term' => $term, 'class_id' => $class_id, 'classarm_id' => $classarm_id_get])}}" data-item="{{getStudentFullnameByStudentID($key).'\'s Practical Skills and Character Development'}}">
                          <i class="edit icon"></i> Edit
                      </button>
                      <hr>
                      @endif
                      @if(auth('admin')->user()->can('delete-student-remarks'))
                      <button class="ui labeled negative icon button" data-std-id="{{$key}}" data-href="{{route('admin.delete.student.practical.attitude', ['id' => $key])}}" data-item="{{getStudentFullnameByStudentID($key).'\'s Practical Skills and Character Development'}}">
                          <i class="trash icon"></i> Delete
                      </button>
                      @endif
                    </td>

                @else
                    <td colspan="7">
                      <div class="ui icon negative message">
                            <div class="content">
                              <p class="header">Result has not been uploaded</p>
                            </div>
                      </div>
                    </td>
                @endif
                </tr>
              </tbody>
            </table>
          </td>
        </tr>
        @endforeach

      </tbody>
    </table>
</div>
</section>
<div class="jtr"></div>
<div class="ui modal" id="edit">
    <div class="header">Header</div>
    <div class="image content">
      <div class="description">

      </div>
    </div>
    <div class="actions">
      <div class="ui cancel button">Cancel</div>
      <a href="" class="ui approve blue button">Edit</a>
    </div>
  </div>

  <div class="ui modal" id="delete">
    <div class="header">Header</div>
    <div class="image content">
      <div class="description">

      </div>
    </div>
    <div class="actions">
      <div class="ui cancel button">Cancel</div>
      <form action="" method="post" style="display:inline-block;">
        <input type="hidden" name="_token" value="{{csrf_token()}}">
        <input type="hidden" name="_method" value="delete">
        <input type="hidden" name="session" value="{{$session}}">
        <input type="hidden" name="class_id" value="{{$class_id}}">
        <input type="hidden" name="classarm_id" value="{{$classarm_id_get}}">
        <input type="hidden" name="term" value="{{$term}}">
        <button type="submit" class="ui approve negative button">Delete</button>
      </form>
    </div>
  </div>
@endsection