@extends('layouts.main')
@section('content')
<section class="ui stackable grid raised segment" style="margin: 20px auto; max-width: 1024px">
<div class="sixteen wide column">
@include('partial.error')
</div>
	<div class="five wide column">
		<div class="ui divided list cart-summary">
			@foreach($inputs as $key => $input)
			<div class="item">  
				<div class="content">
					@if($key == 'class')
					<strong class="">{{strtoupper($key)}} : </strong> 
					<span class="mini meta">{{getClassNameByClassID($input)}}</span> 
					@elseif($key == 'class arm')
					<strong class="">{{strtoupper($key)}} : </strong> 
					<span class="mini meta">{{getClassArmNameByClassArmID($input)}}</span>
					@elseif($key == 'session') 
					<strong class="">{{strtoupper($key)}} : </strong> 
					<span class="mini meta">{{$input}}/{{($input+1)}}</span>
					@else
					<strong class="">{{strtoupper($key)}} : </strong> 
					<span class="mini meta">{{$input}}</span> 
					@endif
				</div> 
			</div> 
			@endforeach
		</div>

		<div class="ui icon info message">
		  <i class="file excel outline icon"></i>
		  <div class="content">
		    <div class="header">
		    	Download {{getClassNameByClassID($inputs['class']).' '.getClassArmNameByClassArmID($inputs['class arm'])}} Practical Skills and Character Development Format
		  	</div>
		  	<div class="description">
		  		<form action="{{route('admin.download.class.practical.character.format')}}" method="post">
		  			<input type="hidden" name="_token" value="{{csrf_token()}}">
		  			<input type="hidden" name="session" value="{{$inputs['session']}}">
		  			<input type="hidden" name="class_id" value="{{$inputs['class']}}">
		  			<input type="hidden" name="classarm_id" value="{{$inputs['class arm']}}">
		  			<input type="hidden" name="term" value="{{$inputs['term']}}">
		  			<button type="submit" class="fluid ui button" style="background-color: #f75a0c; color:white;">Download</button>
		  		</form>
		  	</div>
		  </div>
		</div>
	</div>
	<div class="eleven wide column">
		<h4 class="ui dividing header">Upload  Practical Skills and Character Development</h4>
		<div class="ui divided list">
		<div class="item"> 
		<form action="{{route('admin.upload.students.practical.character')}}" method="post" enctype="multipart/form-data" class="ui form">
					<input type="hidden" name="_token" value="{{csrf_token()}}">
					<input type="hidden" name="session" value="{{$inputs['session']}}">
		  			<input type="hidden" name="class_id" value="{{$inputs['class']}}">
		  			<input type="hidden" name="classarm_id" value="{{$inputs['class arm']}}">
		  			<input type="hidden" name="term" value="{{$inputs['term']}}">
					
			<div class="fields">
			  <!-- <div class="three wide field">
		       <label></label>
		      </div> -->

		      <div class="eight wide field">
			      	<div class="ui right action input">
					  <input type="text" class="pseudo-batch-file-name" name="pseudo_batch_file_name" >
					  <button type="button" class="ui orange labeled icon button pseudo-batch-file">
					    <i class="file excel outline icon"></i>
					    Choose Excel File
					  </button>
					</div>
	        		<input type="file" name="batch_file" id="batch_file" class="batch-file" style="display: none">
			   </div>
				
				<div class="five wide field">
			      <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Upload File</button>
			  	</div>
			</div>
		</form>
		</div>
	</div>
</section>
<div class="jtr"></div>
@endsection