@extends('layouts.main')
@section('content')   


<style>
.twelve {
  margin: 0 auto;
}
.ext{
    width: 100% !important;
}
.ext .card{
    width: 100% !important;
}
.form-group {
    margin-bottom: 20px;
}
.header {
  text-align: center;
}
</style> 

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')

  <h2 class="ui dividing header">{{$title}}</h2>

<div class="ui stackable equal height stackable grid">

    <div class="twelve wide column">

                        <form method="post" action="" class="form-horizontal global_form">
                                {{csrf_field()}}
                                <input type="hidden" name="school_id" value="{{auth('admin')->user()->school_id}}">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Payment For</label>
                                    <div class="col-md-5">
                                        <div class="field">
                                            <select name="item_id" required class="ui fluid search dropdown">
                                                <option value="">Choose Payment Item</option>
                                                  @foreach($payment_items as $payment_item)
                                                    @if($payment_item->id == 1)
                                                      <option value="{{$payment_item->id}}">{{$payment_item->item_name}} (N{{number_format($payment_item->cost)}})</option>
                                                    @endif
                                                  @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-md-3 control-label">Session</label>
                                    <div class="col-md-5">
                                        <div class="field">
                                        <select name="session" id="sessionInput" required class="ui fluid search dropdown">
                                            <option value="">Select Session</option>
                                            <?php
                                            for($i = 2010; $i <= (date('Y') + 1) ; $i++){
                                                $i_n = $i + 1;
                                                echo '<option value="'.$i.'">'.$i.'/'.$i_n.'</option>';
                                            }
                                            ?>
                                        </select>
                                        </div>
                                    </div>
                                </div>


                                <div class="form-group">
                                    <label class="col-md-3 control-label">Payment Channel</label>
                                    <div class="col-md-5">
                                        <div class="field">
                                        <select name="pay_channel" id="pay_channel" required class="ui fluid search dropdown">
                                            <option value="">Select Session</option>
                                            <option value="Payoutlet">Payoutlet</option>
                                            <option value="Webconnect">Webconnect</option>
                                            <option value="Bankit">Bankit</option>
                                        </select>
                                        </div>
                                    </div>
                                </div>


                                <div class="form-group">
                                    <label class="col-md-3 control-label">Select Students</label>
                                    <div class="col-md-9">
                                        <div class="multiple_select_holder" style="height: 50vh;overflow-y: auto;">
                                        <table class="ui compact celled definition table">
                                            <thead>
                                                <tr>
                                                <th></th>
                                                <th>Full Name</th>
                                                <th>Registration Number</th>
                                                </tr>
                                            </thead>
                                            <tbody id="studentsTable">
                                                
                                            </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <br>
                                <div class="form-group text-center m-t-30">
                                    <div class="col-md-4 col-xs-offset-4">
                                        <input type="submit" class="ui small blue button" name="form_submit" value="Save & Continue" />
                                    </div>
                                </div>
                            </form>

    </div>

</div>
  
</section>

<div class="jtr"></div>


<script>
$(document).ready(function(){
    input = $('#sessionInput');
    table = $('#studentsTable');
    input.on('change', function(){
        // throw ajax
        $('.multiple_select_holder .field.loading').remove();
        $('.multiple_select_holder').append('<div class="field loading" style="margin-left: 10px;margin-right: 2em;margin-top: 30px;"></div>');

        var token = "{{csrf_token()}}";
        var route = "{{route('admin.payment.online.get.students')}}";
        var school_id = "{{$school_id}}";
        var session = $(this).val();
        $.ajax({
            url: route,
            type: 'POST',
            data: {school_id: school_id, session: session, _token: token},
            success: function(response){
                table.html('')
                $.each(response,  function(index, value){
                    $item = '<tr>';
                    $item += '<td class="collapsing">';
                    $item += '<div class="ui fitted slider checkbox">';
                    $item += '<input type="checkbox"  name="student_id[]" value="'+value.id+'"> <label></label>';
                    $item += '</div>';
                    $item += '</td>';
                    $item += '<td>'+value.surname+' '+value.firstname+' '+value.middlename+'</td>';
                    $item += '<td>'+value.regnum+'</td>';
                    $item += '</tr>';

                    table.append($item);
                });
                $('.multiple_select_holder .field.loading').remove();
            },
            error: function(error){
                console.error(error);
            }
        });
    })
});
</script>

@endsection 