@extends('layouts.main')
@section('content')   


<style>
.twelve {
  margin: 0 auto;
}
.ext{
    width: 100% !important;
}
.ext .card{
    width: 100% !important;
}
.form-group {
    margin-bottom: 20px;
}
.header {
  text-align: center;
}
</style> 

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')

  <h2 class="ui dividing header">{{$title}}</h2>

<div class="ui stackable equal height stackable grid">

    <div class="twelve wide column">

                        <form method="post" action="" class="form-horizontal global_form">
                                {{csrf_field()}}
                                <input type="hidden" name="school_id" value="{{auth('admin')->user()->school_id}}">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Payment For (Item)</label>
                                    <div class="col-md-5">
                                        <div class="field">
                                            <select name="item_id" required class="ui fluid search dropdown">
                                                <option value="">Choose Payment Item</option>
                                                  @foreach($payment_items as $payment_item)
                                                    @if($payment_item->id == 1)
                                                      <option value="{{$payment_item->id}}">{{$payment_item->item_name}} (N{{number_format($payment_item->cost)}})</option>
                                                    @endif
                                                  @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-md-3 control-label">Class</label>
                                    <div class="col-md-5">
                                        <div class="field">
                                        <select name="class_id" id="classId" required class="ui fluid search dropdown">
                                            <option value="">Select Class</option>
                                              @foreach($classes as $class)
                                                  <option value="{{$class->id}}">{{$class->class_name}}</option>
                                              @endforeach
                                        </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-md-3 control-label">Session</label>
                                    <div class="col-md-5">
                                        <div class="field">
                                        <select name="session" id="sessionInput" required class="ui fluid search dropdown">
                                            <option value="">Select Session</option>
                                            <?php
                                            for($i = 2010; $i <= (date('Y') + 1) ; $i++){
                                                $i_n = $i + 1;
                                                echo '<option value="'.$i.'">'.$i.'/'.$i_n.'</option>';
                                            }
                                            ?>
                                        </select>
                                        </div>
                                    </div>
                                </div>


                                <div class="form-group">
                                    <label class="col-md-3 control-label">Select Students</label>
                                    <div class="col-md-9">
                                        <div id="multiple_select_holder" class="multiple_select_holder" style="height: 50px;overflow-y: auto;">
                                        <table class="ui compact celled definition table" id="global_datatable">
                                            <thead>
                                                <tr>
                                                <th></th>
                                                <th>Full Name</th>
                                                <th>Registration Number</th>
                                                </tr>
                                            </thead>
                                            <tbody id="studentsTable">
                                                
                                            </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>


                                <div class="form-group">
                                    <label class="col-md-3 control-label">Payment List (Selected Student)</label>
                                    <div class="col-md-9">
                                        <div id="multiple_selected_holder" class="multiple_selected_holder" style="height: 50px;overflow-y: auto;">
                                            <table class="ui compact celled definition table">
                                            <thead>
                                                <tr>
                                                <th></th>
                                                <th>Full Name</th>
                                                <th>Registration Number</th>
                                                <th>Class</th>
                                                </tr>
                                            </thead>
                                            <tbody id="SelectedStudentsTable">
                                                
                                            </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>


                                <br>
                                <br>
                                <div class="form-group text-center m-t-30">
                                    <div class="col-md-4 col-xs-offset-4">
                                        <input type="button" class="ui small blue button" id="form_submit" name="form_submit" value="Save & Continue" />
                                    </div>
                                </div>
                            </form>

    </div>

</div>
  
</section>

<div class="jtr"></div>


<script>
var site_url = "{{url('/admin')}}";
var token = "{{csrf_token()}}";
var ajax_loader = "{{url_public('/images/ajax-loader.gif')}}";
</script>

<script>
$(document).ready(function(){
    $("#pagewrap_ajax_box").hide();
//////// loadCartStudent //////

    var form_data = {
    _token : token
    };

    var $data_row;
    var data_row_count = 0;
    $('.multiple_selected_holder').append('<div class="field loading" style="margin-left: 10px;margin-right: 2em;margin-top: 30px;"></div>');

    $.ajax({
        url :   site_url+"/payment/load-cart-student",
        type :  "POST",
        data :  form_data,
        cache :     false
    })
    .done(function(response){
        $('#SelectedStudentsTable').html('');
        $.each(response,  function(index, value){
            $data_row = '<tr>';
            $data_row += '<td class="collapsing">';
            $data_row += '<div id="del_item_row'+value.id+'" class="del_item_row ui fitted">';
            $data_row += '<a href="javascript:void();">Remove from List</a>';
            $data_row += '<input type="hidden" value="'+value.id+'" name="studid_del_item_row'+value.id+'" id="studid_del_item_row'+value.id+'" /> ';  
            $data_row += '</div>';
            $data_row += '</td>';
            $data_row += '<td>'+value.surname+' '+value.firstname+' '+value.middlename+'</td>';
            $data_row += '<td>'+value.regnum+'</td>';
            $data_row += '<td>'+value.class_name+''+value.class_arm+'</td>';
            $data_row += '</tr>';

            $('#SelectedStudentsTable').append($data_row);
            if(value.regnum)
            data_row_count = data_row_count + 1;
        });
        
        $('.multiple_selected_holder .field.loading').remove();     
        if(data_row_count > 0){
            $("#multiple_selected_holder").css({"height" : "300px"}); 
        }
        else{
            $("#multiple_selected_holder").css({"height" : "100px"}); 
            $('#SelectedStudentsTable').html('<tr> <td colspan="3"> No student has been added to Payment List. </td> </tr>');
        }   
    })
    .fail(function(){               
        alert('Error encountered while loading Payment List. Pls try again shortly');   
    }); 

//////// loadCartStudent //////    
});


$("#form_submit").on('click', function() {
///// START: SUMIT CART /////

    var session = $("select[name=session]").val();
    var class_id = $("select[name=class_id]").val();
    var item_id = $("select[name=item_id]").val();

    if(session && class_id && item_id){

        var form_data = {
            session : session,
            class_id : class_id,
            item_id : item_id,
            _token : token
        }

        $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
        $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
        $("#pagewrap_ajax_box").show('slow');          
        $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
        window.oncontextmenu = function(){return false;}    // Disable right click  
        $("input").prop('disabled', true);                 // Disable form input
        $("select").prop('disabled', true);                    // Disable form input 

        $.ajax({
            url :   site_url+"/payment/set-data-bankit-ajax",
            type :  "POST",
            data :  form_data,
            dataType: "json",
            cache :     false
        })
        .done(function(resp){   
            window.oncontextmenu = function(){return true;}     // Enable right click
            $("#pagewrap_ajax_box").html('');                  
            $("#pagewrap_ajax_box").hide();                    
            $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
            $("input").prop('disabled', false);                    // Enable form input            
            $("select").prop('disabled', false);                   // Enable form input       

            if(resp.type === "error"){
                alert(resp.value);
            }
            else if(resp.type === "okay"){
                window.location.href = site_url+"/payment/set-gateway-data-bankit/"+resp.value; 
            }
            else{
                alert('Invalid callback response. Pls try again shortly'); 
            }

            })
        .fail(function(){
            window.oncontextmenu = function(){return true;}     // Enable right click
            $("#pagewrap_ajax_box").html('');                  
            $("#pagewrap_ajax_box").hide();                    
            $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
            $("input").prop('disabled', false);                    // Enable form input            
            $("select").prop('disabled', false);                   // Enable form input 

            alert('Error encountered while processing request. Pls try again shortly');  
        }); 
        
    }
    else{
        alert("No field must be left Blank.")
    }

///// END: SUMIT CART /////
});


$("#SelectedStudentsTable").on('click', ".del_item_row", function(e) {
///// START: REMOVE FROM CART /////

    e.preventDefault();
    var row_id = $(this).closest("div").attr("id");
    var student_field_id = '#studid_'+row_id;
    var student_id = $(student_field_id).val();

    var form_data = {
        student_id : student_id,
        _token : token
    }

    var form_data2 = {
        _token : token
    };

    $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
    $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
    $("#pagewrap_ajax_box").show('slow');          
    $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
    window.oncontextmenu = function(){return false;}    // Disable right click  
    $("input").prop('disabled', true);                 // Disable form input
    $("select").prop('disabled', true);                    // Disable form input 
        
    $.ajax({
        url :   site_url+"/payment/delete-student-cart",
        type :  "POST",
        data :  form_data,
        dataType: "json",
        cache :     false
    })
    .done(function(resp){   
        window.oncontextmenu = function(){return true;}     // Enable right click
        $("#pagewrap_ajax_box").html('');                  
        $("#pagewrap_ajax_box").hide();                    
        $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
        $("input").prop('disabled', false);                    // Enable form input            
        $("select").prop('disabled', false);                   // Enable form input   

        alert(resp.value);

        //////// loadCartStudent //////

            var $data_row;
            var data_row_count = 0;
            $('.multiple_selected_holder').append('<div class="field loading" style="margin-left: 10px;margin-right: 2em;margin-top: 30px;"></div>');

            $.ajax({
                url :   site_url+"/payment/load-cart-student",
                type :  "POST",
                data :  form_data2,
                cache :     false
            })
            .done(function(response){
                $('#SelectedStudentsTable').html('');
                $.each(response,  function(index, value){
                    $data_row = '<tr>';
                    $data_row += '<td class="collapsing">';
                    $data_row += '<div id="del_item_row'+value.id+'" class="del_item_row ui fitted">';
                    $data_row += '<a href="javascript:void();">Remove from List</a>';
                    $data_row += '<input type="hidden" value="'+value.id+'" name="studid_del_item_row'+value.id+'" id="studid_del_item_row'+value.id+'" /> ';  
                    $data_row += '</div>';
                    $data_row += '</td>';
                    $data_row += '<td>'+value.surname+' '+value.firstname+' '+value.middlename+'</td>';
                    $data_row += '<td>'+value.regnum+'</td>';
                    $data_row += '<td>'+value.class_name+''+value.class_arm+'</td>';
                    $data_row += '</tr>';

                    $('#SelectedStudentsTable').append($data_row);
                    if(value.regnum)
                    data_row_count = data_row_count + 1;
                });
                
                $('.multiple_selected_holder .field.loading').remove();     
                if(data_row_count > 0){
                    $("#multiple_selected_holder").css({"height" : "300px"}); 
                }
                else{
                    $("#multiple_selected_holder").css({"height" : "100px"}); 
                    $('#SelectedStudentsTable').html('<tr> <td colspan="3"> No student has been added to Payment List. </td> </tr>');
                }   
            })
            .fail(function(){     
                alert('Error encountered while loading Payment List. Pls try again shortly');   
            }); 

        //////// loadCartStudent //////  
    })
    .fail(function(){
        window.oncontextmenu = function(){return true;}     // Enable right click
        $("#pagewrap_ajax_box").html('');                  
        $("#pagewrap_ajax_box").hide();                    
        $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
        $("input").prop('disabled', false);                    // Enable form input            
        $("select").prop('disabled', false);                   // Enable form input 

        alert('Error encountered while loading Selected Students. Pls try again shortly');  
    }); 

///// END: REMOVE FROM CART /////
});


$("#studentsTable").on('click', ".item_row", function(e) {
///// START: ADD TO CART /////

    e.preventDefault();
    var row_id = $(this).closest("div").attr("id");
    var student_field_id = '#studid_'+row_id;
    var student_id = $(student_field_id).val();

    var class_id = $("select[name=class_id]").val();
    var session = $("select[name=session]").val();
    var token = "{{csrf_token()}}";
    var route = "{{route('admin.payment.online.get.students')}}";
    var school_id = "{{$school_id}}";

    var form_data = {
        student_id : student_id,
        _token : token
    };

    var form_data2 = {
        school_id : school_id,
        session : session,
        class_id : class_id,
        _token : token
    };

    var form_data3 = {
        _token : token
    };

    $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
    $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
    $("#pagewrap_ajax_box").show('slow');          
    $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
    window.oncontextmenu = function(){return false;}    // Disable right click  
    $("input").prop('disabled', true);                 // Disable form input
    $("select").prop('disabled', true);                    // Disable form input 

    $.ajax({
        url :   site_url+"/payment/add-student-to-cart",
        type :  "POST",
        data :  form_data,
        dataType: "json",
        cache :     false
    })
    .done(function(resp){
        window.oncontextmenu = function(){return true;}     // Enable right click
        $("#pagewrap_ajax_box").html('');                  
        $("#pagewrap_ajax_box").hide();                    
        $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
        $("input").prop('disabled', false);                    // Enable form input            
        $("select").prop('disabled', false);                   // Enable form input    

        $('.multiple_select_holder .field.loading').remove();
        $('.multiple_select_holder').append('<div class="field loading" style="margin-left: 10px;margin-right: 2em;margin-top: 30px;"></div>');

        var resp_count = 0; 
        var $item;

        alert(resp.value);   
        
        $.ajax({
                url:    site_url+"/payment/online-get-students",
                cache:  false,
                type :  "POST",
                data: form_data2,
                success:    function(response){
                        $('#studentsTable').html('');
                        $.each(response,  function(index, value){
                            $item = '<tr>';
                            $item += '<td class="collapsing">';
                            $item += '<div id="item_row'+value.id+'" class="item_row ui fitted">';
                            $item += '<a href="javascript:void();">Add to List</a>';
                            $item += '<input type="hidden" value="'+value.id+'" name="studid_item_row'+value.id+'" id="studid_item_row'+value.id+'" /> ';  
                            $item += '</div>';
                            $item += '</td>';
                            $item += '<td>'+value.surname+' '+value.firstname+' '+value.middlename+'</td>';
                            $item += '<td>'+value.regnum+'</td>';
                            $item += '</tr>';

                            $('#studentsTable').append($item);
                            if(value.regnum)
                            resp_count = resp_count + 1;
                        });
                     

                     $('.multiple_select_holder .field.loading').remove();  
                     if(resp_count > 0){
                        $("#multiple_select_holder").css({"height" : "300px"});   
                     }
                     else{
                        $("#multiple_select_holder").css({"height" : "100px"}); 
                        $('#studentsTable').html('<tr> <td colspan="3"> No student record was found in selected class. </td> </tr>');
                     }
                },
                error: function(error){
                    $('#studentsTable').html('<tr> <td colspan="3"> Unable to load data. </td> </tr>');
                }
            });

        //////// loadCartStudent //////

            var $data_row;
            var data_row_count = 0;
            $('.multiple_selected_holder').append('<div class="field loading" style="margin-left: 10px;margin-right: 2em;margin-top: 30px;"></div>');

            $.ajax({
                url :   site_url+"/payment/load-cart-student",
                type :  "POST",
                data :  form_data3,
                cache :     false
            })
            .done(function(response){
                $('#SelectedStudentsTable').html('');
                $.each(response,  function(index, value){
                    $data_row = '<tr>';
                    $data_row += '<td class="collapsing">';
                    $data_row += '<div id="del_item_row'+value.id+'" class="del_item_row ui fitted">';
                    $data_row += '<a href="javascript:void();">Remove from List</a>';
                    $data_row += '<input type="hidden" value="'+value.id+'" name="studid_del_item_row'+value.id+'" id="studid_del_item_row'+value.id+'" /> ';  
                    $data_row += '</div>';
                    $data_row += '</td>';
                    $data_row += '<td>'+value.surname+' '+value.firstname+' '+value.middlename+'</td>';
                    $data_row += '<td>'+value.regnum+'</td>';
                    $data_row += '<td>'+value.class_name+''+value.class_arm+'</td>';
                    $data_row += '</tr>';

                    $('#SelectedStudentsTable').append($data_row);
                    if(value.regnum)
                    data_row_count = data_row_count + 1;
                });
                
                $('.multiple_selected_holder .field.loading').remove();     
                if(data_row_count > 0){
                    $("#multiple_selected_holder").css({"height" : "300px"}); 
                }
                else{
                    $("#multiple_selected_holder").css({"height" : "100px"}); 
                    $('#SelectedStudentsTable').html('<tr> <td colspan="3"> No student has been added to Payment List. </td> </tr>');
                }   
            })
            .fail(function(){               
                alert('Error encountered while loading Payment List. Pls try again shortly');   
            }); 

        //////// loadCartStudent //////
    })
    .fail(function(){ 
        window.oncontextmenu = function(){return true;}     // Enable right click
        $("#pagewrap_ajax_box").html('');                  
        $("#pagewrap_ajax_box").hide();                    
        $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
        $("input").prop('disabled', false);                    // Enable form input            
        $("select").prop('disabled', false);                   // Enable form input      

        alert('Error encountered while processing request. Pls try again shortly'); 
    }); 

///// END: ADD TO CART /////
});

</script>

<script>
$(document).ready(function(){

    $('#sessionInput').on('change', function(){
        var class_id = $("select[name=class_id]").val();
        var session = $("select[name=session]").val();

        if(class_id){

            $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
            $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
            $("#pagewrap_ajax_box").show('slow');          
            $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
            window.oncontextmenu = function(){return false;}    // Disable right click  
            $("input").prop('disabled', true);                 // Disable form input
            $("select").prop('disabled', true);                    // Disable form input 


            $('.multiple_select_holder .field.loading').remove();
            $('.multiple_select_holder').append('<div class="field loading" style="margin-left: 10px;margin-right: 2em;margin-top: 30px;"></div>');

            var token = "{{csrf_token()}}";
            var route = "{{route('admin.payment.online.get.students')}}";
            var school_id = "{{$school_id}}";
            var resp_count = 0;
            var $item;

            $.ajax({
                url: route,
                type: 'POST',
                data: {school_id: school_id, session: session, class_id: class_id, _token: token},
                success: function(response){
                    window.oncontextmenu = function(){return true;}     // Enable right click
                    $("#pagewrap_ajax_box").html('');                  
                    $("#pagewrap_ajax_box").hide();                    
                    $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                    $("input").prop('disabled', false);                    // Enable form input            
                    $("select").prop('disabled', false);                   // Enable form input   

                    $('#studentsTable').html('');
                    $.each(response,  function(index, value){
                        $item = '<tr>';
                        $item += '<td class="collapsing">';
                        $item += '<div id="item_row'+value.id+'" class="item_row ui fitted">';
                        $item += '<a href="javascript:void();">Add to List</a>';
                        $item += '<input type="hidden" value="'+value.id+'" name="studid_item_row'+value.id+'" id="studid_item_row'+value.id+'" /> ';  
                        $item += '</div>';
                        $item += '</td>';
                        $item += '<td>'+value.surname+' '+value.firstname+' '+value.middlename+'</td>';
                        $item += '<td>'+value.regnum+'</td>';
                        $item += '</tr>';

                        $('#studentsTable').append($item);
                            if(value.regnum)
                            resp_count = resp_count + 1;
                    });

                    $('.multiple_select_holder .field.loading').remove();
                    if(resp_count > 0){
                        $("#multiple_select_holder").css({"height" : "300px"}); 
                    }
                    else{
                        $("#multiple_select_holder").css({"height" : "100px"}); 
                        $('#studentsTable').html('<tr> <td colspan="3"> No student record was found in selected class. </td> </tr>');
                    }
                },
                error: function(error){
                    window.oncontextmenu = function(){return true;}     // Enable right click
                    $("#pagewrap_ajax_box").html('');                  
                    $("#pagewrap_ajax_box").hide();                    
                    $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                    $("input").prop('disabled', false);                    // Enable form input            
                    $("select").prop('disabled', false);                   // Enable form input   
                    alert('Error encountered while processing request. Pls try again shortly');
                }
            });
        }//End if
    })


    $('#classId').on('change', function(){

        var session = $("select[name=session]").val();
        var class_id = $("select[name=class_id]").val();

        if(session){
            $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
            $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
            $("#pagewrap_ajax_box").show('slow');          
            $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
            window.oncontextmenu = function(){return false;}    // Disable right click  
            $("input").prop('disabled', true);                 // Disable form input
            $("select").prop('disabled', true);                    // Disable form input 

            $('.multiple_select_holder .field.loading').remove();
            $('.multiple_select_holder').append('<div class="field loading" style="margin-left: 10px;margin-right: 2em;margin-top: 30px;"></div>');

            var token = "{{csrf_token()}}";
            var route = "{{route('admin.payment.online.get.students')}}";
            var school_id = "{{$school_id}}";
            var resp_count = 0;
            var $item;

            $.ajax({
                url: route,
                type: 'POST',
                data: {school_id: school_id, session: session, class_id: class_id, _token: token},
                success: function(response){
                    window.oncontextmenu = function(){return true;}     // Enable right click
                    $("#pagewrap_ajax_box").html('');                  
                    $("#pagewrap_ajax_box").hide();                    
                    $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                    $("input").prop('disabled', false);                    // Enable form input            
                    $("select").prop('disabled', false);                   // Enable form input  

                    $('#studentsTable').html('');
                    $.each(response,  function(index, value){
                        $item = '<tr>';
                        $item += '<td class="collapsing">';
                        $item += '<div id="item_row'+value.id+'" class="item_row ui fitted">';
                        $item += '<a href="javascript:void();">Add to List</a>';
                        $item += '<input type="hidden" value="'+value.id+'" name="studid_item_row'+value.id+'" id="studid_item_row'+value.id+'" /> ';  
                        $item += '</div>';
                        $item += '</td>';
                        $item += '<td>'+value.surname+' '+value.firstname+' '+value.middlename+'</td>';
                        $item += '<td>'+value.regnum+'</td>';
                        $item += '</tr>';

                        $('#studentsTable').append($item);
                        if(value.regnum)
                        resp_count = resp_count + 1;
                    });

                    $('.multiple_select_holder .field.loading').remove();
                    if(resp_count > 0){
                        $("#multiple_select_holder").css({"height" : "300px"}); 
                    }
                    else{
                        $("#multiple_select_holder").css({"height" : "100px"}); 
                        $('#studentsTable').html('<tr> <td colspan="3"> No student record was found in selected class. </td> </tr>');
                    }
                },
                error: function(error){
                    window.oncontextmenu = function(){return true;}     // Enable right click
                    $("#pagewrap_ajax_box").html('');                  
                    $("#pagewrap_ajax_box").hide();                    
                    $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                    $("input").prop('disabled', false);                    // Enable form input            
                    $("select").prop('disabled', false);                   // Enable form input  

                    alert('Error encountered while processing request. Pls try again shortly');
                }
            });
        }//End if
    })

});
</script>

@endsection 