@extends('layouts.main')
@section('content') 
<section class="ui raised segment" style="max-width: 1150px; margin: 20px auto;">
<!-- HEADER
================================================== -->
<!-- CONTENT
================================================== -->
<div class="grid">
		<div class="shadowundertop"></div>
		<div class="row">
			<div class="c8">
                <h2 class="ui dividing header text_center"> <?php echo $school_data['name']; ?> </h2>
                <div class="ui grid">
                    <div class="four wide column">
                        <div class="ui vertical fluid tabular menu">
                        <a href="{{url('admin/payment/offline')}}" class="item @if(!isset($_GET['action']) || $_GET['action'] == '') active @endif">
                            Make payment
                        </a>
                        <a href="{{url('admin/payment/offline?action=reprint')}}" class="item @if(isset($_GET['action']) && $_GET['action'] == 'reprint') active @endif">
                            Reprint Invoice
                        </a>
                        <!-- <a href="{{url('admin/payment/offline?action=confirm_payment')}}" class="item @if(isset($_GET['action']) && $_GET['action'] == 'confirm_payment') active @endif">
                            Confirm Payment
                        </a> -->
                        </div>
                    </div>
                    <div class="twelve wide stretched column">
                        <div class="ui segment">
                            @if(isset($_GET['action']) && $_GET['action'] == 'reprint')
                            <form method="post" action="{{route('admin.payment.offline.search.invoice')}}" class="ui form form-horizontal global_form">
                                <input type="hidden" name="school_id" value="{{auth('admin')->user()->school_id}}">
                                {{csrf_field()}}
                                <div class="ui left action input">
                                    <button class="ui teal labeled icon button">
                                        <i class="search icon"></i>
                                        Search Invoice with ID:
                                    </button>
                                    <input type="text" name="invoice_id" value="">
                                </div>
                            </form>
                                <br>
                                <h2 class="ui horizontal divider header" style="color:#dc4900;">Or</h2>
                                <br>
                            <form method="post" action="{{route('admin.payment.offline.search.invoice')}}" class="ui form form-horizontal global_form">
                                <input type="hidden" name="school_id" value="{{auth('admin')->user()->school_id}}">
                                {{csrf_field()}}
                                <div class="second">
                                    <div class="fields">
                                        <div class="eleven wide field">
                                            <div class="ui left action input">
                                                <button class="ui teal labeled icon button">
                                                    <i class="search icon"></i>
                                                    Search Invoice with Student Registration Number:
                                                </button>
                                                <input type="number" value="" name="regnum" placeholde="Enter Registration Number...">
                                            </div>
                                        </div>
                                        
                                        <div class="five wide field">
                                            <select name="item_id" class="ui fluid search dropdown">
                                                <option value="">Choose Payment Item</option>
                                                @if($item_rows = DB::table('payment_items')->get())
                                                    @foreach ($item_rows as $item_data)
                                                    <option value="{{$item_data->id}}">{{$item_data->item_name}}</option>
                                                    @endforeach
                                                @endif
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            @elseif(isset($_GET['action']) && $_GET['action'] == 'confirm_payment')
                            <!-- <form method="post" action="https://www.etranzact.net/WebConnectPlus/query.jsp" class="ui form form-horizontal global_form">
                                <input type="hidden" name="school_id" value="{{auth('admin')->user()->school_id}}">
                                <input type=hidden name="TERMINAL_ID" value="0000000001">
                                {{csrf_field()}}
                                <div class="second">
                                    <div class="fields">
                                        <div class="twelve wide field">
                                            <div class="ui left action input">
                                                <button class="ui teal labeled icon button">
                                                    <i class="money bill alternate outline icon"></i>
                                                    Confirm payment with confrimation number:
                                                </button>
                                                <input type="number" value="" name="CONFIRMATION_NO" placeholde="Enter RRR Number...">
                                            </div>
                                        </div>
                                        
                                        <div class="four wide field">
                                            <input type="number" name=invoice_id placeholder="Enter Invoic ID" class="invoice ui fluid search">
                                        </div>
                                    </div>
                                </div>
                                <input type="hidden" name="RESPONSE_URL" value="{{route('admin.payment.offline.confirm.payment.response')}}">
                            </form> -->
                            @else
                            <form method="post" action="" class="form-horizontal global_form">
                                {{csrf_field()}}
                                <input type="hidden" name="school_id" value="{{auth('admin')->user()->school_id}}">
                                <input type="hidden" name="payer_id" value="{{auth('admin')->user()->id}}">
                                <div class="form-group">
                                    <label class="col-md-3 control-label">Payment For</label>
                                    <div class="col-md-5">
                                        <div class="field">
                                            <select name="item_id" required class="ui fluid search dropdown">
                                                <option value="">Choose Payment Item</option>
                                                @if($item_rows = DB::table('payment_items')->get())
                                                    @foreach ($item_rows as $item_data)
                                                    <option value="{{$item_data->id}}">{{$item_data->item_name}}</option>
                                                    @endforeach
                                                @endif
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-md-3 control-label">Session</label>
                                    <div class="col-md-5">
                                        <div class="field">
                                        <select name="session" id="sessionInput" required class="ui fluid search dropdown">
                                            <option value="">Select Session</option>
                                            <?php
                                            for($i = 2010; $i <= (date('Y') + 1) ; $i++){
                                                $i_n = $i + 1;
                                                echo '<option value="'.$i.'">'.$i.'/'.$i_n.'</option>';
                                            }
                                            ?>
                                        </select>
                                        </div>
                                    </div>
                                </div>


                                <div class="form-group">
                                    <label class="col-md-3 control-label">Select Students</label>
                                    <div class="col-md-9">
                                        <div class="multiple_select_holder" style="height: 50vh;overflow-y: auto;">
                                            <table class="ui compact celled definition table">
                                                <thead>
                                                    <tr>
                                                    <th></th>
                                                    <th>Full Name</th>
                                                    <th>Registration Number</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="studentsTable">
                                                    
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <br>
                                <div class="form-group text-center m-t-30">
                                    <div class="col-md-4 col-xs-offset-4">
                                        <input type="submit" class="ui small blue button" name="form_submit" value="Save & Continue" />
                                    </div>
                                </div>
                            </form>
                            @endif
                        </div>
                    </div>
                </div>
			</div>
		</div>
		
</div><!-- end grid -->
</section>

<div class="jtr"></div>
<script>
$(document).ready(function(){
    input = $('#sessionInput');
    table = $('#studentsTable');
    input.on('change', function(){
        $('.multiple_select_holder .field.loading').remove();
        $('.multiple_select_holder').append('<div class="field loading" style="margin-left: 10px;margin-right: 2em;margin-top: 30px;"></div>');

        // throw ajax
        var token = "{{csrf_token()}}";
        var route = "{{route('admin.payment.offline.get.students')}}";
        var school_id = "{{$school_data->id}}";
        var session = $(this).val();
        $.ajax({
            url: route,
            type: 'POST',
            data: {school_id: school_id, session: session, _token: token},
            success: function(response){
                table.html('')
                $.each(response,  function(index, value){
                    $item = '<tr>';
                    $item += '<td class="collapsing">';
                    $item += '<div class="ui fitted slider checkbox">';
                    $item += '<input type="checkbox"  name="student_id[]" value="'+value.id+'"> <label></label>';
                    $item += '</div>';
                    $item += '</td>';
                    $item += '<td>'+value.surname+' '+value.firstname+' '+value.middlename+'</td>';
                    $item += '<td>'+value.regnum+'</td>';
                    $item += '</tr>';

                    table.append($item);
                });
                $('.multiple_select_holder .field.loading').remove();
            },
            error: function(error){
                console.error(error);
            }
        });
    })
});
</script>
@endsection