@extends('layouts.main-datatable')
@section('content')   


<style>
.pay_err {
  color:#FFF;
  background-color: #C00;
  padding: 3px 8px;
  text-align: center;
}
</style> 

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')
<form class="ui form" action="" method="post">
  <h2 class="ui dividing header">{{$title}}</h2>




		<table class="ui celled table" id="global_datatable">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">Transaction Id</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Item</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Session</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Cost</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Students</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Payment Status</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Action</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  @if($transactions->count() > 0)
		  	@foreach($transactions as $transaction)
		    <tr>
		      <td>{{strtoupper($transaction->customer_id)}}</td>
		      <td>{{$transaction->item_name}}</td>
		      <td>{{$transaction->session}}</td>
		      <td>N{{number_format($transaction->total_cost)}}</td>
		      <td>{{$transaction->recipient_count}}</td>
		      <td>
		      		<a href="{{route('admin.payment.gateway.data.status', ['id' => $transaction->id])}}"> <div class="pay_err">Unverified</div> </a>
		      </td>
		      <td>
		      		<a href="{{route('admin.payment.transaction.details', ['id' => $transaction->id])}}">View Details</a>		      	
		      </td>
		    </tr>
		   @endforeach
		    @else
			<tr>
				<th colspan="4">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record was found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		  <tfoot>
		    <tr><th colspan="7">
		      <!--@include('pagination.default', ['paginator' => $transactions])-->
		    </th>
		  </tr></tfoot>
		</table>



  
</form>
   
</section>

<div class="jtr"></div>
@endsection	