@extends('layouts.main')
@section('content')   


<style>
.twelve {
  margin: 0 auto;
}
.form-group {
    margin-bottom: 20px;
}
.header {
  text-align: center;
}

.form-group label {
    font-weight: bold;
}

.ui.form input[type="text"] {
    border: 1px solid #696969;
}
</style> 

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')

  <h2 class="ui dividing header">Return Book In</h2>

<div class="ui stackable equal height stackable grid">

    <div class="twelve wide column">

                        <form method="post" action="" class="ui form">
                                {{csrf_field()}}

                                <div class="form-group">
                                    <label class="col-md-3 control-label">Class</label>
                                    <div class="col-md-5">
                                        <div class="field">
                                        <select name="class_id" id="classId" required class="ui fluid search dropdown">
                                            <option value="">Select Class</option>
                                              @foreach($classes as $class)
                                                  <option value="{{$class->id}}">{{$class->class_name}}</option>
                                              @endforeach
                                        </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-md-3 control-label">Session</label>
                                    <div class="col-md-5">
                                        <div class="field">
                                        <select name="session" id="sessionInput" required class="ui fluid search dropdown">
                                            <option value="">Select Session</option>
                                            <?php
                                            for($i = 2010; $i <= (date('Y') + 1) ; $i++){
                                                $i_n = $i + 1;
                                                echo '<option value="'.$i.'">'.$i.'/'.$i_n.'</option>';
                                            }
                                            ?>
                                        </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-md-3 control-label">Select Students</label>
                                    <div class="col-md-9">
                                        <div id="multiple_select_holder" class="multiple_select_holder" style="height: 50px;overflow-y: auto;">
                                        <table class="ui compact celled definition table" id="global_datatable">
                                            <thead>
                                                <tr>
                                                <th></th>
                                                <th>Full Name</th>
                                                <th>Registration Number</th>
                                                </tr>
                                            </thead>
                                            <tbody id="studentsTable">
                                                
                                            </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-md-3 control-label">Category</label>
                                    <div class="col-md-5">
                                        <div class="field">
                                            <select id="catId" name="cat_id" required class="ui fluid search dropdown">
                                                <option value="">Choose</option>
                                                @if($categories->count() > 0)
                                                  @foreach($categories as $category)
                                                      <option value="{{$category->id}}">{{$category->name}}</option>
                                                  @endforeach
                                                @endif
                                            </select>
                                        </div>
                                    </div>
                                </div>


                                <div class="form-group">
                                    <label class="col-md-3 control-label">Select Book</label>
                                    <div class="col-md-9">
                                        <div id="book_select_holder" class="multiple_select_holder" style="height: 50px;overflow-y: auto;">
                                        <table class="ui compact celled definition table" id="global_datatable">
                                            <thead>
                                                <tr>
                                                <th></th>
                                                <th>Title</th>
                                                <th>Author</th>
                                                <th>Subject</th>
                                                <th>Copies</th>
                                                </tr>
                                            </thead>
                                            <tbody id="booksTable">
                                                
                                            </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                               <div class="field">

                                    <div class="two fields">

                                        <div class="form-group">
                                            <label class="col-md-3 ">Return Date</label>
                                            <div class="col-md-5">
                                                    <input id="datepicker-example1" type="text" name="return_date" placeholder="Select Return Date" readonly="readonly" />                                      
                                            </div>
                                        </div>

                                  </div>

                              </div>


                                <div class="form-group text-center m-t-30">
                                    <div class="col-md-4 col-xs-offset-4">
                                        <input type="submit" class="ui small blue button" id="form_submit" name="form_submit" value="Process Book Return" />
                                    </div>
                                </div>
                            </form>

    </div>

</div>
  
</section>

<div class="jtr"></div>

<script>
var site_url = "{{url('/admin')}}";
var token = "{{csrf_token()}}";
var ajax_loader = "{{url_public('/images/ajax-loader.gif')}}";
</script>

<script>
$(document).ready(function(){

    $('#sessionInput').on('change', function(){
        var class_id = $("select[name=class_id]").val();
        var session = $("select[name=session]").val();

        if(class_id){

            $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
            $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
            $("#pagewrap_ajax_box").show('slow');          
            $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
            window.oncontextmenu = function(){return false;}    // Disable right click  
            $("input").prop('disabled', true);                 // Disable form input
            $("select").prop('disabled', true);                    // Disable form input 


            $('.multiple_select_holder .field.loading').remove();
            $('.multiple_select_holder').append('<div class="field loading" style="margin-left: 10px;margin-right: 2em;margin-top: 30px;"></div>');

            var token = "{{csrf_token()}}";
            var route = "{{route('admin.library.get.students')}}";
            var school_id = "{{$school_id}}";
            var resp_count = 0;
            var $item;

            $.ajax({
                url: route,
                type: 'POST',
                data: {school_id: school_id, session: session, class_id: class_id, _token: token},
                success: function(response){
                    window.oncontextmenu = function(){return true;}     // Enable right click
                    $("#pagewrap_ajax_box").html('');                  
                    $("#pagewrap_ajax_box").hide();                    
                    $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                    $("input").prop('disabled', false);                    // Enable form input            
                    $("select").prop('disabled', false);                   // Enable form input   

                    $('#studentsTable').html('');
                    $.each(response,  function(index, value){
                        $item = '<tr>';
                        $item += '<td class="collapsing">';
                        $item += '<div id="item_row'+value.id+'" class="item_row ui fitted">';
                        $item += '<input type="radio"  name="student_id" value="'+value.id+'"> <label></label>';
                        $item += '</div>';
                        $item += '</td>';
                        $item += '<td>'+value.surname+' '+value.firstname+' '+value.middlename+'</td>';
                        $item += '<td>'+value.regnum+'</td>';
                        $item += '</tr>';

                        $('#studentsTable').append($item);
                            if(value.regnum)
                            resp_count = resp_count + 1;
                    });

                    $('.multiple_select_holder .field.loading').remove();
                    if(resp_count > 0){
                        $("#multiple_select_holder").css({"height" : "300px"}); 
                    }
                    else{
                        $("#multiple_select_holder").css({"height" : "100px"}); 
                        $('#studentsTable').html('<tr> <td colspan="3"> No student record was found in selected class. </td> </tr>');
                    }
                },
                error: function(error){
                    window.oncontextmenu = function(){return true;}     // Enable right click
                    $("#pagewrap_ajax_box").html('');                  
                    $("#pagewrap_ajax_box").hide();                    
                    $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                    $("input").prop('disabled', false);                    // Enable form input            
                    $("select").prop('disabled', false);                   // Enable form input   
                    alert('Error encountered while processing request. Pls try again shortly');
                }
            });
        }//End if
    })


    $('#classId').on('change', function(){

        var session = $("select[name=session]").val();
        var class_id = $("select[name=class_id]").val();

        if(session){
            $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
            $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
            $("#pagewrap_ajax_box").show('slow');          
            $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
            window.oncontextmenu = function(){return false;}    // Disable right click  
            $("input").prop('disabled', true);                 // Disable form input
            $("select").prop('disabled', true);                    // Disable form input 

            $('.multiple_select_holder .field.loading').remove();
            $('.multiple_select_holder').append('<div class="field loading" style="margin-left: 10px;margin-right: 2em;margin-top: 30px;"></div>');

            var token = "{{csrf_token()}}";
            var route = "{{route('admin.library.get.students')}}";
            var school_id = "{{$school_id}}";
            var resp_count = 0;
            var $item;

            $.ajax({
                url: route,
                type: 'POST',
                data: {school_id: school_id, session: session, class_id: class_id, _token: token},
                success: function(response){
                    window.oncontextmenu = function(){return true;}     // Enable right click
                    $("#pagewrap_ajax_box").html('');                  
                    $("#pagewrap_ajax_box").hide();                    
                    $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                    $("input").prop('disabled', false);                    // Enable form input            
                    $("select").prop('disabled', false);                   // Enable form input  

                    $('#studentsTable').html('');
                    $.each(response,  function(index, value){
                        $item = '<tr>';
                        $item += '<td class="collapsing">';
                        $item += '<div id="item_row'+value.id+'" class="item_row ui fitted">';
                        $item += '<input type="radio"  name="student_id" value="'+value.id+'"> <label></label>';
                        $item += '</div>';
                        $item += '</td>';
                        $item += '<td>'+value.surname+' '+value.firstname+' '+value.middlename+'</td>';
                        $item += '<td>'+value.regnum+'</td>';
                        $item += '</tr>';

                        $('#studentsTable').append($item);
                        if(value.regnum)
                        resp_count = resp_count + 1;
                    });

                    $('.multiple_select_holder .field.loading').remove();
                    if(resp_count > 0){
                        $("#multiple_select_holder").css({"height" : "300px"}); 
                    }
                    else{
                        $("#multiple_select_holder").css({"height" : "100px"}); 
                        $('#studentsTable').html('<tr> <td colspan="3"> No student record was found in selected class. </td> </tr>');
                    }
                },
                error: function(error){
                    window.oncontextmenu = function(){return true;}     // Enable right click
                    $("#pagewrap_ajax_box").html('');                  
                    $("#pagewrap_ajax_box").hide();                    
                    $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                    $("input").prop('disabled', false);                    // Enable form input            
                    $("select").prop('disabled', false);                   // Enable form input  

                    alert('Error encountered while processing request. Pls try again shortly');
                }
            });
        }//End if
    })


    $('#catId').on('change', function(){

        var cat_id = $("select[name=cat_id]").val();

        if(cat_id){
            $("#pagewrap_ajax_box").css({"position" : "fixed", "z-index" : "9999", "left" : "45%", "top" : "25%"});           
            $("#pagewrap_ajax_box").html('<img src="'+ajax_loader+'" />');
            $("#pagewrap_ajax_box").show('slow');          
            $("#bodywrapid").css({"pointer-events" : "none", "opacity" : "0.7"});   
            window.oncontextmenu = function(){return false;}    // Disable right click  
            $("input").prop('disabled', true);                 // Disable form input
            $("select").prop('disabled', true);                    // Disable form input 

            $('#book_select_holder .field.loading').remove();
            $('#book_select_holder').append('<div class="field loading" style="margin-left: 10px;margin-right: 2em;margin-top: 30px;"></div>');

            var token = "{{csrf_token()}}";
            var route = "{{route('admin.library.get.category.books')}}";
            var school_id = "{{$school_id}}";
            var resp_count = 0;
            var $item;

            $.ajax({
                url: route,
                type: 'POST',
                data: {school_id: school_id, cat_id: cat_id, _token: token},
                success: function(response){
                    window.oncontextmenu = function(){return true;}     // Enable right click
                    $("#pagewrap_ajax_box").html('');                  
                    $("#pagewrap_ajax_box").hide();                    
                    $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                    $("input").prop('disabled', false);                    // Enable form input            
                    $("select").prop('disabled', false);                   // Enable form input  

                    $('#booksTable').html('');
                    $.each(response,  function(index, value){
                        $item = '<tr>';
                        $item += '<td class="collapsing">';
                        $item += '<div id="item_row'+value.id+'" class="item_row ui fitted">';
                        $item += '<input type="radio"  name="book_id" value="'+value.id+'"> <label></label>';
                        $item += '</div>';
                        $item += '</td>';
                        $item += '<td>'+value.title+'</td>';
                        $item += '<td>'+value.author+'</td>';
                        $item += '<td>'+value.subject+'</td>';
                        $item += '<td>'+value.available+'</td>';
                        $item += '</tr>';

                        $('#booksTable').append($item);
                        if(value.id)
                        resp_count = resp_count + 1;
                    });

                    $('#book_select_holder .field.loading').remove();
                    if(resp_count > 0){
                        $("#book_select_holder").css({"height" : "300px"}); 
                    }
                    else{
                        $("#book_select_holder").css({"height" : "100px"}); 
                        $('#booksTable').html('<tr> <td colspan="3"> No book record was found in selected category. </td> </tr>');
                    }
                },
                error: function(error){
                    window.oncontextmenu = function(){return true;}     // Enable right click
                    $("#pagewrap_ajax_box").html('');                  
                    $("#pagewrap_ajax_box").hide();                    
                    $("#bodywrapid").css({"pointer-events" : "auto", "opacity" : "1"});   
                    $("input").prop('disabled', false);                    // Enable form input            
                    $("select").prop('disabled', false);                   // Enable form input  

                    alert('Error encountered while processing request. Pls try again shortly');
                }
            });
        }//End if
    })

});
</script>

<link href="{{ url_public('/vendor/zebra-date/zebra_default.css') }}" rel="stylesheet" />

<script src="{{ url_public('/vendor/zebra-date/zebra_datepicker.js') }}"></script>
                      
<script type="text/javascript">
$('#datepicker-example1').Zebra_DatePicker();
$('#datepicker-example2').Zebra_DatePicker();
</script>

@endsection 