@extends('layouts.main')
@section('content')   


<style>
.twelve {
  margin: 0 auto;
}
.form-group {
    margin-bottom: 20px;
}
.header {
  text-align: center;
}

.form-group label {
    font-weight: bold;
}

.ui.form input[type="text"] {
    border: 1px solid #696969;
}
</style> 

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')

  <h2 class="ui dividing header">Edit Book Inventory</h2>

<div class="ui stackable equal height stackable grid">

    <div class="twelve wide column">

                        <form method="post" action="" class="ui form">
                                {{csrf_field()}}

                                <div class="form-group">
                                    <label class="col-md-3 ">Title</label>
                                    <div class="col-md-5">
                                            <input type="text" value="{{$book->title}}" disabled="disabled" />  
                                            <input type="hidden" value="{{$book->id}}" name="book_id" />        
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-md-3 ">Copies Available</label>
                                    <div class="col-md-5">
                                            <input type="text" value="{{$book->available}}" disabled="disabled" />  
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label class="col-md-3 ">Choose Inventory Action</label>
                                    <div class="col-md-5">
                                            <select name="edit_action" required class="ui fluid search dropdown">
                                                <option value=""></option>
                                                <option value="1">Add Copy</option>
                                                <option value="2">Deduct Copy</option>
                                            </select> 
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-md-3 ">Copies To Add/Deduct</label>
                                    <div class="col-md-5">
                                            <input type="number" name="copy_count" required="required" />  
                                    </div>
                                </div>


                                <div class="form-group text-center m-t-30">
                                    <div class="col-md-4 col-xs-offset-4">
                                        <input type="submit" class="ui small blue button" id="form_submit" name="form_submit" value="Save to Inventory" />
                                    </div>
                                </div>
                            </form>

    </div>

</div>
  
</section>

<div class="jtr"></div>

@endsection 