@extends('layouts.main-datatable')
@section('content')   


<style>
.ui.celled.table tr th, .ui.celled.table tr td {
	font-size: 12px;
}
</style> 

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')
<form class="ui form" action="" method="post">
  <h2 class="ui dividing header">All Library Books</h2>

		<table class="ui celled table" id="global_datatable">
		  <thead>
		    <tr>
            <th width="5%">S/N</th>
            <th width="10%">Category</th>
            <th>Title</th>
            <th width="10%">Author</th>
            <th width="10%">Publisher</th>
            <th width="10%">Subject</th>
            <th width="10%">Location</th>
            <th width="9%">ISBN</th>
            <th width="7%">Copies</th>
		    <th>
		    	<div class="ui ribbon label"></div>
		    </th>
		  </tr></thead>
		  <tbody>
		  @if(count($books) > 0)
		  	@php
		  	$sn = 1
		  	@endphp
		  	@foreach($books as $book)
		    <tr>
		      <td>{{$sn}}</td>
		      <td>{{$book->name}}</td>
		      <td>{{$book->title}}</td>
		      <td>{{$book->author}}</td>
		      <td>{{$book->publisher}}</td>
		      <td>{{$book->subject}}</td>
		      <td>{{$book->location}}</td>
		      <td>{{$book->isbn}}</td>
		      <td>{{$book->available}}</td>
		      <td>
		      	<div><a href="{{route('admin.library.book.details', ['id' => $book->id])}}"> View Details </a></div>
		      	<div><a href="{{route('admin.library.book.copies.edit', ['id' => $book->id])}}"> Edit Inventory </a></div>
		      </td>
		    </tr>
		  	@php
		  	$sn++
		  	@endphp
		   @endforeach
		    @else
			<tr>
				<th colspan="9">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record was found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		</table>



  
</form>
   
</section>

<div class="jtr"></div>

@endsection	