@extends('layouts.main')
@section('content')   


<style>
.twelve {
  margin: 0 auto;
}
.form-group {
    margin-bottom: 20px;
}
.header {
  text-align: center;
}

.form-group label {
    font-weight: bold;
}

.ui.form input[type="text"], .ui.form select {
    border: 1px solid #696969;
}
</style> 

<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">
@include('partial.error')

  <h2 class="ui dividing header">Add Library Book</h2>

<div class="ui stackable equal height stackable grid">

    <div class="twelve wide column">

                        <form method="post" action="" class="ui form">
                                {{csrf_field()}}

                                <div class="form-group">
                                    <label class="col-md-3 control-label">Category</label>
                                    <div class="col-md-5">
                                        <div class="field">
                                            <select name="cat_id" required class="ui fluid search dropdown">
                                                <option value="">Choose</option>
                                                @if($categories->count() > 0)
                                                  @foreach($categories as $category)
                                                      <option value="{{$category->id}}">{{$category->name}}</option>
                                                  @endforeach
                                                @endif
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-md-3 ">Title</label>
                                    <div class="col-md-5">
                                            <input type="text" name="title" required="required" />                                      
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-md-3 ">Sub Title</label>
                                    <div class="col-md-5">
                                            <input type="text" name="sub_title" />                                      
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label class="col-md-3 ">Author</label>
                                    <div class="col-md-5">
                                            <input type="text" name="author" required="required" />                                      
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label class="col-md-3 ">Publisher</label>
                                    <div class="col-md-5">
                                            <input type="text" name="publisher" required="required" />                                      
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label class="col-md-3 ">Subject</label>
                                    <div class="col-md-5">
                                            <input type="text" name="subject" required="required" />                                      
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label class="col-md-3 ">Description</label>
                                    <div class="col-md-5">
                                           <textarea name="descrip"></textarea>                                      
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label class="col-md-3 ">Physical Location</label>
                                    <div class="col-md-5">
                                            <input type="text" name="location" />                                      
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label class="col-md-3 ">ISBN</label>
                                    <div class="col-md-5">
                                            <input type="text" name="isbn" />                                      
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label class="col-md-3 ">Serial Number</label>
                                    <div class="col-md-5">
                                            <input type="text" name="serial_no" />                                      
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label class="col-md-3 ">Number of Copies Available</label>
                                    <div class="col-md-5">
                                            <input type="number" name="copies" required="required" />                                      
                                    </div>
                                </div>


                                <div class="form-group text-center m-t-30">
                                    <div class="col-md-4 col-xs-offset-4">
                                        <input type="submit" class="ui small blue button" id="form_submit" name="form_submit" value="Save" />
                                    </div>
                                </div>
                            </form>

    </div>

</div>
  
</section>

<div class="jtr"></div>

@endsection 