@extends('layouts.main')
@section('content')
<br>
<section class="ui raised segment" style="max-width: 1200px; margin: 20px auto;">
	<h2 class="ui horizontal divider cap header" style="color:#dc4900;">
	  ID Card Requests
	</h2>
	<div class="ui statistics">
	  <div class="statistic">
	    <div class="value">
	      {{App\StudentIDCardRequest::where('school_id', $school->id)->get()->count()}}
	    </div>
	    <div class="label">
	    	All ID Card Request
	    </div>
	  </div>
	  <div class="statistic">
	    <div class="value">
	      {{App\StudentIDCardRequest::where('school_id', $school->id)->where('is_verified', false)->get()->count()}}
	    </div>
	    <div class="label">
	    	Pending ID Card Request
	    </div>
	  </div>
	  <div class="statistic">
	    <div class="value">
	      {{App\StudentIDCardRequest::where('school_id', $school->id)->where('is_verified', true)->get()->count()}}
	    </div>
	    <div class="label">
	    	Approved ID Card Request
	    </div>
	  </div>
	</div>
	<br>
	<!-- ui stackable equal height stackable grid -->
	<div class="grid">
		<div class="shadowundertop"></div>
		<div class="row">
			<div class="c8">
                <div class="ui grid">
                    <div class="four wide column">
                        <div class="ui vertical fluid tabular menu">
                        <a href="{{url('admin/school-id-card-request')}}" class="item @if(!isset($_GET['action']) || $_GET['action'] == '') active @endif">
                        	Request ID Card
                        </a>
                        <a href="{{url('admin/school-id-card-request?action=cancle_request')}}" class="item @if(isset($_GET['action']) && $_GET['action'] == 'cancle_request') active @endif">
                            Cancle ID Card Request
                        </a>
                        <a href="{{url('admin/school-id-card-request?action=pending_request')}}" class="item @if(isset($_GET['action']) && $_GET['action'] == 'pending_request') active @endif">
                            View Pending ID Card Request
                        </a>
                        <a href="{{url('admin/school-id-card-request?action=approved_request')}}" class="item @if(isset($_GET['action']) && $_GET['action'] == 'approved_request') active @endif">
                            View Approved ID Card Request
                        </a>
                        </div>
                    </div>
                    <div class="twelve wide stretched column">
                        <div class="ui segment">
                            @if(isset($_GET['action']) && $_GET['action'] == 'cancle_request')
                                @php $pending_requests = App\StudentIDCardRequest::where('school_id', $school->id)->where('is_verified', false)->get(); @endphp
                                @if($pending_requests->count() > 0)
                                <form method="post" action="" class="form-horizontal global_form">
                                    {{csrf_field()}}
                                    <input type="hidden" name="school_id" value="{{auth('admin')->user()->school_id}}">
                                    <input type="hidden" name="payer_id" value="{{auth('admin')->user()->id}}">
                                    <input type="hidden" name="type" value="cancle">
                                    <div class="form-group">
                                        <div class="col-md-9">
                                            <div class="multiple_select_holder" style="height: 50vh;overflow-y: auto;">
                                                <table class="ui compact celled definition table">
                                                    <thead>
                                                        <tr>
                                                        <th></th>
                                                        <th>Full Name</th>
                                                        <th>Registration Number</th>
                                                        <th>Status</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                    @foreach($pending_requests as $pending_request)
                                                        <tr>
                                                            <td class="collapsing">
                                                                <div class="ui fitted slider checkbox">
                                                                <input type="checkbox"  name="student_id[]" value="{{$pending_request->student->id}}"> <label></label>
                                                                </div>
                                                            </td>
                                                            <td>{{$pending_request->student->surname.' '.$pending_request->student->firstname.' '.$pending_request->student->middlename}}</td>
                                                            <td>{{$pending_request->student->regnum}}</td>
                                                            <td><span style="color:grey;">Pending</span></td>  
                                                        </tr>
                                                    @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    
                                    <br>
                                    <br>
                                    <div class="form-group text-center m-t-30">
                                        <div class="col-md-4 col-xs-offset-4">
                                            <input type="submit" class="ui small red button" name="form_submit" value="Cancle Selected Requests" />
                                        </div>
                                    </div>
                                </form>
                                @else
                                <div class="ui negative message">
									<i class="close icon"></i>
									<div class="header">
										No pending request available
									</div>
									<p>
									    <a href="{{url('admin/school-id-card-request')}}" class="item @if(!isset($_GET['action']) || $_GET['action'] == '') active @endif">
                                        	Click
                                        </a> to create ID Card Requests
									</p>
								</div>
                                @endif
                            @elseif(isset($_GET['action']) && $_GET['action'] == 'pending_request')
                                @php $pending_requests = App\StudentIDCardRequest::where('school_id', $school->id)->where('is_verified', false)->get(); @endphp
	                            <div class="ui feed">
	                            @forelse($pending_requests as $pending_request)
								  <div class="event">
								    <div class="label">
								      <img src="{{url_public($pending_request->student->passport)}}">
								    </div>
								    <div class="content">
								      <div class="summary">
								        {{$pending_request->student->surname}} {{$pending_request->student->firstname}} {{$pending_request->student->middlename}}
								      </div>
								      <div class="date">
								        <small>requested by {{strtolower($pending_request->admin->username)}}</small>
								      </div>
								      <div class="extra text" style="pointer-events: none;">
								            <div class="ui labeled button" tabindex="0">
                                              <div class="ui yellow button">
                                                <i class="refresh icon"></i> Pending
                                              </div>
                                              <a class="ui basic yellow left pointing label">
                                                {{$pending_request->created_at->diffForHumans()}}
                                              </a>
                                            </div>
								      </div>
								    </div>
								  </div>
								@empty
									<div class="ui icon negative message">
									  <i class="info circle icon"></i>
									  <div class="content">
									    <div class="header">
									    Sorry, No Record can be found.
									  	</div>
									  </div>
									</div>
								@endforelse
								</div>
                            @elseif(isset($_GET['action']) && $_GET['action'] == 'approved_request')
                                @php $approved_requests = App\StudentIDCardRequest::where('school_id', $school->id)->where('is_verified', true)->get(); @endphp
	                            <div class="ui feed">
	                            @forelse($approved_requests as $approved_request)
								  <div class="event">
								    <div class="label">
								      <img src="{{url_public($approved_request->student->passport)}}">
								    </div>
								    <div class="content">
								      <div class="summary">
								        {{$approved_request->student->surname}} {{$approved_request->student->firstname}} {{$approved_request->student->middlename}}
								      </div>
								      <div class="date">
								        <small>requested by {{strtolower($approved_request->admin->username)}}</small>
								      </div>
								      <div class="extra text" style="pointer-events: none;">
								            <div class="ui labeled button" tabindex="0">
                                              <div class="ui green button">
                                                <i class="refresh icon"></i> Approved
                                              </div>
                                              <a class="ui basic green left pointing label">
                                                {{$approved_request->created_at->diffForHumans()}}
                                              </a>
                                            </div>
								      </div>
								    </div>
								  </div>
								@empty
									<div class="ui icon negative message">
									  <i class="info circle icon"></i>
									  <div class="content">
									    <div class="header">
									    Sorry, No Record can be found.
									  	</div>
									  </div>
									</div>
								@endforelse
								</div>
                            @else
                            <div class="new">
                                <div class="ui yellow message">
									<i class="close icon"></i>
									<div class="header">
										Please note!
									</div>
									<p>
										Only students with passport can an ID Card request be made for
									</p>
								</div>
                                <form class="ui form" action="{{route('admin.school.wallet.student.search')}}" onsubmit="event.preventDefault(); searchStudents(this);" method="post" enctype="multipart/form-data">
                        			<input type="hidden" name="_token" value="{{csrf_token()}}">
                        		  <h2 class="ui dividing header">Search Students</h2>
                        		  <div class="five fields">
                        	      <div class="field">
                        	        <label>Session</label>
                        	        <div class="ui fluid search selection dropdown">
                        	          <input type="hidden" name="session" value="{{old('session')}}" required>
                        	          <i class="dropdown icon"></i>
                        	          <div class="default text">Session</div>
                        	          <div class="menu">
                        	            @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
                        	             <div class="item" data-value="{{$i}}">{{$i}}/{{$i+1}}</div>
                        	            @endfor
                        	          </div>
                        	        </div>
                        	      </div>
                        	      <div class="field">
                        	        <label>Term</label>
                        	        <div class="ui fluid search selection dropdown">
                        	          <input type="hidden" name="term" value="{{old('term')}}" required>
                        	          <i class="dropdown icon"></i>
                        	          <div class="default text">Term</div>
                        	          <div class="menu">
                        	             <div class="item" data-value="First"> First Term </div>
                        	             <div class="item" data-value="Second"> Second Term </div>
                        	             <div class="item" data-value="Third"> Third Term </div>
                        	          </div>
                        	        </div>
                        	      </div>
                        	      
                        	      <div class="field">
                        	        <label>Class</label>
                        	        <div class="ui fluid search selection dropdown" id="classes-dropdown">
                        	          <input type="hidden" name="class_id" value="{{old('class_id')}}" data-href="{{url('/do-ajax/class')}}" required>
                        	          <i class="dropdown icon"></i>
                        	          <div class="default text">Class</div>
                        	          <div class="menu">
                        	            @foreach($classes as $class)
                        	             <div class="item" data-value="{{$class->id}}">{{$class->class_name}}</div>
                        	            @endforeach
                        	          </div>
                        	        </div>
                        	      </div>
                        	      <div class="field" id="field-arms">
                        	        <label>Class Arm</label>
                        	        <div class="ui fluid search selection dropdown">
                        	          <input type="hidden" name="class_arm_id" value="{{old('class_arm_id')}}" required>
                        	          <i class="dropdown icon"></i>
                        	          <div class="default text">Class Arm</div>
                        	          <div class="menu" id="class-arms">
                        	            @if(!empty(old('class_id')))
                        	                @foreach(getClassArms(old('class_id')) as $class_arm)
                        	                 <div class="item" data-value="{{$class_arm->id}}">{{$class_arm->class_arm}}</div>
                        	                @endforeach
                        	              @else
                        	                 <div class="item" data-value="">Select Class Arm</div>
                        	              @endif
                        	            
                        	          </div>
                        	        </div>
                        	      </div>
                        	      <div class="field">
                        	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View Students</button>
                        	      </div>
                        
                        	    </div>
                        		  
                        		</form>
                                <br>
                                <form method="post" action="" class="form-horizontal global_form">
                                    {{csrf_field()}}
                                    <input type="hidden" name="school_id" value="{{auth('admin')->user()->school_id}}">
                                    <input type="hidden" name="payer_id" value="{{auth('admin')->user()->id}}">
                                    <input type="hidden" name="type" value="create">
                                    <div class="form-group">
                                        <div class="col-md-9">
                                            <div class="multiple_select_holder" style="height: 50vh;overflow-y: auto;">
                                                <table class="ui compact celled definition table">
                                                    <thead>
                                                        <tr>
                                                        <th></th>
                                                        <th>Full Name</th>
                                                        <th>Registration Number</th>
                                                        <th>Passport</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody id="studentsTable">
                                                        
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="has_passport"></div>
                                    <br>
                                    
                                    <br>
                                    <br>
                                    <div class="form-group text-center m-t-30">
                                        <div class="col-md-4 col-xs-offset-4">
                                            <input type="submit" class="ui small blue button" name="form_submit" value="Request ID Card For Selected Students" />
                                        </div>
                                    </div>
                                </form>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
			</div>
		</div>	
	</div>
</section>
<style>
.ext{
    width: 100% !important;
}
.ext .card{
    width: 100% !important;
}
.ext .card .item{
    text-align: left;
    padding: 13px;
}
.ext .card .content{
    text-align: right;
    float: right;
}
</style>
<script>
function searchStudents(obj){
    var form,table,data,route,term;
    form = $(obj);
    term = form.find('input[name=term]').val();
    table = $('#studentsTable');
    $('.multiple_select_holder .field.loading').remove();
    $('.multiple_select_holder').append('<div class="field loading" style="margin-left: 10px;margin-right: 2em;margin-top: 30px;"></div>');

    // throw ajax
    // var token = "{{csrf_token()}}";
    route = form.attr('action');
    data = form.serialize();
    $.ajax({
        url: route,
        type: 'POST',
        data: data,
        success: function(response){
            console.log(response);
            table.html('')
            $.each(response,  function(index, value){
                $item = '<tr>';
                $item += '<td class="collapsing">';
                $item += '<div class="ui fitted slider checkbox">';
                $item += '<input type="checkbox"  name="student_id[]" value="'+value.id+'"> <label></label>';
                $item += '</div>';
                $item += '</td>';
                $item += '<td>'+value.surname+' '+value.firstname+' '+value.middlename+'</td>';
                $item += '<td>'+value.regnum+'</td>';
                if($('div.has_passport').length){
                    $item += '<td><img src="https://odsgmoe.com/eportal/public'+value.passport+'" style="height:100px;"></td>';    
                }
                $item += '</tr>';

                table.append($item);
            });
            $('.hidden__term__input').remove();
            $('.multiple_select_holder').append('<input type="hidden" name="term" value="'+term+'" class="hidden__term__input">');
            $('.multiple_select_holder .field.loading').remove();
        },
        error: function(error){
            console.error(error);
            table.html('');
            $('.multiple_select_holder .field.loading').remove();
        }
    });
}
</script>
@endsection