@extends('layouts.main')

@section('content')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">

		<h2 class="ui horizontal divider header" style="color:#dc4900;">View Debtors and Penalized Student</h2>
		
		@include('partial.error')
	  <form action="" method="post" class="ui form">
	  {{csrf_field()}}

		<table class="ui celled table">
		  <thead>
		   <tr>
		   <th>
		   	   <div class="ui ribbon label">S/N</div>
		   </th>
		    <th>
		    	<div class="ui ribbon label">Student's Fullname</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Registration Number</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Student's Issue</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Select Students</div>
		    	<div class="ui toggle checkbox check-all">
					<input type="checkbox" class="">
					<label>Select All</label>
				</div>
		    </th>
		  </tr>
		  </thead>
		  <tbody>
		  @if(count($debtors) > 0)
		  	@foreach($debtors as $debtor)
		    <tr>
		      <td>{{++$counter}}</td>
		      <td>{{getStudentFullnameByStudentID($debtor->student_id)}}</td>
		      <td>{{getRegNumByStudentID($debtor->student_id)}}</td>
		      <td>
		      	{{$debtor->issue}}
		      </td>
		      <td class="std-view">
		      	<input type="hidden" name="student_id[]" value="{{$debtor->student_id}}">
			     <div class="ui toggle checkbox studentID"> <!-- When Debtor Status is 1 it implies Debtor has cleared his or her debt -->
					<input type="checkbox" name="status[]" value="{{$debtor->student_id}}" {{$debtor->status === 1 ? 'checked="checked"' : ''}}><label></label>
				</div>
			  </td>
		    </tr>
		   @endforeach
		    @else
			<tr>
				<th colspan="5">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		  <tfoot>
		  	<tr>
		  		<td colspan="5">
		  			 @include('pagination.default', ['paginator' => $debtors])
		  		</td>
		  	</tr>
		  </tfoot>
		</table>
			<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Release Debtor or Penalized Students</button>
	</form>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="{{csrf_token()}}">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
@endsection