@extends('layouts.main')

@section('content')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">

		<h2 class="ui horizontal divider header" style="color:#dc4900;">Configure Debtors and Penalized Student<br>
		<span style="font-size: 16px">{{getClassNameByClassID($class_id)}} {{getClassArmNameByClassArmID($classarm_id)}} {{$term}} Term {{$session}} / {{($session + 1)}} Session</span>
		</h2>
		
		@include('partial.error')
	  <form action="{{route($route)}}" method="post" class="ui form">
	  	<input type="hidden" name="_token" value="{{csrf_token()}}">
	  	<input type="hidden" name="session" value="{{!empty(old('session')) ? old('session') : $session}}">
	  	<input type="hidden" name="class_id" value="{{!empty(old('class_id')) ? old('class_id') : $class_id}}">
	  	<input type="hidden" name="classarm_id" value="{{!empty(old('classarm_id')) ? old('classarm_id') : $classarm_id}}">
	  	<input type="hidden" name="term" value="{{!empty(old('term')) ? old('term') : $term}}">

		<table class="ui celled table">
		  <thead>
		   <tr>
		    <th>
		    	<div class="ui ribbon label">Student's Fullname</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Registration Number</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Student's Issue</div>
		    </th>
		  </tr>
		  </thead>
		  <tbody>
		  @if(count($classarm_students) > 0)
		  	@foreach($classarm_students as $student)
		    <tr>
		      <td>{{$student->surname.' '.$student->firstname.' '.$student->middlename}}</td>
		      <td>{{$student->regnum}}</td>
		      <td>
		      	<textarea name="issue[{{$student->id}}]" placeholder="What is the Issue?">{{getIssue($student->id)}}</textarea>
		      </td>
		    </tr>
		   @endforeach
		    @else
			<tr>
				<th colspan="3">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		</table>
			<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Submit Debtor or Penalized Students</button>
	</form>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="{{csrf_token()}}">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
@endsection