@extends('layouts.main')
@section('content')

<style>
.form-group {
    margin-bottom: 20px;
}
</style>

<section class="ui raised segment" style="max-width: 600px; margin: 20px auto;">
@include('partial.error')

  <form action="" method="post" enctype="multipart/form-data" class="ui form">
    <h4 class="ui dividing header">Batch Upload Comments</h4>
    <input type="hidden" value="{{csrf_token()}}" name="_token" value="{{old('_token')}}">


    <div class="form-group">
        <label class="col-md-3 "><strong>Comment Category</strong></label>
        <div class="col-md-5">
             <select name="category" required="required">
                <option value=""></option>
                <option value="1">Teacher</option>
                <option value="2">House Master</option>
                <option value="3">Guardian/Counsellor</option>
                <option value="4">Principal</option>
             </select>                                      
        </div>
    </div>

    <div class="two fields">
      <div class="field">
        <label>Session</label>
        <div class="ui fluid search selection dropdown">
          <input type="hidden" name="session" value="{{old('session')}}">
          <i class="dropdown icon"></i>
          <div class="default text">Session</div>
          <div class="menu">
            @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
             <div class="item" data-value="{{$i}}">{{$i}}/{{$i+1}}</div>
            @endfor
          </div>
        </div>
      </div>

      <div class="field">
        <label>Term</label>
        <div class="ui fluid search selection dropdown">
          <input type="hidden" name="term" value="{{old('term')}}">
          <i class="dropdown icon"></i>
          <div class="default text">Term</div>
          <div class="menu">
             <div class="item" data-value="First"> First Term </div>
             <div class="item" data-value="Second"> Second Term </div>
             <div class="item" data-value="Third"> Third Term </div>
          </div>
        </div>
      </div>
    </div>

    <div class="two fields">
      <div class="field">
        <label>Class</label>
        <div class="ui fluid search selection dropdown" id="classes-dropdown">
          <input type="hidden" name="class_id" value="{{old('class_id')}}" data-href="{{url('/do-ajax/class')}}" >
          <i class="dropdown icon"></i>
          <div class="default text">Class</div>
          <div class="menu">
            @foreach($classes as $class)
             <div class="item" data-value="{{$class->id}}">{{$class->class_name}}</div>
            @endforeach
          </div>
        </div>
      </div>

      <div class="field" id="field-arms">
        <label>Class Arm</label>
        <div class="ui fluid search selection dropdown">
          <input type="hidden" name="classarm_id" value="{{old('class_arm_id')}}">
          <i class="dropdown icon"></i>
          <div class="default text">Class Arm</div>
          <div class="menu" id="class-arms">
            @if(!empty(old('class_id')))
                @foreach(getClassArms(old('class_id')) as $class_arm)
                 <div class="item" data-value="{{$class_arm->id}}">{{$class_arm->class_arm}}</div>
                @endforeach
              @else
                 <div class="item" data-value="">Select Class Arm</div>
              @endif
            
          </div>
        </div>
      </div>
    </div>
    

    <div class="fields">
      <div class="field">
        <div class="ui right action input">
            <input type="text" class="pseudo-batch-file-name" name="pseudo_batch_file_name" >
            <button type="button" class="ui orange labeled icon button pseudo-batch-file">
              <i class="file excel outline icon"></i>
              Choose Excel File
            </button>
          </div>
              <input type="file" name="batch_file" id="batch_file" class="batch-file" style="display: none">
      </div>
    </div>
    
  <div class="field">
    <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Submit Upload</button>
    </div>
  </form>
</section>
<div class="jtr"></div>
@endsection