@extends('layouts.main')
@section('content')

<style type="text/css">
.header {
  text-align: center;
  margin-bottom: 30px;
}  
</style>

<section class="ui stackable grid raised segment" style="margin: 20px auto; max-width: 1024px">
<div class="sixteen wide column">
@include('partial.error')
    <h4 class="ui dividing header">Batch Upload Comments Template</h4>
</div>
  <div class="eight wide column">
    <div class="ui divided list cart-summary">
      @foreach($inputs as $key => $input)
      <div class="item">  
        <div class="content">
          @if($key == 'class')
          <strong class="">{{strtoupper($key)}} : </strong> 
          <span class="mini meta">{{getClassNameByClassID($input)}}</span> 
          @elseif($key == 'class arm')
          <strong class="">{{strtoupper($key)}} : </strong> 
          <span class="mini meta">{{getClassArmNameByClassArmID($input)}}</span>
          @elseif($key == 'session') 
          <strong class="">{{strtoupper($key)}} : </strong> 
          <span class="mini meta">{{$input}}/{{($input+1)}}</span>
          @else
          <strong class="">{{strtoupper($key)}} : </strong> 
          <span class="mini meta">{{$input}}</span> 
          @endif
        </div> 
      </div> 
      @endforeach
    </div>
  </div>
  
  <div class="eight wide column">

<div class="ui icon info message">
      <i class="file excel outline icon"></i>
      <div class="content">
        <div class="header">
          Download {{getClassNameByClassID($inputs['class']).' '.getClassArmNameByClassArmID($inputs['class arm'])}} Comment Upload Format
        </div>
        <div class="description">
          <form action="{{route('admin.download.comments.template')}}" method="post">
            <input type="hidden" name="_token" value="{{csrf_token()}}">
            <input type="hidden" name="session" value="{{$inputs['session']}}">
            <input type="hidden" name="class_id" value="{{$inputs['class']}}">
            <input type="hidden" name="classarm_id" value="{{$inputs['class arm']}}">
            <input type="hidden" name="term" value="{{$inputs['term']}}">
            <button type="submit" class="fluid ui button" style="background-color: #f75a0c; color:white;">Download</button>
          </form>
        </div>
      </div>
    </div>

  </div>

</section>

<div class="jtr"></div>
@endsection