@extends('layouts.main')
@section('content')

<section class="ui raised segment" style="max-width: 1024px; margin: 20px auto;">
		@include('partial.error')
		<form class="ui form" action="{{route('admin.view.school.classes.page')}}" method="post" enctype="multipart/form-data">
			<input type="hidden" name="_token" value="{{csrf_token()}}">
		  <h2 class="ui dividing header">Search Class</h2>
		  <div class="two fields">
	      
	      <div class="field">
	          <label>Class</label>
	          <div class="ui fluid search selection dropdown">
	            <input type="hidden" name="class_id" value="{{old('class_id')}}">
	            <i class="dropdown icon"></i>
	            <div class="default text">Class</div>
	            <div class="menu">
	              @foreach($all_classes as $class)
	               <div class="item" data-value="{{$class->id}}">{{$class->class_name}}</div>
	              @endforeach
	            </div>
	          </div>
	        </div>
		    
	      <div class="field">
	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View Classes</button>
	      </div>

	    </div>
		  
		</form>
		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  <i class="student icon"></i>
		  View Class Information
		</h2>
		<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">Classes</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Class Arms</div>
		    </th>
		    <th colspan="2">
		    	<div class="ui ribbon label">Actions on Classes</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  @if($classes->count() > 0)
		  	@foreach($classes as $class)
		    <tr>
		      <td>{{$class->class_name}}</td>
		      <td>
		      	<div class="ui middle aligned divided list">
		      	@foreach(getClassArms($class->id) as $classarms)
		      	<div class="item">
				    <div class="content">
				      <p class="header">{{$classarms->class_arm}}</p>
				    </div>
				</div>
		      	@endforeach
		      	</div>
		      </td>
		      <td class="std-view">
		      @if(auth('admin')->user()->can('edit-class'))
			      <button class="ui labeled blue icon button" data-std-id="{{$class->id}}" data-href="{{route('admin.edit.school.class', ['id' => $class->id])}}">
				  <i class="edit icon"></i>
				  Edit
				</button>
				@endif
			  </td>
		      <td class="std-view">
		      @if(auth('admin')->user()->can('delete-class'))
				<button class="ui labeled negative icon button" data-std-id="{{$class->id}}" data-href="{{route('admin.delete.school.class', ['id' => $class->id])}}">
				  <i class="trash icon"></i>
				  Delete
				</button>
				@endif
		      </td>
		    </tr>
		   @endforeach
		    @else
			<tr>
				<th colspan="4">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		  <tfoot>
		    <tr><th colspan="4">
		      @include('pagination.default', ['paginator' => $classes])
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="{{csrf_token()}}">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
@endsection