@extends('layouts.main')
@section('content')

<section class="ui raised segment" style="max-width: 1024px; margin: 20px auto;">
		@include('partial.error')
		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  <i class="student icon"></i>
		  View Class Information
		</h2>

		<form class="ui form" action="{{route('admin.view.school.classarms.page')}}" method="post">
		<div class="two fields">
		    <input type="hidden" value="{{csrf_token()}}" name="_token" value="{{old('_token')}}">
		    <div class="field">
		      <label>Session</label>
		      <div class="ui fluid search selection dropdown">
		        <input type="hidden" name="session" value="{{old('session')}}">
		        <i class="dropdown icon"></i>
		        <div class="default text">Session</div>
		        <div class="menu">
		          @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
		           <div class="item" data-value="{{$i}}">{{$i}}/{{$i+1}}</div>
		          @endfor
		        </div>
		      </div>
		    </div>
		  <div class="field">
		    <button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:23.5px">View Classes</button>
		  </div>
		</div>
		</form>
		<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">Class and Class Arms</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Class Arm Subjects and Subject Teachers</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Class Arm Teacher</div>
		    </th>
		    <th colspan="2">
		    	<div class="ui ribbon label">Actions on Class Arms</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  @if($classarms->count() > 0)
		  	@foreach($classarms as $classarm)
		    <tr>
		      <td>{{getClassNameByClassID($classarm->class_id)}} {{$classarm->class_arm}}</td>
		      <td>
		      	<div class="ui middle aligned divided list">
		     @if(count(getAssocSubjectByClassArmIDSession($classarm->id, $session)) > 0)
		      	@foreach(getAssocSubjectByClassArmIDSession($classarm->id, $session) as $subject)
		      	<div class="item">
				    <div class="content">
				      <p class="header">{{$subject->subject_name .'('.$subject->class_category.') ['.getTeacherFullnameByStudentID($subject->pivot->teacher_id).']' }}</p>
				    </div>
				</div>
		      	@endforeach
		     @else
            <div class="ui icon negative message">
	          <div class="item">
	              <div class="content">
	                <p class="header">No Subject assign to this class arm</p>
	              </div>
	          </div>
	        </div>
            @endif
		      	</div>
		      </td>
		      <td>
		      	<div class="ui middle aligned divided list">
			     @if(count(getAssocTeacherByClassArmID($classarm->id)) > 0)
			      	@foreach(getAssocTeacherByClassArmID($classarm->id) as $teacher)
			      	<div class="item">
					    <div class="content">
					      <p class="header">{{$teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename}}</p>
					    </div>
					</div>
			      	@endforeach
			     @else
		            <div class="ui icon negative message">
			          <div class="item">
			              <div class="content">
			                <p class="header">No Class Teacher has assign yet</p>
			              </div>
			          </div>
			        </div>
	            @endif
		      	</div>
		      </td>
		      <td class="std-view">
		      @if(auth('admin')->user()->can('edit-classarm'))
			      <button class="ui labeled blue icon button" data-std-id="{{$classarm->id}}" data-href="{{route('admin.edit.school.classarm', ['id' => $classarm->id])}}">
				  <i class="edit icon"></i>
				  Edit
				</button>
				@endif
			  </td>
		      <td class="std-view">
		      @if(auth('admin')->user()->can('delete-classarm'))
				<button class="ui labeled negative icon button" data-std-id="{{$classarm->id}}" data-href="{{route('admin.delete.school.classarm', ['id' => $classarm->id])}}">
				  <i class="trash icon"></i>
				  Delete
				</button>
				@endif
		      </td>
		    </tr>
		   @endforeach
		    @else
			<tr>
				<th colspan="5">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		  <tfoot>
		    <tr><th colspan="5">
		      @include('pagination.default', ['paginator' => $classarms])
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="{{csrf_token()}}">
	  		<input type="hidden" name="_method" value="delete">
	  		<input type="hidden" name="session" value="{{$session}}">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
@endsection