@extends('layouts.main')

@section('content')
<section class="ui raised segment" style="max-width: 960px; margin: 20px auto;">

		<h2 class="ui horizontal divider header" style="color:#dc4900;">
		  <i class="student icon"></i>
		@if(isset($release_lock))
		  Release Selected Student From
		@else

		  {{!isset($edit) ? 'View' : 'Remove Selected Students From'}} 
		@endif

		  {{getClassNameByClassID($class_id)}} {{getClassArmNameByClassArmID($classarm_id)}} {{$term}} Term {{$session}} / {{($session + 1)}} Session
		  @if(isset($release_lock))
		  	<br><i style="color:red;font-size: 16px;">Note: Students that are not selected their result will be locked</i>
		  @endif
		</h2>
		@include('partial.error')
	  <form action="{{route($route)}}" method="post" class="ui form">
	  	<input type="hidden" name="_token" value="{{csrf_token()}}">
	  	<input type="hidden" name="session" value="{{!empty(old('session')) ? old('session') : $session}}">
	  	<input type="hidden" name="class_id" value="{{!empty(old('class_id')) ? old('class_id') : $class_id}}">
	  	<input type="hidden" name="classarm_id" value="{{!empty(old('classarm_id')) ? old('classarm_id') : $classarm_id}}">
	  	<input type="hidden" name="term" value="{{!empty(old('term')) ? old('term') : $term}}">

	  	@if(!isset($edit) && !isset($release_lock))
		<div class="four fields">
	      <div class="field">
	        <label>Next Session</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="next_session" value="{{old('next_session')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Next Session</div>
	          <div class="menu">
	            @for($i = $session; $i <= (date('Y') + 1) ; $i++)
	             <div class="item" data-value="{{$i}}">{{$i}}/{{$i+1}}</div>
	            @endfor
	          </div>
	        </div>
	      </div>
	      <div class="field">
	        <label>Next Term</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="next_term" value="{{old('next_term')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Next Term</div>
	          <div class="menu">
	             <div class="item" data-value="First"> First Term </div>
	             <div class="item" data-value="Second"> Second Term </div>
	             <div class="item" data-value="Third"> Third Term </div>
	          </div>
	        </div>
	      </div>
	      
	      <div class="field">
	        <label>Next Class</label>
	        <div class="ui fluid search selection dropdown" id="classes-dropdown">
	          <input type="hidden" name="next_class_id" value="{{old('next_class_id')}}" data-href="{{url('/do-ajax/class')}}" >
	          <i class="dropdown icon"></i>
	          <div class="default text">Next Class</div>
	          <div class="menu">
	            @foreach($classes as $class)
	             <div class="item" data-value="{{$class->id}}">{{$class->class_name}}</div>
	            @endforeach
	          </div>
	        </div>
	      </div>
	      <div class="field" id="field-arms">
	        <label>Next Class Arm</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="next_classarm_id" value="{{old('next_classarm_id')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Next Class Arm</div>
	          <div class="menu" id="class-arms">
	            @if(!empty(old('next_class_id')))
	                @foreach(getClassArms(old('next_class_id')) as $class_arm)
	                 <div class="item" data-value="{{$class_arm->id}}">{{$class_arm->class_arm}}</div>
	                @endforeach
	              @else
	                 <div class="item" data-value="">Select Class Arm</div>
	              @endif
	            
	          </div>
	        </div>
	      </div>

	    </div>
	    @endif
		<table class="ui celled table">
		  <thead>
		    <tr>
		    <th>
		    	<div class="ui ribbon label">Student's Fullname</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Registration Number</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Student's Passport</div>
		    </th>
		    <th >
		    	<div class="ui ribbon label">Select Students</div>
		    	<div class="ui toggle checkbox check-all">
					<input type="checkbox" class="">
					<label>Select All</label>
				</div>
		    </th>
		  </tr></thead>
		  <tbody>
		  @if(count($classarm_students) > 0)
		  	@foreach($classarm_students as $student)
		    <tr>
		      <td>{{$student->surname.' '.$student->firstname.' '.$student->middlename}}</td>
		      <td>{{$student->regnum}}</td>
		      <td><img src="{{env('APP_URL').$student->passport}}" class="ui image"></td>
		      <td class="std-view">
			     <div class="ui toggle checkbox studentID">
					<input type="checkbox" name="student_id[]" value="{{$student->id}}"><label></label>
				</div>
			  </td>
		    </tr>
		   @endforeach
		    @else
			<tr>
				<th colspan="4">
					<div class="ui icon negative message">
					  <i class="info circle icon"></i>
					  <div class="content">
					    <div class="header">
					    Sorry, No Record can be found.
					  	</div>
					  </div>
					 </div>
				</th>
			</tr>
		  @endif
		  </tbody>
		</table>
		@if(isset($release_lock))
		<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Release or Lock Selected Student Result</button>
		@elseif(!isset($edit))
		<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Move Students to Next {{ in_array($term, ['First', 'Second']) == true ? 'Term' : 'Class'}}</button>
		@else
			<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;">Remove Selected Students</button>
		@endif
	</form>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="{{csrf_token()}}">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
@endsection