@extends('layouts.main')
@section('content')
<section style="max-width: 800px; margin: 20px auto">
  <h2 class="ui horizontal divider header" style="color:#dc4900;">
      <i class="student icon"></i>
      Assign Subjects and Subject Teacher To Class
    </h2>
<form class="ui form" method="post" action="{{route('admin.assign.subject.to.class.submit')}}">
  <input type="hidden" name="class_id" value="class_id">
  <input type="hidden" name="session" value="{{$request->session}}">
  <input type="hidden" name="classarm_id" value="{{$request->classarm_id}}">
  <input type="hidden" name="_token" value="{{csrf_token()}}">
    <table class="ui celled table">
      <thead>
       <tr>
        <th>
          <div class="ui ribbon label">Subjects</div>
        </th>
        <th>
          <div class="ui ribbon label">Teachers</div>
        </th>
      </tr>
      </thead>
      <tbody>
      @foreach()
        <tr class="added-row">
          <td>
            <div class="field">
            <div class="ui fluid search selection dropdown wrap-subject">
              <input type="hidden" name="subject_id[]" value="{{old('subject_id')}}" data-href="{{url('/do-ajax/subject')}}">
              <i class="dropdown icon"></i>
              <div class="default text">Select Subject</div>
              <div class="menu">
                @foreach($subjects as $subject)
                 <div class="item" data-value="{{$subject->id}}">{{$subject->subject_name .'( '. $subject->class_category.' )'}}</div>
                @endforeach
              </div>
            </div>
        </div>
          </td>
          <td>
           <div class="field wrap-teacher">
             <select multiple="" class="ui dropdown" name="subject_teachers[]" >
             </select>
          </div>
          </td>
          </tr>
    @endforeach
      </tbody>
      <tfoot>
      <tr>
        <td colspan="2" style="border-top: 1px solid rgba(34, 36, 38, 0.1);" class="subject-action">
          <button class="ui labeled blue icon button right floated" type="button"> <i class="edit icon"></i>Add Subject</button>
          <button class="ui labeled negative icon button right floated" type="button"> <i class="trash icon"></i>Delete Subject</button>
        </td>
      </tr>
      <tr>
          <td colspan="2">
            <button class="ui orange fluid button" type="submit"> Assign Subjects to Class </button>
          </td>
      </tr>
      </tfoot>
    </table>
</form>
</section>
@endsection