@extends('layouts.main')
@section('content')

<section class="ui raised segment" style="max-width: 1200px; margin: 20px auto;">
		@include('partial.error')
		<form class="ui form" action="" method="post" enctype="multipart/form-data">
			<input type="hidden" name="_token" value="{{csrf_token()}}">
		  <h2 class="ui dividing header">Search Registered Students</h2>
		  <div class="five fields">
	      <div class="field">
	        <label>Session</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="session" value="{{old('session')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Session</div>
	          <div class="menu">
	            @for($i = 2010; $i <= (date('Y') + 1) ; $i++)
	             <div class="item" data-value="{{$i}}">{{$i}}/{{$i+1}}</div>
	            @endfor
	          </div>
	        </div>
	      </div>
	      <div class="field">
	        <label>Term</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="term" value="{{old('term')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Term</div>
	          <div class="menu">
	             <div class="item" data-value="First"> First Term </div>
	             <div class="item" data-value="Second"> Second Term </div>
	             <div class="item" data-value="Third"> Third Term </div>
	          </div>
	        </div>
	      </div>
	      
	      <div class="field">
	        <label>Class</label>
	        <div class="ui fluid search selection dropdown" id="classes-dropdown">
	          <input type="hidden" name="class_id" value="{{old('class_id')}}" data-href="{{url('/do-ajax/class')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Class</div>
	          <div class="menu">
	            @foreach($classes as $class)
	             <div class="item" data-value="{{$class->id}}">{{$class->class_name}}</div>
	            @endforeach
	          </div>
	        </div>
	      </div>
	      <div class="field" id="field-arms">
	        <label>Class Arm</label>
	        <div class="ui fluid search selection dropdown">
	          <input type="hidden" name="class_arm_id" value="{{old('class_arm_id')}}">
	          <i class="dropdown icon"></i>
	          <div class="default text">Class Arm</div>
	          <div class="menu" id="class-arms">
	            @if(!empty(old('class_id')))
	                @foreach(getClassArms(old('class_id')) as $class_arm)
	                 <div class="item" data-value="{{$class_arm->id}}">{{$class_arm->class_arm}}</div>
	                @endforeach
	              @else
	                 <div class="item" data-value="">Select Class Arm</div>
	              @endif
	            
	          </div>
	        </div>
	      </div>

	      <div class="field">
	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">View Students</button>
	      </div>

	    </div>
		  
		</form>
		<h2 class="ui horizontal divider header" style="color:#dc4900;">
			<i class="trash icon"></i>
		  Batch Student Delete
		</h2>
		<table class="ui celled table">
		  <thead>
		    <tr>

		    <th>
		    	<div class="ui ribbon label">S/N</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">Student's Fullname</div>
		    </th>
		    <th>
		    	<div class="ui ribbon label">OSSI Number</div>
		    </th>
		    <th colspan="2">
					<div class="ui toggle checkbox check-all">
						<input type="checkbox" class="">
						<label>Select All</label>
					</div>
		    </th>
		  </tr>
		  </thead>
			<form action="{{route('admin.post.studentblukdelete')}}" method="post">
				{{csrf_field()}}
				<tbody>
					@if(count($students) > 0)
						@php $page = (isset($_GET['page'])) ? ((int)$_GET['page'] - 1) : 0; $counter = $page * $students->perPage() @endphp
						@foreach($students as $student)
						<tr>
							<td>{{++$counter}}</td>
							<td>{{$student->surname.' '.$student->firstname.' '.$student->middlename}}</td>
							<td>{{$student->regnum}}</td>
							<td class="std-view">
								<div class="ui toggle checkbox studentID">
									<input type="checkbox" name="student_id[]" class="formCheckbox" value="{{$student->id}}" @if(!empty(old('student_id'))){{in_array($student->id, old('student_id')) ? 'checked="checked"' : ''}}@endif><label></label>
								</div>
							</td>
						</tr>
					@endforeach
						@else
					<tr>
						<th colspan="6">
							<div class="ui icon negative message">
								<i class="info circle icon"></i>
								<div class="content">
									<div class="header">
										Please select students to delete
									</div>
								</div>
							</div>
						</th>
					</tr>
					@endif
					<tr>
						<td colspan="7">
							<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;padding: 10px !important;">Delete Students</button>
						</td>
					</tr>
				</tbody>
			</form>
		  <tfoot>
		    <tr><th colspan="6">
		      @include('pagination.default', ['paginator' => $students])
		    </th>
		  </tr></tfoot>
		</table>
	</section>
	<div class="ui modal" id="edit">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<a href="" class="ui approve blue button">Edit</a>
	  </div>
	</div>

	<div class="ui modal" id="delete">
	  <div class="header">Header</div>
	  <div class="image content">
		<img class="ui avatar image" src="">
	    <div class="description">

	    </div>
	  </div>
	  <div class="actions">
	    <div class="ui cancel button">Cancel</div>
	  	<form action="" method="post" style="display:inline-block;">
	  		<input type="hidden" name="_token" value="{{csrf_token()}}">
	  		<input type="hidden" name="_method" value="delete">
	  		<button type="submit" class="ui approve negative button">Delete</button>
	  	</form>
	  </div>
	</div>
@endsection