@extends('layouts.main')
@section('content')
<br>
<section class="ui raised segment" style="max-width: 1200px; margin: 20px auto;">
	<h2 class="ui horizontal divider cap header" style="color:#dc4900;">
	  Annual Assessment
	</h2>
	<!-- ui stackable equal height stackable grid -->
	<div class="grid">
		<div class="shadowundertop"></div>
		<div class="row">
			<div class="c8">
                <div class="ui grid">
                    <div class="four wide column">
                        <div class="ui vertical fluid tabular menu">
                        <a href="{{url('admin/school-annual-asset')}}" class="item @if(!isset($_GET['action']) || $_GET['action'] == '') active @endif">
                        	Upload Assessment
                        </a>
                        <a href="{{url('admin/school-annual-asset?action=edit')}}" class="item @if(isset($_GET['action']) && $_GET['action'] == 'edit') active @endif">
                            Edit Assessments
                        </a>
                        </div>
                    </div>
                    <div class="twelve wide stretched column">
                        <div class="ui segment">
                            @if(isset($_GET['action']) && $_GET['action'] == 'edit')
                            	<div class="new">
                            	@if($school->assessment->count() > 0)
                            	    <div class="ui cards">
                                	@foreach($school->assessment as $assessment)
                                		@php
                                			$des = '/'.$assessment->path; 
                                		@endphp
                                		@if(file_exists(public_path($des)))
                            			<input type="file" onchange="saveMultipleImages(this, '{{$assessment->session}}', '{{$assessment->id}}')" name="path[]" class="file___multipleImagesInput{{$assessment->session}}" style="display: none;" multiple  accept="image/*">
                                        <div class="card assessment--card--{{$assessment->session}}">
                                            <div class="content">
                                              <img class="right floated mini ui image" src="{{url_public('/images/annual-stats.png')}}">
                                              <div class="header">{{$assessment->session}}/{{$assessment->session+1}}</div>
                                              <div class="meta">
                                                Assessment
                                              </div>
                                              <div class="data-images-{{$assessment->session}}" style="display: none;">
                                              	{{App\AssessmentImage::where('assessment_id', $assessment->id)->orderBy('id', 'desc')->get()}}
                                              </div>
                                            </div>
                                            <div class="extra content">
                                              <div class="ui two buttons">
                                                <div class="ui basic orange button preview___btn" 
                                                data-session="{{$assessment->session}}"
                                                data-download="{{url_public($des)}}" 
                                                data-url="{{url('/admin/school-annual-asset-doc-preview')}}/{{$assessment->session}}">Preview</div>
                                                <div class="ui basic blue button edit___btn" data-id="{{$assessment->id}}" data-session="{{$assessment->session}}">Edit</div>
                                              </div>
                                            </div>
                                        </div>
                                        @endif
                        	        @endforeach
                                    </div>
                                @else
                                <div class="ui negative message">
									<i class="close icon"></i>
									<div class="header">
										Opps!
									</div>
									<p>
										No assessment uploaded
									</p>
								</div>
								@endif
                            	</div>
                            @else
                            <div class="new">
                                <div class="ui yellow message">
									<i class="close icon"></i>
									<div class="header">
										Please note!
									</div>
									<p>
										Only documents with the .doc extension can be uploaded
									</p>
								</div>
								<a href="{{url_public('exceluploads/DATA-TEMPLATE-ANNUAL-ASSET-FORM.doc')}}" class="ui button blue" download>Download Annual Assessment Template</a>
								<br>

                                <form class="ui form" action="" method="post" enctype="multipart/form-data">
                        			<input type="hidden" name="_token" value="{{csrf_token()}}">
                        			<input type="hidden" name="type" value="create">
                        		  <h2 class="ui dividing header">Search Students</h2>
                        		  <div class="three fields">
                        	      <div class="field">
                        	        <label>Session</label>
                        	        <div class="ui fluid search selection dropdown">
                        	          <input type="hidden" name="session" value="{{old('session')}}" required>
                        	          <i class="dropdown icon"></i>
                        	          <div class="default text">Session</div>
                        	          <div class="menu">
                        	            @for($i = 2018; $i <= date('Y'); $i++)
                        	             <div class="item" data-value="{{$i}}">{{$i}}/{{$i+1}}</div>
                        	            @endfor
                        	          </div>
                        	        </div>
                        	      </div>
                        	      <div class="field">
                        	      	<label>Upload File <span class="is_valid" style="color: green;display: none;"><i class="icon check"></i></span></label>
                        	      	<div class="ui action input" onclick="triggerFileInput();" style="cursor: pointer;">
										<input type="text" placeholder="Select Doc File" readonly style="pointer-events: none;">
										<div class="ui icon button">
											<i class="file icon"></i>
										</div>
									</div>
									<input type="file" class="file___input" style="visibility: hidden;" onchange="validateFile(this);" name="file" required>
                        	      </div>
                        	      <div class="field">
                        	      	<button class="fluid ui button" type="submit" style="background-color: #f75a0c; color:white;margin-top:24px;">Upload Assessment</button>
                        	      </div>
                        
                        	    </div>
                        		  
                        		</form>
                                <br>
                            @endif
                        </div>
                    </div>
                </div>
			</div>
		</div>	
	</div>
</section>
<style>
.ext{
    width: 100% !important;
}
.ext .card{
    width: 100% !important;
}
.ext .card .item{
    text-align: left;
    padding: 13px;
}
.ext .card .content{
    text-align: right;
    float: right;
}
</style>
<script type="text/javascript">
	$(function(){
		$('.ui.popup').popup();
		// prev
		$('.preview___btn').each(function(){
			$(this).popup({
	            trigger: 'click, focus',
	    		hoverable  : true,
	            html: `
	            	<a href="${$(this).attr('data-url')}" target="_blank" class="ui icon button green outline" data-tooltip="Preview Assessment Document" data-position="bottom center">
					  <i class="eye icon"></i>
					</a>
					<a href="${$(this).attr('data-download')}" class="ui icon button orange outline" data-tooltip="Download Assessment Document" data-position="bottom center" download>
					  <i class="file icon"></i>
					</a>
					<a onclick="previewAssessmentImages(this)" data-session="${$(this).attr('data-session')}" class="ui icon button blue outline" data-tooltip="Preview Assessment Images" data-position="bottom center">
					  <i class="image icon"></i>
					</a>
	            `,
	            position: 'bottom center',
	        });
		});

        // edit
		$('.edit___btn').each(function(){
			$(this).popup({
	            trigger: 'click, focus',
	    		hoverable  : true,
	            html: `
	            	<div style="display:flex;">
	            		<div style="">
			            	<div>
				            	<button type="button" onclick="triggerMultipleImagesInput(${$(this).attr('data-session')})" class="ui icon button blue outline" data-tooltip="Attach Muliple Images" data-position="bottom center">
								  <i class="camera icon"></i>
								</button>
							</div>
						</div>
						<div style="">
			            	<form method="POST">
				            	<input type="hidden" name="_token" value="{{csrf_token()}}">
		                        <input type="hidden" name="type" value="delete">
		                        <input type="hidden" name="session" value="${$(this).attr('data-session')}">
				            	<button type="submit" class="ui icon button red outline" data-tooltip="Delete Assessment" data-position="bottom center">
								  <i class="trash icon"></i>
								</button>
							</form>
						</div>
					</div>
	            `,
	            position: 'bottom center',
	        });
		});
	});
	function triggerFileInput(){
		$('.file___input').trigger('click');
	}
	function triggerMultipleImagesInput(session){
		$('.file___multipleImagesInput'+session).trigger('click');
	}
	function saveMultipleImages(obj, session, assessment_id){
		var input,shell,form;
		input = $(obj);
		shell = $('.assessment--card--'+session);
		shell.popup({
    		hoverable  : true,
            html: `
            	Uploading resource...
            `,
            hideOnScroll: false,
            position: 'right center',
        });
        shell.popup('show');

        // submit form
        form = $("<form method='POST' action='' onsubmit='saveMultipleImagesRequest(this);' enctype='multipart/form-data'></form>");
        form.append('<input type="hidden" name="_token" value="{{csrf_token()}}">');
        form.append('<input type="hidden" name="type" value="attach">');
        form.append('<input type="hidden" name="session" value="'+session+'">');
        form.append('<input type="hidden" name="assessment_id" value="'+assessment_id+'">');
        // clone input into new form
        form.append($('.file___multipleImagesInput'+session).clone());
		form.submit();
        console.log('submit!');
	}
	function saveMultipleImagesRequest(obj){
		console.log('submited!');
		var form = $(obj);
		var action = form.attr('action');
		var session = form.find('input[name=session]').val();
		var data = new FormData(form [0]);
		var shell = $('.assessment--card--'+session);
		$.ajax({
			url: action,
			type: 'POST',
			data: data,
			processData: false,
			contentType: false,
			success: function(res){
				shell.popup({
		    		hoverable  : true,
		    		hideOnScroll: true,
		            html: `
		            	<i class="icon check" style="font-size:25px;text-align:center;color:green;"></i>
		            	<br>
		            	<span style="color: green;">Upload Completed!</span>
		            `,
		            position: 'right center',
		        });
		        shell.popup('show');
			},
			error: function(err){
				shell.popup({
		    		hoverable  : true,
		    		hideOnScroll: true,
		            html: `
		            	<i class="icon close" style="font-size:25px;text-align:center;color:red;"></i>
		            	<br>
		            	<span style="color: red;">Upload Failed!</span>
		            `,
		            position: 'right center',
		        });
		        shell.popup('show');
			}
		});
	}
	function previewAssessmentImages(obj){
		var item = $(obj);
		var session = item.attr('data-session');
		var images_raw = $('.data-images-'+session).html();
		var images = JSON.parse(images_raw);
		var shell = $('.assessment--card--'+session);
		console.log(images);
		shell.popup({
    		hoverable  : true,
    		hideOnScroll: false,
            html: `
            	<div class="ui">
                    ${(() => {
                    if(images.length){
                        $com = '';
                        $.each(images, function(index, val){
                        	console.log('{{url_public('')}}'+val.path);
                            $com += `

			            	<form method="POST">
				            	<input type="hidden" name="_token" value="{{csrf_token()}}">
		                        <input type="hidden" name="type" value="delete_image">
		                        <input type="hidden" name="id" value="${val.id}">
	                            <div class="ui feed">
								  <div class="event" style="display: flex !important;">
								    <div class="label" style="align-self: center !important;">
								      <img src="{{url_public('')}}${val.path}" style="width:30px;height:30px;">
								    </div>
								    <div class="content" style="display: flex !important;">
								      	<div style="margin-right:5px;">${diffForHumans(val.created_at)} </div>
								      	<div>
									      	<button type="submit" class="ui button red"><i class="trash icon"></i></button>
										</div>
								    </div>
								  </div>
								</div>
							</form>
                            `;
                        });
                        return $com
                    }else{
                        return `<small style="color: red;">No available image</small>`
                    }
                    })()}
				</div>
            `,
            position: 'right center',
        });
        shell.popup('show');
	}
	function diffForHumans(time){
       // Adjust for milliseconds
        var date = new Date((time || "").replace(/-/g, "/").replace(/[TZ]/g, " ")),
        diff = (((new Date()).getTime() - date.getTime()) / 1000),
        day_diff = Math.floor(diff / 86400);

        // if (isNaN(day_diff) || day_diff < 0 || day_diff >= 31) return;

        return day_diff == 0 && (
        diff < 60 && "just now" || diff < 120 && "1 min ago" || diff < 3600 && Math.floor(diff / 60) + " mins ago" || diff < 7200 && "1 hr ago" || diff < 86400 && Math.floor(diff / 3600) + " hrs ago") || day_diff == 1 && "Yesterday" || day_diff < 7 && day_diff + " days ago" || day_diff < 31 && Math.ceil(day_diff / 7) + " weeks ago";
    }
	function validateFile(obj){
		var myfile;
		myfile = $(obj).val();
		var ext = myfile.split('.').pop();
		// if(ext=="pdf" || ext=="docx" || ext=="doc"){ 
		if(ext != "doc"){
			alert("Please select '.doc' file only!");
			myfile.val('');
		    $('.is_valid').fadeOut();
		}else{
		    $('.is_valid').fadeIn();
		}
	}
</script>
@endsection