<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted'             => 'The :attribute must be accepted.',
    'active_url'           => 'The :attribute is not a valid URL.',
    'after'                => 'The :attribute must be a date after :date.',
    'alpha'                => 'The :attribute may only contain letters.',
    'alpha_dash'           => 'The :attribute may only contain letters, numbers, and dashes.',
    'alpha_num'            => 'The :attribute may only contain letters and numbers.',
    'array'                => 'The :attribute must be an array.',
    'before'               => 'The :attribute must be a date before :date.',
    'between'              => [
        'numeric' => 'The :attribute must be between :min and :max.',
        'file'    => 'The :attribute must be between :min and :max kilobytes.',
        'string'  => 'The :attribute must be between :min and :max characters.',
        'array'   => 'The :attribute must have between :min and :max items.',
    ],
    'boolean'              => 'The :attribute field must be true or false.',
    'confirmed'            => 'The :attribute confirmation does not match.',
    'date'                 => 'The :attribute is not a valid date.',
    'date_format'          => 'The :attribute does not match the format :format.',
    'different'            => 'The :attribute and :other must be different.',
    'digits'               => 'The :attribute must be :digits digits.',
    'digits_between'       => 'The :attribute must be between :min and :max digits.',
    'distinct'             => 'The :attribute field has a duplicate value.',
    'email'                => 'The :attribute must be a valid email address.',
    'exists'               => 'The selected :attribute is invalid.',
    'filled'               => 'The :attribute field is required.',
    'image'                => 'The :attribute must be an image.',
    'in'                   => 'The selected :attribute is invalid.',
    'in_array'             => 'The :attribute field does not exist in :other.',
    'integer'              => 'The :attribute must be an integer.',
    'ip'                   => 'The :attribute must be a valid IP address.',
    'json'                 => 'The :attribute must be a valid JSON string.',
    'max'                  => [
        'numeric' => 'The :attribute may not be greater than :max.',
        'file'    => 'The :attribute may not be greater than :max kilobytes.',
        'string'  => 'The :attribute may not be greater than :max characters.',
        'array'   => 'The :attribute may not have more than :max items.',
    ],
    'mimes'                => 'The :attribute must be a file of type: :values.',
    'min'                  => [
        'numeric' => 'The :attribute must be at least :min.',
        'file'    => 'The :attribute must be at least :min kilobytes.',
        'string'  => 'The :attribute must be at least :min characters.',
        'array'   => 'The :attribute must have at least :min items.',
    ],
    'not_in'               => 'The selected :attribute is invalid.',
    'numeric'              => 'The :attribute must be a number.',
    'present'              => 'The :attribute field must be present.',
    'regex'                => 'The :attribute format is invalid.',
    'required'             => 'The :attribute field is required.',
    'required_if'          => 'The :attribute field is required when :other is :value.',
    'required_unless'      => 'The :attribute field is required unless :other is in :values.',
    'required_with'        => 'The :attribute field is required when :values is present.',
    'required_with_all'    => 'The :attribute field is required when :values is present.',
    'required_without'     => 'The :attribute field is required when :values is not present.',
    'required_without_all' => 'The :attribute field is required when none of :values are present.',
    'same'                 => 'The :attribute and :other must match.',
    'size'                 => [
        'numeric' => 'The :attribute must be :size.',
        'file'    => 'The :attribute must be :size kilobytes.',
        'string'  => 'The :attribute must be :size characters.',
        'array'   => 'The :attribute must contain :size items.',
    ],
    'string'               => 'The :attribute must be a string.',
    'timezone'             => 'The :attribute must be a valid zone.',
    'unique'               => 'The :attribute has already been taken.',
    'url'                  => 'The :attribute format is invalid.',
    // Customized Error Validation

    'unique_first_and_last_name' => 'You have aleady register the student',

    'allowexts' => 'The :attribute must be csv, xls, xlsx.',

    'excel_format_allowed' => 'The wrong file is being uploaded',

    'unique_classarm_in_class' => 'The Class Arm already exit in the Class',



    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        // 'attribute-name' => [
        //     'rule-name' => 'custom-message',
        // ],
        'lga_id' => [
            'required' => 'The State Local Government Area field is required',
            'integer' => 'The State Local Government Area selected is not valid',
            'not_in' => 'You have not selected any State Local Government Area'
            ],
        'state_id' => [
            'required' => 'The State field is required',
            'integer' => 'The State selected is not valid',
            'not_in' => 'You have not selected any State'
            ],
        'parent_phone' => [
            'regex' => 'The parent or guardian phone number should start with 234'
            ],
        'phone' => [
            'regex' => 'The Phone number should start with 234'
            ],
        'next_of_kins_phone' => [
            'regex' => 'The parent or guardian phone number should start with 234'
            ],
        'next_of_kins' => [
                'required' => 'The Next of Kins fullname field is required'
                ],
        'class_id' => [
                'required' => 'The Class field is required',
                'integer' => 'The Class selected is not valid'
                ],
        'next_class_id' => [
                'required' => 'The Class field is required',
                'integer' => 'The Class selected is not valid'
                ],
        'class_arm_id' => [
                'required' => 'The Class Arm field is required',
                'integer' => 'The Class Arm selected is not valid'
                ],
        'classarm_id' => [
                'required' => 'The Class Arm field is required',
                'integer' => 'The Class Arm selected is not valid'
                ],
        'next_classarm_id' => [
                'required' => 'The Class Arm field is required',
                'integer' => 'The Class Arm selected is not valid'
                ],
        'pseudo_batch_file_name' => [
                'required' => 'You have not choosen a file to upload'
                ],
        'student_id' => [
                'required' => 'You have not selected any student'
                ],
        'transfer_school_id' => [
                'required' => 'You have not selected any School to be transfered'
                ],
        'house_id' => [
                'required' => 'Sorry, You need to select School House'
                ],
        'login_type' => [
                'required' => 'Sorry, The login Type is required',
                'regex' => 'Sorry, You can either login with your Card or Examination Number and Password'
                ]


    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap attribute place-holders
    | with something more reader friendly such as E-Mail Address instead
    | of "email". This simply helps us make messages a little cleaner.
    |
    */

    'attributes' => [],

];
