<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class UnityHallAllocation extends Model
{
    protected $table = 'umity_hall_allocation';

    protected $fillable = ['candidate_id', 'exam_center_lga_id', 'session', 'school_center_id'];

    public function unity_exam(){
    	return $this->belongsTo('App\UnityExam', 'candidate_id');
    }

    public function ondo_lga(){
    	return $this->belongsTo('App\OndoLGA', 'exam_center_lga_id');
    }

    public function center(){
    	return $this->belongsTo('App\AdminUnityHallAllocation', 'hall_id');
    }
}
