<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class StudentResult extends Model
{
    protected $table = 'student_results';

    protected $fillable = [
    	'student_id',
		'subject_id',
		'ca_score',
		'exam_score',
		'weighted_average',
		'grade',
		'remarks',
		'status',
		'session',
		'term',
		'class_id',
		'classarm_id',
		'school_id'
    ];

    public static $ruleForSubjects = [
		'class_id' => 'required|integer',
		'session' => 'required|digits:4',
		'class_arm_id' => 'required|integer',
		'term' => ['required','regex:/(First|Second|Third)/']
	];

	public static $ruleForResultUpdate = [
		'class_id' => 'required|integer',
		'session' => 'required|digits:4',
		'classarm_id' => 'required|integer',
		'term' => ['required','regex:/(First|Second|Third)/'],
		'ca' => 'required|array',
		'exam' => 'required|array',
		'subject_id' => 'required|array',
		'student_id' => 'required|integer',
	];

    public function students(){

    	return $this->belongsTo('App\Student', 'student_id');

    }  

}
