<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

use Validator;

use Excel;

use Input;

use DB;

use App\Student;

use App\ClassArms;

use Session;

use App\StudentHouse;

use App\ResultVoucher;

use App\ExamsVouchers;

use App\Agent;

use App\UnityExam;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        //

        

        Validator::extend('uniqueFirstAndLastName', function ($attribute, $value, $parameters, $validator) {

            $count = Student::where('parent_email','=', $value)
                                ->where('surname','=', array_get($validator->getData(),$parameters[0], null))
                                ->where('firstname','=', array_get($validator->getData(),$parameters[1], null))
                                ->where('session','=', array_get($validator->getData(),$parameters[2], null))
                                ->where('school_id','=', Session::get('admin.school'))
                                ->count();

            return $count === 0;

        });

        Validator::extend('card_used', function ($attribute, $value, $parameters, $validator) {

            $count = ExamsVouchers::where('serial','=', $value)
                                ->where('pin','=', Input::get('pin'))
                                ->first();

            return $count->regnum === null;

        });

        Validator::replacer('card_used', function($message, $attribute, $rule, $parameters) {
        return "Sorry, The Card has already been used";
        });

        Validator::extend('pin_and_serial_validate', function ($attribute, $value, $parameters, $validator) {

            $count = ResultVoucher::where('serial','=', $value)
                                ->where('pin','=', Input::get('pin'))
                                ->count();

            return $count > 0;

        });

        Validator::replacer('pin_and_serial_validate', function($message, $attribute, $rule, $parameters) {

         return "Sorry, Either the PIN or Serial Number is incorrect";

        });

        Validator::extend('card_validation', function ($attribute, $value, $parameters, $validator) {

            $count = ExamsVouchers::where('pin','=', $value)
                                ->where('serial','=', Input::get('serial_no'))
                                ->where('exam_type', '=', Input::get('exam_type'))
                                ->count();

            return $count > 0;

        });

        Validator::replacer('card_validation', function($message, $attribute, $rule, $parameters) {
            return "Sorry, Either the PIN or Serial Number is incorrect";
        });

         Validator::extend('school_verify', function ($attribute, $value, $parameters, $validator) {

            $count = DB::table($parameters[0])->where('pin','=', $value)
                                ->where('serial','=', Input::get('serial_no'))
                                ->where('exam_type', '=', Input::get('exam_type'))
                                ->where('regnum', '=', $parameters[1])
                                ->count();

            return $count > 0;

        });

        Validator::replacer('school_verify', function($message, $attribute, $rule, $parameters) {
            return "Sorry, Voucher has not being link to the school";
        });

        Validator::extend('card_used_status', function ($attribute, $value, $parameters, $validator) {

            $count = UnityExam::where('pin','=', $value)
                                ->where('serial','=', Input::get('serial_no'))
                                ->count();

            return $count > 0;

        });

        Validator::replacer('card_used_status', function($message, $attribute, $rule, $parameters) {
            $voucher = UnityExam::where('pin','=', Input::get('pin'))
                                ->where('serial','=', Input::get('serial_no'))
                                ->first();

            $count = ExamsVouchers::where('pin','=', Input::get('pin'))
                                ->where('serial','=', Input::get('serial_no'))
                                ->where('exam_type', '=', Input::get('exam_type'))
                                ->count();

            if($count > 0){
                
                return "Sorry, You have not register student with this card";
            }

            return "Invalid Card";

        });



        Validator::extend('school_house_check', function ($attribute, $value, $parameters, $validator) {

            if(Input::has('school')){
                $school = Input::get('school');
            }else{
                $school = Session::get('admin.school');
            }

            $sql_where = "name = '$value' AND school_id = '$school'";

            if(count($parameters) > 0){
                $sql_where .= " AND id != '".$parameters[0]."'";
            }

            $count = StudentHouse::whereRaw($sql_where)
                                ->count();

            return $count === 0;

        });

        Validator::replacer('school_house_check', function($message, $attribute, $rule, $parameters) {

            return "Sorry, School House has already been registered in the school";

        });


        Validator::extend('agent_validation', function ($attribute, $value, $parameters, $validator) {

            $count = Agent::where('access','=', $value)
                                ->count();

            return $count > 0;

        });

        Validator::replacer('agent_validation', function($message, $attribute, $rule, $parameters) {
            return "Sorry, You are not permitted to register student for exams";
        });

        
        Validator::extend('uniqueClassarmInClass', function ($attribute, $value, $parameters, $validator) {

            $count = ClassArms::where('class_arm','=', $value)
                                ->where('class_id','=', array_get($validator->getData(),$parameters[0], null))
                                ->count();

            return $count === 0;

        });



        Validator::extend('allowexts', function($attribute, $value, $parameters, $validator){

            $filename = array_get($validator->getData(),$attribute, null);

            $ext = strtolower(substr($filename,strrpos($filename, '.') + 1));

           return in_array($ext, $parameters);

        });

        Validator::extend('exam_number_exist', function($attribute, $value, $parameters, $validator){

            $count = DB::table($parameters[0])->where('regnum', '=', $value)->count();

            if($count > 0){
                return true;
            }

            return false;

        });

        Validator::replacer('exam_number_exist', function($message, $attribute, $rule, $parameters) {

            return "You need to create Examination Number before creating Password";

        });

        

        Validator::extend('excelFormatAllowed', function($attribute, $value, $parameters, $validator){

                 $excelColumns = 0;

                $path = Input::file('batch_file')->getRealPath();

                $data = Excel::load($path, function($reader) use (&$excelColumns) {

                    $objExcel = $reader->getExcel();

                    $sheet = $objExcel->getSheet(0);

                    $highestColumn = $sheet->getHighestColumn();

                    $alpha = range('A', 'Z');

                    $excelColumns =  (array_flip($alpha)[$highestColumn] + 1);

                });

               return $excelColumns == (int)$parameters[0];
        });

        Validator::extend('school_check', function ($attribute, $value, $parameters, $validator) {

            if(Input::has('school')){
                $school = Input::get('school');
            }else{
                $school = Session::get('admin.school');
            }
            $count = StudentHouse::where('school_id','=', $school)
                                ->count();

            return $count > 0;

        });

        Validator::replacer('school_check', function($message, $attribute, $rule, $parameters) {
        return "You have to create school houses to use the student batch upload section";
        });

        Validator::extend('img_min_size', function($attribute, $value, $parameters)
        {
            $file = Input::file($attribute);
            $image_info = getimagesize($file);
            $image_width = $image_info[0];
            if( (isset($parameters[0]) && $parameters[0] != 0) && $image_width < $parameters[0]) return false;
            return true;
        });

        Validator::replacer('img_min_size', function($message, $attribute, $rule, $parameters) {
        return "Your passport width must be larger than ".$parameters[0]."px";
        });


        Validator::extend('next_term_class_verification', function ($attribute, $value, $parameters, $validator) {

            switch (array_get($validator->getData(),$parameters[0], null)) {
                case 'First':
                            if($value == 'Second'){
                                if(array_get($validator->getData(),$parameters[1], null) != array_get($validator->getData(),$parameters[2], null)){
                                    return false;
                                }

                                if(array_get($validator->getData(),$parameters[3], null) != array_get($validator->getData(),$parameters[4], null)){
                                    return false;
                                }

                                return true;

                            }else{
                                return false;
                            }

                break;

                case 'Second':
                        if($value == 'Third'){
                            if(array_get($validator->getData(),$parameters[1], null) != array_get($validator->getData(),$parameters[2], null)){
                                return false;
                            }

                            if(array_get($validator->getData(),$parameters[3], null) != array_get($validator->getData(),$parameters[4], null)){
                                return false;
                            }

                            return true;

                        }else{
                            return false;
                        }

                break;

                case 'Third':
                        if($value == 'First'){
                            if(array_get($validator->getData(),$parameters[1], null) == array_get($validator->getData(),$parameters[2], null)){
                                return true;	// Student set to REPEAT
                            }
                            if(array_get($validator->getData(),$parameters[1], null) != array_get($validator->getData(),$parameters[2], null)){
                                return true;	// Student set to PROMOTE
                            }

                            if((array_get($validator->getData(),$parameters[3], null) + 1) != array_get($validator->getData(),$parameters[4], null)){
                                return false;
                            }

                            return true;

                        }else{
                            return false;
                        }

                break;
                default:
                    return true;
                break;
            }

        });


        Validator::replacer('next_term_class_verification', function ($message, $attribute, $rule, $parameters) {

            switch (Input::get($parameters[0])) {
                case 'First':
                            if(Input::get($attribute) == 'Second'){
                                if(Input::get($parameters[1]) != Input::get($parameters[2]))
                                {
                                    return "Sorry, the next class should be ".getClassArmNameByClassArmID(Input::get($parameters[1])) ;
                                }

                                if(Input::get($parameters[3]) != Input::get($parameters[4]))
                                {
                                    return "Sorry, the session should be ".Input::get($parameters[3]).'/'.(Input::get($parameters[3]) +1);
                                }

                            }else{
                                return "Sorry, the next term is Second Term";
                            }

                break;

                case 'Second':
                        if(Input::get($attribute) == 'Third'){
                                if(Input::get($parameters[1]) != Input::get($parameters[2]))
                                {
                                    return "Sorry, the next class should be ".getClassArmNameByClassArmID(Input::get($parameters[1])) ;
                                }

                                if(Input::get($parameters[3]) != Input::get($parameters[4]))
                                {
                                    return "Sorry, the session should be ".Input::get($parameters[3]).'/'.(Input::get($parameters[3]) +1);
                                }

                            }else{
                                return "Sorry, the next term is Third Term";
                            }

                break;

                case 'Third':
                        if(Input::get($attribute) == 'First'){
                                if(Input::get($parameters[1]) != Input::get($parameters[2]))
                                {
                                    return "Sorry, the next class should not be ".getClassArmNameByClassArmID(Input::get($parameters[1])) ;
                                }

								if(Input::get($parameters[3]) != Input::get($parameters[4]))
                                {
                                    return "Sorry, the session should be ".(Input::get($parameters[3]) + 1).'/'.(Input::get($parameters[3]) +2);
                                }

                            }else{
                                return "Sorry, the next term is First Term of the next class";
                            }

                break;
            }

        });
        
        
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
